/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.prompts.BaseHandler;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.IXMLParser;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RDSErrorXMLHandler
extends BaseHandler {
    private static final Class CLASS = RDSErrorXMLHandler.class;
    private static final int TOKEN_NONE = 0;
    private static final int TOKEN_RDS_ERROR = 1;
    private static final int TOKEN_RDS_MESSAGE = 2;
    private static final int TOKEN_RDS_TRACE = 3;
    private static final int TOKEN_ERROR = 4;
    private static final int TOKEN_MESSAGE = 5;
    private static final int TOKEN_TRACE = 6;
    private String message;
    private String trace;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTrace() {
        return this.trace;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    private int lookupToken(String s) {
        if (s.equalsIgnoreCase("rds:error")) {
            return 1;
        }
        if (s.equalsIgnoreCase("error")) {
            return 4;
        }
        if (s.equalsIgnoreCase("rds:message")) {
            return 2;
        }
        if (s.equalsIgnoreCase("message")) {
            return 5;
        }
        if (s.equalsIgnoreCase("rds:trace")) {
            return 3;
        }
        if (s.equalsIgnoreCase("trace")) {
            return 6;
        }
        return 0;
    }

    public void doParse(IXMLParser xmlParser, InputStream inputStream) throws SAXException, IOException {
        try {
            xmlParser.parse(inputStream, this);
        }
        catch (SAXException sax) {
            throw sax;
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable ex) {
            VM.log(CLASS, 3, "parser failure", ex);
            throw new SAXException(ex.toString());
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXParseException {
        VM.log(CLASS, 0, "start: " + qName);
        int token = this.lookupToken(qName);
        switch (token) {
            case 4: {
                this.message = null;
                this.trace = null;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                this.captureText(true);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        int token = this.lookupToken(qName);
        switch (token) {
            case 2: 
            case 5: {
                this.message = this.getText();
                break;
            }
            case 3: 
            case 6: {
                this.trace = this.getText();
                break;
            }
        }
    }
}

