/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RemoteExceptionSimplifier {
    private static final Pattern p = Pattern.compile("([A-Z]{2,3}-[A-Z]{3}-[0-9]{4})([^<]*)<");

    public String process(String message) {
        StringBuffer sb = new StringBuffer();
        String[] trace = RemoteExceptionSimplifier.simplifyMsg(message);
        for (int i = 0; i < trace.length; ++i) {
            if (trace[i] == null || trace[i].indexOf("Trace back:") >= 0) continue;
            sb.append(trace[i]);
            if (trace[i].endsWith("\n")) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String[] simplifyMsg(String trace) {
        if (trace == null) {
            return new String[0];
        }
        ArrayList<String> l = new ArrayList<String>();
        Matcher m = p.matcher(trace);
        while (m.find()) {
            l.add(m.group(1) + m.group(2));
        }
        return l.toArray(new String[l.size()]);
    }
}

