/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.standardedition.InputStreamFactory;
import com.cognos.mobile.standardedition.MyImageOutputStream;
import com.cognos.mobile.vm.VM;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class SEAwtHelper {
    private static Class CLASS = SEAwtHelper.class;

    public static boolean transcodeAndResizeImage(String inPath, String outPath, int maxArea, int outFormat) {
        ImageOutputStream outStream;
        FileInputStream inStream;
        try {
            File inFile = new File(inPath);
            if (!inFile.canRead()) {
                return false;
            }
            inStream = new FileInputStream(inFile);
        }
        catch (IOException ex) {
            VM.log(CLASS, 3, "failed to read image", ex);
            return false;
        }
        try {
            File outFile = new File(outPath);
            outFile.createNewFile();
            if (!outFile.canWrite()) {
                return false;
            }
            outStream = ImageIO.createImageOutputStream(outFile);
        }
        catch (IOException ex) {
            VM.log(CLASS, 3, "failed to write new image", ex);
            return false;
        }
        return SEAwtHelper.transformStream(inStream, outStream, maxArea, outFormat);
    }

    public static boolean transcodeAndResizeImage(InputStream inStream, OutputStream outStream, int maxArea, int outFormat) {
        MyImageOutputStream out = new MyImageOutputStream(outStream);
        return SEAwtHelper.transformStream(inStream, out, maxArea, outFormat);
    }

    public static boolean transcodeAndResizeImage(InputStream inStream, File outFile, int maxArea, int outFormat) {
        FileImageOutputStream outStream;
        try {
            outStream = new FileImageOutputStream(outFile);
        }
        catch (IOException ex) {
            VM.log(CLASS, 3, "failed to create output stream", ex);
            return false;
        }
        return SEAwtHelper.transformStream(inStream, outStream, maxArea, outFormat);
    }

    public static boolean saveAwtImage(BufferedImage awtImage, ImageOutputStream imageOutStream, OutputStream outStream, int outFormat) {
        String formatName;
        switch (outFormat) {
            case 2: {
                formatName = "jpeg";
                break;
            }
            case 1: {
                formatName = "png";
                break;
            }
            default: {
                formatName = null;
            }
        }
        if (formatName == null) {
            VM.log(CLASS, 3, "invalid format: " + outFormat);
            return false;
        }
        try {
            if (imageOutStream != null) {
                ImageIO.write((RenderedImage)awtImage, formatName, imageOutStream);
                imageOutStream.close();
            } else if (outStream != null) {
                ImageIO.write((RenderedImage)awtImage, formatName, outStream);
                outStream.close();
            }
        }
        catch (IOException ex) {
            VM.log(CLASS, 3, "failed to write output image", ex);
            return false;
        }
        return true;
    }

    private static boolean transformStream(InputStream inStream, ImageOutputStream outStream, int maxArea, int outFormat) {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(InputStreamFactory.slurpStream(inStream));
            MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(bin);
            Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
            if (it == null || !it.hasNext()) {
                VM.log(CLASS, 3, "failed to create image reader");
                return false;
            }
            ImageReader reader = it.next();
            BufferedImage image = null;
            String format = reader.getFormatName();
            if (format != null && format.toUpperCase().equals("JPEG")) {
                try {
                    bin.reset();
                    SEAwtHelper.class.getClass();
                    Class<?> clazz = Class.forName("com.sun.image.codec.jpeg.JPEGCodec");
                    Method m = clazz.getDeclaredMethod("createJPEGDecoder", InputStream.class);
                    Object o = m.invoke(null, bin);
                    Method mm = o.getClass().getDeclaredMethod("decodeAsBufferedImage", new Class[0]);
                    image = (BufferedImage)mm.invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    reader.setInput(iis);
                    image = reader.read(0);
                }
            } else {
                reader.setInput(iis);
                image = reader.read(0);
            }
            if (maxArea != -1) {
                image = SEAwtHelper.resizeImage(image, maxArea);
            }
            return SEAwtHelper.saveAwtImage(image, outStream, null, outFormat);
        }
        catch (IOException ex) {
            VM.log(CLASS, 3, "failed to read image", ex);
            return false;
        }
    }

    private static BufferedImage resizeImage(BufferedImage sourceImage, int maxArea) {
        double sqrtScale = 0.0;
        int newWidth = sourceImage.getWidth();
        int newHeight = sourceImage.getHeight();
        int imageArea = newWidth * newHeight;
        if (maxArea != -1 && imageArea > maxArea) {
            sqrtScale = Math.sqrt((double)maxArea / (double)imageArea);
            newWidth = (int)((double)newWidth * sqrtScale + 0.5);
            newHeight = (int)((double)newHeight * sqrtScale + 0.5);
        }
        if (newWidth == sourceImage.getWidth() && newHeight == sourceImage.getHeight()) {
            return sourceImage;
        }
        AreaAveragingScaleFilter scaleFilter = new AreaAveragingScaleFilter(newWidth, newHeight);
        FilteredImageSource destImageSource = new FilteredImageSource(sourceImage.getSource(), scaleFilter);
        BufferedImage destImage = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g = destImage.createGraphics();
        g.drawImage(Toolkit.getDefaultToolkit().createImage(destImageSource), 0, 0, null);
        g.dispose();
        return destImage;
    }
}

