/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.CMColorHelper;
import com.cognos.mobile.common.CMMathHelper;
import com.cognos.mobile.common.IInputStreamFactory;
import com.cognos.mobile.standardedition.ISEPainterHost;
import com.cognos.mobile.standardedition.SEAwtImage;
import com.cognos.mobile.standardedition.SEPainter;
import com.cognos.mobile.vm.IVMImage;
import com.cognos.mobile.vm.IVMPainter;
import com.cognos.mobile.vm.VMPoint;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class SEAwtPainter
extends SEPainter {
    private static Class CLASS = SEAwtPainter.class;
    private static final boolean DEBUG_TRACK_OFFSETS = false;
    private ISEPainterHost host;
    private Graphics2D graphics;
    private BufferedImage awtImage;
    private int offsetX;
    private int offsetY;
    private int m_ascent;
    private Color m_awtColor;
    private int currentFontFlags;
    private double currentFontScale;
    private boolean m_isUnderline;
    private IInputStreamFactory inFact;
    private boolean isDemoMode;

    public SEAwtPainter(IInputStreamFactory inFact, boolean isDemoMode) {
        this.inFact = inFact;
        this.isDemoMode = isDemoMode;
    }

    @Override
    public void initialize(ISEPainterHost host, int cx, int cy, int offsetX, int offsetY) {
        this.host = host;
        this.awtImage = new BufferedImage(cx, cy, 1);
        this.graphics = this.awtImage.createGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.graphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.graphics.setBackground(Color.WHITE);
        this.graphics.clearRect(0, 0, cx, cy);
        this.commonConstruct(offsetX, offsetY);
    }

    @Override
    public void addOffset(int dx, int dy) {
        this.offsetX += dx;
        this.offsetY += dy;
    }

    @Override
    public IVMImage createImage(int imageType, byte[] bytes) {
        BufferedImage awtImage;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            awtImage = ImageIO.read(in);
        }
        catch (IOException ex) {
            return null;
        }
        return new SEAwtImage(awtImage);
    }

    @Override
    public void cropImage(int imageType, byte[] bytes, int w, int h) {
        BufferedImage croppedImage = this.getCroppedImage(imageType, bytes, w, h);
        if (croppedImage != null) {
            SEAwtImage image = new SEAwtImage(croppedImage);
            this.drawImage(0, 0, image);
        }
    }

    public BufferedImage getCroppedImage(int imageType, byte[] bytes, int w, int h) {
        BufferedImage awtImage;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            awtImage = ImageIO.read(in);
        }
        catch (IOException ex) {
            return null;
        }
        BufferedImage dest = new BufferedImage(w, h, 2);
        Graphics2D graphics = dest.createGraphics();
        w = Math.min(w, awtImage.getWidth());
        h = Math.min(h, awtImage.getHeight());
        graphics.drawImage(awtImage, 0, 0, w, h, 0, 0, w, h, null);
        graphics.dispose();
        return dest;
    }

    @Override
    public IVMImage createImage(String url) {
        BufferedImage awtImage;
        try {
            Hashtable camCookies = this.host != null ? this.host.onPainterGetCamCookies(this) : null;
            InputStream in = this.inFact.create(url, null, camCookies, null, null, null);
            if (in == null) {
                return null;
            }
            awtImage = ImageIO.read(in);
        }
        catch (Exception ex) {
            return null;
        }
        return new SEAwtImage(awtImage);
    }

    @Override
    public IVMImage createImage(int cx, int cy) {
        BufferedImage awtImage = new BufferedImage(cx, cy, 1);
        Graphics2D g = awtImage.createGraphics();
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, cx, cy);
        return new SEAwtImage(awtImage);
    }

    @Override
    public IVMPainter createImagePainter(int cxImage, int cyImage) {
        SEAwtPainter painter = new SEAwtPainter(this.inFact, this.isDemoMode);
        painter.initialize(this.host, cxImage, cyImage, 0, 0);
        return painter;
    }

    @Override
    public void dispose() {
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
        if (this.awtImage != null) {
            this.awtImage = null;
        }
    }

    @Override
    public void drawImage(int x, int y, IVMImage image) {
        BufferedImage awtImage = ((SEAwtImage)image).getAwtImage();
        if (awtImage != null) {
            this.graphics.drawImage((Image)awtImage, this.offsetX + x, this.offsetY + y, null);
        }
    }

    @Override
    public boolean drawStretchedImage(int x, int y, int cx, int cy, IVMImage image) {
        if (image != null && image instanceof SEAwtImage) {
            BufferedImage awtImage = ((SEAwtImage)image).getAwtImage();
            this.graphics.drawImage(awtImage, x, y, cx, cy, 0, 0, image.onImageGetSize().x, image.onImageGetSize().y, null);
            return true;
        }
        return false;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.setColor(this.m_awtColor);
        this.graphics.drawLine(this.offsetX + x1, this.offsetY + y1, this.offsetX + x2, this.offsetY + y2);
    }

    @Override
    public String drawRect(boolean[] borderDisplay, int[] borderColor, int x, int y, int cx, int cy) {
        if (cx > 0 && cy > 0) {
            int left = this.offsetX + x;
            int top = this.offsetY + y;
            int right = this.offsetX + cx - (cx == 0 ? 0 : 1);
            int bottom = this.offsetY + cy - (cy == 0 ? 0 : 1);
            if (borderDisplay[0] && borderColor[0] != 0xF000000) {
                this.setColor(borderColor[0]);
                this.graphics.setColor(this.m_awtColor);
                this.graphics.drawLine(left, top, right, top);
            }
            if (borderDisplay[1] && borderColor[1] != 0xF000000) {
                this.setColor(borderColor[1]);
                this.graphics.setColor(this.m_awtColor);
                this.graphics.drawLine(right, top, right, bottom);
            }
            if (borderDisplay[2] && borderColor[2] != 0xF000000) {
                this.setColor(borderColor[2]);
                this.graphics.setColor(this.m_awtColor);
                this.graphics.drawLine(left, bottom, right, bottom);
            }
            if (borderDisplay[3] && borderColor[3] != 0xF000000) {
                this.setColor(borderColor[3]);
                this.graphics.setColor(this.m_awtColor);
                this.graphics.drawLine(left, top, left, bottom);
            }
        }
        return null;
    }

    @Override
    public void drawRect(int x, int y, int cx, int cy) {
        if (cx > 0 && cy > 0) {
            this.graphics.setColor(this.m_awtColor);
            this.graphics.drawRect(this.offsetX + x, this.offsetY + y, cx, cy);
        }
    }

    public void drawSelection(int x, int y, int cx, int cy) {
    }

    @Override
    public void drawString(int x, int y, String string) {
        this.graphics.setColor(this.m_awtColor);
        this.graphics.drawString(string, this.offsetX + x, this.offsetY + this.m_ascent + y);
        if (this.m_isUnderline) {
            FontMetrics fm = this.graphics.getFontMetrics();
            int left = this.offsetX + x;
            int right = left + fm.stringWidth(string);
            int baseline = this.offsetY + y + this.m_ascent + fm.getDescent();
            this.graphics.drawLine(left, baseline, right, baseline);
        }
    }

    public void fillPolygon(int[] x, int[] y) {
        this.graphics.setColor(this.m_awtColor);
        this.graphics.fillPolygon(x, y, x.length);
    }

    @Override
    public String fillRect(int x, int y, int cx, int cy) {
        if (cx > 0 && cy > 0) {
            this.graphics.setColor(this.m_awtColor);
            this.graphics.fillRect(this.offsetX + x, this.offsetY + y, cx, cy);
        }
        return null;
    }

    @Override
    public int getFontHeight() {
        return this.graphics.getFontMetrics().getHeight();
    }

    @Override
    public IVMImage getImage() {
        if (this.awtImage == null) {
            return null;
        }
        return new SEAwtImage(this.awtImage);
    }

    @Override
    public IVMImage releaseImage() {
        SEAwtImage image = new SEAwtImage(this.awtImage);
        this.awtImage = null;
        return image;
    }

    @Override
    public VMPoint measureString(String string) {
        FontMetrics fm = this.graphics.getFontMetrics();
        VMPoint size = new VMPoint();
        size.y = fm.getHeight();
        size.x = fm.stringWidth(string);
        return size;
    }

    @Override
    public int getWidth(String string) {
        FontMetrics fm = this.graphics.getFontMetrics();
        return fm.stringWidth(string);
    }

    @Override
    public int getHeight(String string) {
        FontMetrics fm = this.graphics.getFontMetrics();
        return fm.getHeight();
    }

    public void setClip(int x, int y, int cx, int cy) {
        this.graphics.setClip(this.offsetX + x, this.offsetY + y, cx, cy);
    }

    @Override
    public void setBackgroundColor(int color) {
        this.graphics.setBackground(this.createAwtColor(color));
    }

    @Override
    public void setColor(int color) {
        this.m_awtColor = this.createAwtColor(color);
    }

    @Override
    public boolean isSupportedTextScale(double scale) {
        return !this.isDemoMode;
    }

    @Override
    public void setFont(int font, double scale) {
        Font newFont = null;
        if (this.currentFontFlags == font && Math.abs(this.currentFontScale - scale) < 0.001) {
            return;
        }
        this.m_isUnderline = false;
        if ((font & 8) != 0) {
            int fontSize = this.host.onPainterGetFontSize(this, 8);
            String fontName = this.host.onPainterGetFontName(this, 8);
            newFont = new Font(fontName, 0, fontSize);
        } else {
            int style = 0;
            int fontSize = CMMathHelper.multiplyIntByDouble(this.host.onPainterGetFontSize(this, 0), scale);
            String fontName = this.host.onPainterGetFontName(this, 0);
            if ((font & 1) != 0) {
                style |= 1;
            }
            if ((font & 4) != 0) {
                style |= 2;
            }
            if ((font & 2) != 0) {
                this.m_isUnderline = true;
            }
            newFont = new Font(fontName, style, fontSize);
        }
        if (newFont != null) {
            this.graphics.setFont(newFont);
            this.currentFontFlags = font;
            this.currentFontScale = scale;
            this.m_ascent = this.graphics.getFontMetrics().getAscent();
        }
    }

    private void commonConstruct(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.currentFontFlags = -1;
        this.currentFontScale = 0.0;
        this.setBackgroundColor(0xFFFFFF);
        this.setColor(0);
        this.setFont(0, 1.0);
    }

    private Color createAwtColor(int vmColor) {
        int r = CMColorHelper.getRed(vmColor);
        int g = CMColorHelper.getGreen(vmColor);
        int b = CMColorHelper.getBlue(vmColor);
        Color awtColor = new Color(r, g, b);
        return awtColor;
    }
}

