/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.CMPathHelper;
import com.cognos.mobile.common.CMPathTokenizer;
import java.io.File;
import java.io.IOException;

public class SEPathHelper {
    public static String s_tempRootDir = null;

    public static void ensureDirExists(String path) throws IOException {
        String pathPart;
        CMPathTokenizer tokenizer = new CMPathTokenizer(0, path);
        String pathSoFar = "";
        while (null != (pathPart = tokenizer.getNextPathPart()) && !CMPathHelper.isFile(pathPart)) {
            File f = new File(pathSoFar = pathSoFar + pathPart);
            if (f.exists()) continue;
            f.mkdir();
        }
    }

    public static File getTempDir(String subdir) throws IOException {
        return new File(SEPathHelper.getTempDirPath(subdir));
    }

    public static String getTempDirPath(String subdir) throws IOException {
        if (s_tempRootDir == null) {
            File tempFile = File.createTempFile("mobile", null);
            tempFile.deleteOnExit();
            CMPathHelper.SplitPathResult splitPath = CMPathHelper.splitPath(tempFile.getAbsolutePath().replace('\\', '/'));
            s_tempRootDir = splitPath.dir;
        }
        String tempDir = s_tempRootDir;
        if (subdir != null) {
            tempDir = tempDir + subdir;
            tempDir = CMPathHelper.ensureDir(tempDir);
        }
        SEPathHelper.ensureDirExists(tempDir);
        return tempDir;
    }

    public static String getTempFilePath(String subdir, String prefix, String suffix) throws IOException {
        String path = SEPathHelper.getTempDirPath(subdir);
        File f = File.createTempFile(prefix, suffix);
        path = path + f.getName();
        f.delete();
        return path;
    }

    public static boolean deleteFile(String path) {
        File f = new File(path);
        if (f.exists()) {
            return f.delete();
        }
        return false;
    }

    public static String safeAppendPath(String base, String path) {
        if (path == null || base == null || path.length() == 0) {
            return base;
        }
        if (path.contains("..")) {
            throw new IllegalArgumentException("Invalid path element.");
        }
        String result = base;
        if (!base.endsWith("/")) {
            result = result + "/";
        }
        return result + (path.startsWith("/") ? path.substring(1) : path);
    }
}

