/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.vm.VM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class SERes {
    public static SERes singleton;
    private Class CLASS = SERes.class;
    private String[] m_basenames;
    private Hashtable m_bundlesCache = new Hashtable();

    public static void initialize(String[] basenames) {
        singleton = new SERes(basenames);
    }

    public String getString(String key, Locale locale) {
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        for (int pass = 0; pass < 3; ++pass) {
            switch (pass) {
                case 0: {
                    break;
                }
                case 1: {
                    this.loadBundles(locale);
                    break;
                }
                case 2: {
                    this.loadBundles(Locale.ENGLISH);
                }
            }
            BundlesCacheObject bundles = (BundlesCacheObject)this.m_bundlesCache.get(locale);
            if (bundles == null) continue;
            for (int i = 0; i < bundles.bundles.length; ++i) {
                try {
                    String value;
                    String string = value = bundles.bundles[i] != null ? bundles.bundles[i].getString(key) : null;
                    if (value == null) continue;
                    return value;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        VM.log(this.CLASS, 2, "missing string: key=" + key + " for locale: " + locale.toString());
        VM.log(this.CLASS, 2, "The locale may not be supported by IBM Cognos Mobile. Please see product conformance for further details.");
        return key;
    }

    public String formatString(String key, String p1, Locale locale) {
        return CMStringHelper.formatString(this.getString(key, locale), p1);
    }

    public String formatString(String key, String[] params, Locale locale) {
        return CMStringHelper.formatString(this.getString(key, locale), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadStringFromResFile(String path) {
        InputStream input = null;
        try {
            for (int i = 0; i < this.m_basenames.length && (input = Class.class.getResourceAsStream(this.m_basenames[i] + "/" + path)) == null; ++i) {
                try {
                    input = new FileInputStream(this.m_basenames[i] + "/" + path);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (input != null) break;
            }
            if (input == null) {
                VM.log(this.CLASS, 3, "failed to load file: " + path);
                String i = null;
                return i;
            }
            int length = input.available();
            if (length <= 0) {
                length = 10240;
            }
            byte[] data = new byte[length];
            input.read(data);
            String s = new String(data, "UTF-8");
            if (s.length() < 100) {
                s.intern();
            }
            String string = s;
            return string;
        }
        catch (Exception ex) {
            VM.log(this.CLASS, 3, "failed to load file " + path + ": " + ex.toString());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception ex) {
                    VM.log(this.CLASS, 3, "failed to close image " + path + ": " + ex.toString());
                }
            }
        }
        return new String("");
    }

    protected SERes(String[] basenames) {
        this.m_basenames = basenames;
    }

    protected void loadBundles(Locale locale) {
        ResourceBundle[] bundles = new ResourceBundle[this.m_basenames.length];
        for (int i = 0; i < this.m_basenames.length; ++i) {
            bundles[i] = this.findBundle(this.m_basenames[i], locale);
        }
        this.m_bundlesCache.put(locale, new BundlesCacheObject(bundles));
    }

    protected PropertyResourceBundle findBundle(String basename, Locale locale) {
        PropertyResourceBundle bundle;
        File file = null;
        String language = locale.getLanguage();
        language = language.contains("-") ? language.substring(0, 2) : language;
        String country = locale.getCountry();
        if (language.length() > "en".length()) {
            country = country.isEmpty() ? language.substring(3) : country;
        }
        for (int pass = 0; pass < 3; ++pass) {
            String pathname = null;
            String fileExt = ".properties";
            switch (pass) {
                case 0: {
                    pathname = basename + "_" + language + "_" + country + fileExt;
                    break;
                }
                case 1: {
                    pathname = basename + "_" + language + fileExt;
                    break;
                }
                case 2: {
                    pathname = basename + fileExt;
                }
            }
            file = new File(pathname);
            if (file.isFile() && file.canRead()) break;
            file = null;
        }
        if (file == null) {
            return null;
        }
        try {
            bundle = new PropertyResourceBundle(new FileInputStream(file));
        }
        catch (IOException ex) {
            String message = "failed to load bundle: " + file.getPath();
            VM.log(this.CLASS, 3, message, ex);
            return null;
        }
        return bundle;
    }

    protected class BundlesCacheObject {
        public ResourceBundle[] bundles;

        public BundlesCacheObject(ResourceBundle[] bundles) {
            this.bundles = bundles;
        }
    }
}

