/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.CMColorHelper;
import com.cognos.mobile.standardedition.SEAwtHelper;
import com.cognos.mobile.vm.VM;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.OutputStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class SESwtHelper {
    private static Class CLASS = SESwtHelper.class;

    public static Color vmColorToSwtColor(int vmColor) {
        int r = CMColorHelper.getRed(vmColor);
        int g = CMColorHelper.getGreen(vmColor);
        int b = CMColorHelper.getBlue(vmColor);
        Color swtColor = new Color(null, r, g, b);
        return swtColor;
    }

    public static int swtColorToVmColor(Color color) {
        RGB rgb = color.getRGB();
        return CMColorHelper.createColor(rgb.red, rgb.green, rgb.blue);
    }

    public static boolean saveSwtImage(Image swtImage, OutputStream outStream, int outFormat) {
        if (swtImage == null) {
            return false;
        }
        if (swtImage.getImageData() == null) {
            return false;
        }
        boolean rc = outFormat == 1 ? SESwtHelper.saveSwtImageUsingAwt(swtImage, outStream, outFormat) : SESwtHelper.saveSwtImageUsingSwt(swtImage, outStream, outFormat);
        return rc;
    }

    private static boolean saveSwtImageUsingSwt(Image swtImage, OutputStream outStream, int outFormat) {
        int swtFormat = 0;
        switch (outFormat) {
            case 1: {
                swtFormat = 5;
                break;
            }
            case 2: {
                swtFormat = 4;
            }
        }
        if (swtFormat == 0) {
            VM.log(CLASS, 3, "invalid format: " + outFormat);
            return false;
        }
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{swtImage.getImageData()};
        try {
            imageLoader.save(outStream, swtFormat);
        }
        catch (Exception ex) {
            VM.log(CLASS, 3, "failed to save image using SWT", ex);
            return false;
        }
        return true;
    }

    private static boolean saveSwtImageUsingAwt(Image swtImage, OutputStream outStream, int outFormat) {
        BufferedImage awtImage = SESwtHelper.convertToAWT(swtImage.getImageData());
        if (awtImage == null) {
            return false;
        }
        return SEAwtHelper.saveAwtImage(awtImage, null, outStream, outFormat);
    }

    private static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[4];
            for (int y = 0; y < data.height; ++y) {
                for (int x = 0; x < data.width; ++x) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    pixelArray[0] = rgb.red;
                    pixelArray[1] = rgb.green;
                    pixelArray[2] = rgb.blue;
                    pixelArray[3] = 255;
                    raster.setPixels(x, y, 1, 1, pixelArray);
                }
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        for (int i = 0; i < rgbs.length; ++i) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        for (int y = 0; y < data.height; ++y) {
            for (int x = 0; x < data.width; ++x) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
            }
        }
        return bufferedImage;
    }
}

