/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.standardedition.ISESwtDrawable;
import com.cognos.mobile.standardedition.SESwtHelper;
import com.cognos.mobile.vm.IVMImage;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMPoint;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class SESwtImage
implements IVMImage,
ISESwtDrawable {
    private static Class CLASS = SESwtImage.class;
    private Image m_swtImage;

    public SESwtImage() {
        this.m_swtImage = null;
    }

    public SESwtImage(Image swtImage) {
        this.m_swtImage = swtImage;
    }

    public Image getSwtImage() {
        return this.m_swtImage;
    }

    @Override
    public int getWidth() {
        return this.onImageGetSize().x;
    }

    @Override
    public int getHeight() {
        return this.onImageGetSize().y;
    }

    @Override
    public void draw(GC g, int x, int y, int cx, int cy) {
        Rectangle imageRect;
        Rectangle rect = g.getClipping();
        if (rect.intersects(imageRect = new Rectangle(x, y, this.onImageGetSize().x, this.onImageGetSize().y))) {
            g.drawImage(this.m_swtImage, x, y);
        }
    }

    @Override
    public void onSerializableSave(DataOutputStream out) throws IOException {
        int i;
        ImageData imageData = this.m_swtImage.getImageData();
        out.writeInt(imageData.width);
        out.writeInt(imageData.height);
        out.writeInt(imageData.depth);
        RGB[] paletteRGB = imageData.getRGBs();
        int count = paletteRGB == null ? 0 : paletteRGB.length;
        out.writeInt(count);
        for (i = 0; i < count; ++i) {
            RGB rgb = paletteRGB[i];
            out.writeByte(rgb.red);
            out.writeByte(rgb.green);
            out.writeByte(rgb.blue);
        }
        byte[] pixelData = imageData.data;
        count = pixelData.length;
        out.writeInt(imageData.scanlinePad);
        out.writeInt(count);
        for (i = 0; i < count; ++i) {
            out.writeByte(pixelData[i]);
        }
        VM.log(CLASS, 1, "saved: " + this.toString());
    }

    @Override
    public void onSerializableLoad(DataInputStream in) throws IOException {
        int i;
        int width = in.readInt();
        int height = in.readInt();
        int depth = in.readInt();
        if (width < 1 || height < 1 || depth < 1) {
            VM.log(CLASS, 3, "invalid dimensions: " + width + "x" + height + "x" + depth);
            throw new IOException();
        }
        int count = in.readInt();
        if (count < 0) {
            VM.log(CLASS, 3, "invalid palette count: " + count);
            throw new IOException();
        }
        RGB[] paletteRGB = new RGB[count];
        for (i = 0; i < count; ++i) {
            byte r = in.readByte();
            byte g = in.readByte();
            byte b = in.readByte();
            paletteRGB[i] = new RGB((int)r, (int)g, (int)b);
        }
        int scanlinePad = in.readInt();
        if (scanlinePad < 0) {
            VM.log(CLASS, 3, "invalid scanline pad: " + scanlinePad);
            throw new IOException();
        }
        count = in.readInt();
        if (count < 0) {
            VM.log(CLASS, 3, "invalid pixel count: " + count);
            throw new IOException();
        }
        try {
            byte[] pixelData = new byte[count];
            for (i = 0; i < count; ++i) {
                pixelData[i] = in.readByte();
            }
            PaletteData paletteData = new PaletteData(paletteRGB);
            ImageData imageData = new ImageData(width, height, depth, paletteData, scanlinePad, pixelData);
            this.m_swtImage = new Image(null, imageData);
        }
        catch (Exception ex) {
            VM.log(CLASS, 3, "failed to build image", ex);
            throw new IOException();
        }
        VM.log(CLASS, 1, "loaded: " + this.toString());
    }

    @Override
    public void onImageDispose() {
        this.m_swtImage.dispose();
    }

    @Override
    public void onImageGetRGB(int[] rgb, int offset, int scanLength, int x, int y, int cx, int cy) {
        ImageData imageData = this.m_swtImage.getImageData();
        PaletteData paletteData = imageData.palette;
        for (int dy = 0; dy < cy; ++dy) {
            int index = offset + dy * scanLength;
            for (int dx = 0; dx < cx; ++dx) {
                RGB swtColor = paletteData.getRGB(imageData.getPixel(x + dx, y + dy));
                rgb[index] = swtColor.red & 0xFF;
                int n = index;
                rgb[n] = rgb[n] << 8;
                int n2 = index;
                rgb[n2] = rgb[n2] | swtColor.green & 0xFF;
                int n3 = index;
                rgb[n3] = rgb[n3] << 8;
                int n4 = index++;
                rgb[n4] = rgb[n4] | swtColor.blue & 0xFF;
            }
        }
    }

    @Override
    public VMPoint onImageGetSize() {
        Rectangle bounds = this.m_swtImage.getBounds();
        VMPoint size = new VMPoint(bounds.width, bounds.height);
        return size;
    }

    @Override
    public void onImageSetRGB(int[] rgb, int offset, int scanLength, int x, int y, int cx, int cy) {
        ImageData imageData = this.m_swtImage.getImageData();
        PaletteData paletteData = imageData.palette;
        for (int dy = 0; dy < cy; ++dy) {
            int index = offset + dy * scanLength;
            for (int dx = 0; dx < cx; ++dx) {
                int pixel = rgb[index];
                int b = pixel & 0xFF;
                int g = (pixel >>= 8) & 0xFF;
                int r = (pixel >>= 8) & 0xFF;
                pixel = paletteData.getPixel(new RGB(r, g, b));
                imageData.setPixel(x + dx, y + dy, pixel);
                ++index;
            }
        }
        this.m_swtImage.dispose();
        this.m_swtImage = new Image(null, imageData);
    }

    @Override
    public void onImageSaveEncodedImage(int imageType, OutputStream out) throws CMException {
        SESwtHelper.saveSwtImage(this.m_swtImage, out, imageType);
    }
}

