/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.CMMathHelper;
import com.cognos.mobile.common.IInputStreamFactory;
import com.cognos.mobile.standardedition.ISEPainterHost;
import com.cognos.mobile.standardedition.ISESwtDrawable;
import com.cognos.mobile.standardedition.SEPainter;
import com.cognos.mobile.standardedition.SESwtHelper;
import com.cognos.mobile.standardedition.SESwtImage;
import com.cognos.mobile.vm.IVMImage;
import com.cognos.mobile.vm.IVMPainter;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMPoint;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SESwtPainter
extends SEPainter {
    private static final int SWT_DRAW_STRING_X_FUDGE = 1;
    private static Class CLASS = SESwtPainter.class;
    public static final boolean DEBUG_TRACK_OFFSETS = false;
    private ISEPainterHost host;
    private final boolean isFontScalingEnabled;
    private GC gc;
    private Image swtImage;
    private int offsetX;
    private int offsetY;
    private Color swtColor;
    private Color swtBackgroundColor;
    private Font currentFont;
    private int currentFontFlags;
    private double currentFontScale;
    private boolean isUnderline;
    private IInputStreamFactory inFact;

    public SESwtPainter(boolean isFontScalingEnabled, IInputStreamFactory inFact, ISEPainterHost host, GC gc, int offsetX, int offsetY) {
        this.isFontScalingEnabled = isFontScalingEnabled;
        this.inFact = inFact;
        this.initialize(host, gc, offsetX, offsetY);
    }

    public SESwtPainter(boolean isFontScalingEnabled, IInputStreamFactory inFact, ISEPainterHost host, int cxImage, int cyImage, int offsetX, int offsetY) {
        this.isFontScalingEnabled = isFontScalingEnabled;
        this.inFact = inFact;
        this.initialize(host, cxImage, cyImage, offsetX, offsetY);
    }

    public void initialize(ISEPainterHost host, GC gc, int offsetX, int offsetY) {
        this.host = host;
        this.swtImage = null;
        this.gc = gc;
        this.currentFontFlags = -1;
        this.currentFontScale = 0.0;
        this.currentFont = null;
        this.commonConstruct(offsetX, offsetY);
    }

    @Override
    public void initialize(ISEPainterHost host, int cx, int cy, int offsetX, int offsetY) {
        this.host = host;
        this.swtImage = new Image(null, cx, cy);
        this.gc = new GC((Drawable)this.swtImage);
        this.commonConstruct(offsetX, offsetY);
    }

    @Override
    public void addOffset(int dx, int dy) {
        this.offsetX += dx;
        this.offsetY += dy;
    }

    @Override
    public IVMImage createImage(int imageType, byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            Image swtImage = new Image(null, (InputStream)in);
            return new SESwtImage(swtImage);
        }
        catch (SWTException ex) {
            String s = new String(bytes);
            if (s != null && s.startsWith("<html>")) {
                VM.log(CLASS, 3, "ERROR RETURNED FROM DISPATCHER\n\n" + s);
            } else {
                VM.log(CLASS, 3, "failed to load image", ex);
            }
            return null;
        }
    }

    @Override
    public void cropImage(int imageType, byte[] bytes, int w, int h) {
    }

    @Override
    public IVMImage createImage(String url) {
        InputStream in;
        try {
            Hashtable camCookies = this.host != null ? this.host.onPainterGetCamCookies(this) : null;
            in = this.inFact.create(url, null, camCookies, null, null, null);
            if (in == null) {
                return null;
            }
        }
        catch (Exception ex) {
            return null;
        }
        Image swtImage = new Image(null, in);
        return new SESwtImage(swtImage);
    }

    @Override
    public IVMImage createImage(int cx, int cy) {
        Image swtImage = new Image(null, cx, cy);
        return new SESwtImage(swtImage);
    }

    @Override
    public IVMPainter createImagePainter(int cxImage, int cyImage) {
        SESwtPainter painter = new SESwtPainter(this.isFontScalingEnabled, this.inFact, this.host, cxImage, cyImage, 0, 0);
        return painter;
    }

    @Override
    public void dispose() {
        if (this.swtImage != null) {
            this.swtImage.dispose();
            this.swtImage = null;
        }
        if (this.swtColor != null) {
            this.swtColor.dispose();
            this.swtColor = null;
        }
        if (this.swtBackgroundColor != null) {
            this.swtBackgroundColor.dispose();
            this.swtBackgroundColor = null;
        }
        if (this.currentFont != null) {
            this.currentFont.dispose();
            this.currentFont = null;
        }
    }

    @Override
    public void drawImage(int x, int y, IVMImage image) {
        if (image instanceof ISESwtDrawable) {
            ISESwtDrawable d = (ISESwtDrawable)((Object)image);
            d.draw(this.gc, this.offsetX + x, this.offsetY + y, d.getWidth(), d.getHeight());
            return;
        }
        Image swtImage = ((SESwtImage)image).getSwtImage();
        this.gc.drawImage(swtImage, this.offsetX + x, this.offsetY + y);
    }

    @Override
    public boolean drawStretchedImage(int x, int y, int cx, int cy, IVMImage image) {
        if (image instanceof SESwtImage) {
            Image swtImage = ((SESwtImage)image).getSwtImage();
            this.gc.drawImage(swtImage, swtImage.getBounds().x, swtImage.getBounds().y, swtImage.getBounds().width, swtImage.getBounds().height, x, y, cx, cy);
            return true;
        }
        return false;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.gc.setForeground(this.swtColor);
        this.gc.drawLine(this.offsetX + x1, this.offsetY + y1, this.offsetX + x2, this.offsetY + y2);
    }

    @Override
    public String drawRect(boolean[] borderDisplay, int[] borderColor, int x, int y, int cx, int cy) {
        int left = this.offsetX + x;
        int top = this.offsetY + y;
        int right = this.offsetX + cx - (cx == 0 ? 0 : 1);
        int bottom = this.offsetY + cy - (cy == 0 ? 0 : 1);
        if (borderDisplay[0] && borderColor[0] != 0xF000000) {
            this.setColor(borderColor[0]);
            this.gc.setForeground(this.swtColor);
            this.gc.drawLine(left, top, right, top);
        }
        if (borderDisplay[1] && borderColor[1] != 0xF000000) {
            this.setColor(borderColor[1]);
            this.gc.setForeground(this.swtColor);
            this.gc.drawLine(right, top, right, bottom);
        }
        if (borderDisplay[2] && borderColor[2] != 0xF000000) {
            this.setColor(borderColor[2]);
            this.gc.setForeground(this.swtColor);
            this.gc.drawLine(left, bottom, right, bottom);
        }
        if (borderDisplay[3] && borderColor[3] != 0xF000000) {
            this.setColor(borderColor[3]);
            this.gc.setForeground(this.swtColor);
            this.gc.drawLine(left, top, left, bottom);
        }
        return null;
    }

    @Override
    public void drawRect(int x, int y, int cx, int cy) {
        if (cx > 0 && cy > 0) {
            this.gc.setForeground(this.swtColor);
            this.gc.drawRectangle(this.offsetX + x, this.offsetY + y, cx - 1, cy - 1);
        }
    }

    @Override
    public void drawString(int x, int y, String string) {
        this.gc.setForeground(this.swtColor);
        this.gc.drawString(string, this.offsetX + x + 1, this.offsetY + y, true);
        if (this.isUnderline) {
            Point extent = this.gc.textExtent(string);
            int left = this.offsetX + x + 1;
            int right = left + extent.x;
            int baseline = this.offsetY + y + extent.y - 2;
            this.gc.drawLine(left, baseline, right, baseline);
        }
    }

    @Override
    public String fillRect(int x, int y, int cx, int cy) {
        if (cx > 0 && cy > 0) {
            this.gc.setBackground(this.swtColor);
            this.gc.fillRectangle(this.offsetX + x, this.offsetY + y, cx, cy);
        }
        return null;
    }

    @Override
    public int getFontHeight() {
        Point extent = this.gc.textExtent("");
        return extent.y;
    }

    @Override
    public IVMImage getImage() {
        if (this.swtImage == null) {
            return null;
        }
        return new SESwtImage(this.swtImage);
    }

    @Override
    public IVMImage releaseImage() {
        SESwtImage image = new SESwtImage(this.swtImage);
        this.swtImage = null;
        return image;
    }

    @Override
    public VMPoint measureString(String string) {
        Point extent = this.gc.textExtent(string);
        return new VMPoint(extent.x, extent.y);
    }

    @Override
    public int getHeight(String string) {
        Point extent = this.gc.textExtent(string);
        return extent.y;
    }

    @Override
    public int getWidth(String string) {
        Point extent = this.gc.textExtent(string);
        return extent.x;
    }

    public void setClip(int x, int y, int cx, int cy) {
        this.gc.setClipping(this.offsetX + x, this.offsetY + y, cx, cy);
    }

    @Override
    public void setBackgroundColor(int color) {
        if (this.swtBackgroundColor != null) {
            this.swtBackgroundColor.dispose();
            this.swtBackgroundColor = null;
        }
        this.swtBackgroundColor = SESwtHelper.vmColorToSwtColor(color);
    }

    @Override
    public void setColor(int color) {
        if (this.swtColor != null) {
            this.swtColor.dispose();
            this.swtColor = null;
        }
        this.swtColor = SESwtHelper.vmColorToSwtColor(color);
    }

    @Override
    public boolean isSupportedTextScale(double scale) {
        return this.isFontScalingEnabled;
    }

    @Override
    public void setFont(int font, double scale) {
        Font newFont = null;
        if (this.currentFontFlags == font && Math.abs(this.currentFontScale - scale) < 0.001) {
            return;
        }
        this.isUnderline = false;
        if ((font & 8) != 0) {
            int fontSize = this.host.onPainterGetFontSize(this, 8);
            String fontName = this.host.onPainterGetFontName(this, 8);
            newFont = new Font(null, fontName, fontSize, 0);
        } else {
            int style = 0;
            int fontSize = CMMathHelper.multiplyIntByDouble(this.host.onPainterGetFontSize(this, 0), scale);
            String fontName = this.host.onPainterGetFontName(this, 0);
            if ((font & 1) != 0) {
                style |= 1;
            }
            if ((font & 4) != 0) {
                style |= 2;
            }
            if ((font & 2) != 0) {
                this.isUnderline = true;
            }
            newFont = new Font(null, fontName, fontSize, style);
        }
        if (newFont != null) {
            if (this.currentFont != null) {
                this.currentFont.dispose();
            }
            this.gc.setFont(newFont);
            this.currentFontFlags = font;
            this.currentFont = newFont;
            this.currentFontScale = scale;
        }
    }

    private void commonConstruct(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.setBackgroundColor(0xFFFFFF);
        this.setColor(0);
        this.setFont(0, 1.0);
    }
}

