/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.VM;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class SETransformHelper {
    private static Class CLASS = SETransformHelper.class;

    public static void transform(InputStream xslt, String xmlIn, Writer xmlOut) throws CMException {
        StreamSource xsltSource = new StreamSource(xslt);
        StreamSource xmlInSource = new StreamSource(new StringReader(xmlIn));
        StreamResult xmlOutResult = new StreamResult(xmlOut);
        SETransformHelper.transformCommon(xsltSource, xmlInSource, xmlOutResult);
    }

    public static void transform(InputStream xslt, InputStream xmlIn, Writer xmlOut) throws CMException {
        StreamSource xsltSource = new StreamSource(xslt);
        StreamSource xmlInSource = new StreamSource(xmlIn);
        StreamResult xmlOutResult = new StreamResult(xmlOut);
        SETransformHelper.transformCommon(xsltSource, xmlInSource, xmlOutResult);
    }

    private static void transformCommon(Source xsltSource, Source xmlInSource, StreamResult xmlOutResult) throws CMException {
        Transformer transformer;
        Properties p = System.getProperties();
        if (p != null) {
            p.put("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            transformer = factory.newTransformer(xsltSource);
        }
        catch (TransformerConfigurationException ex) {
            String details = "failed to create transformer";
            VM.log(CLASS, 3, details, ex);
            throw new CMException(1007, details, (Throwable)ex);
        }
        VM.log(CLASS, 1, "XSLT engine: " + transformer.toString());
        try {
            transformer.transform(xmlInSource, xmlOutResult);
        }
        catch (TransformerException ex) {
            String details = "failed to perform transform";
            VM.log(CLASS, 3, details, ex);
            throw new CMException(1007, details, (Throwable)ex);
        }
    }
}

