/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.vm.VM;
import com.cognos.pogo.http.ServerConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ServerConnectionInputStream
extends InputStream {
    private static final Class CLASS = ServerConnectionInputStream.class;
    private final InputStream in;
    private final ServerConnection sc;
    private final URL u;
    private int count;

    public ServerConnectionInputStream(URL u, ServerConnection sc, InputStream in) throws IOException {
        this.sc = sc;
        this.in = in;
        this.u = u;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.sc != null) {
            VM.log(CLASS, 0, "Read a total of: " + this.count + " bytes from " + this.u.toExternalForm());
            VM.log(CLASS, 0, "releasing ServerConnection connection...");
            this.sc.release();
            VM.log(CLASS, 0, "released ServerConnection connection.");
        }
        this.in.close();
    }

    public boolean equals(Object obj) {
        return this.in.equals(obj);
    }

    public int hashCode() {
        return this.in.hashCode();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        ++this.count;
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = this.in.read(b, off, len);
        this.count += i;
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int i = this.in.read(b);
        this.count += i;
        return i;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.count = 0;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        this.count += (int)skipped;
        return skipped;
    }

    public String toString() {
        return this.in.toString();
    }
}

