/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    private static final Pattern cleanPathP = Pattern.compile("(^/)|(/$)");
    private static final Pattern splitPathP = Pattern.compile("/");
    private static final Pattern argsP = Pattern.compile("(.*?)=(.*?)(&|$)");
    private static final String[] EMPTY_STRING = new String[0];

    public static String[] getPath(String pathInfo) {
        if (pathInfo == null) {
            return EMPTY_STRING;
        }
        String[] result = splitPathP.split(cleanPathP.matcher(pathInfo).replaceAll(""));
        if (result.length == 1 && result[0].length() == 0) {
            return null;
        }
        int i = result[result.length - 1].indexOf("?");
        if (i > 0) {
            result[result.length - 1] = result[result.length - 1].substring(0, i);
        }
        return result;
    }

    public static String maskPassport(String p) {
        if (p == null) {
            return null;
        }
        if (p.length() < 6) {
            return "<nonstandard passport format>";
        }
        String lastFour = p.substring(p.length() - 5);
        return "\"***********" + lastFour;
    }

    public static Map getArgs(String pathInfo) {
        if (pathInfo == null) {
            return Collections.EMPTY_MAP;
        }
        int i = pathInfo.indexOf("?");
        if (i == -1) {
            return Collections.EMPTY_MAP;
        }
        String argS = pathInfo.substring(i + 1, pathInfo.length());
        Matcher m = argsP.matcher(argS);
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (m.find()) {
            String key = m.group(1);
            String value = m.group(2);
            if (value.startsWith("[") && value.endsWith("]")) {
                String[] v = value.substring(1, value.length() - 1).split(",");
                ArrayList<String> l = new ArrayList<String>();
                for (int j = 0; j < v.length; ++j) {
                    l.add(v[j].trim());
                }
                map.put(key, l);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    public static String getParams(Map args) {
        StringBuffer sb = new StringBuffer();
        Set keys = args.keySet();
        if (keys.size() > 0) {
            try {
                Iterator it = keys.iterator();
                String key = (String)it.next();
                String value = (String)args.get(key);
                sb.append(URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8"));
                while (it.hasNext()) {
                    key = (String)it.next();
                    value = (String)args.get(key);
                    sb.append("&" + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8"));
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static boolean isMatch(String path, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(path);
        return matcher.find();
    }
}

