/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.ITooltipPainter;
import com.cognos.mobile.common.Tooltip;
import com.cognos.mobile.standardedition.SESwtHelper;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMColor;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class SwtTooltipPainter
implements ITooltipPainter {
    private final Class CLASS = SwtTooltipPainter.class;
    private final Control control;
    private final Font font;

    public SwtTooltipPainter(Control control) {
        this.control = control;
        this.font = new Font((Device)control.getDisplay(), "Tahoma", 8, 0);
    }

    @Override
    public void eraseTooltip(Object context, final VMRect rect) {
        final Control c = this.control;
        this.control.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                c.redraw(rect.x, rect.y, rect.cx, rect.cy, false);
            }
        });
    }

    @Override
    public VMPoint measureText(Object context, String line) {
        VMPoint size = new VMPoint();
        if (context == null || !(context instanceof GC)) {
            VM.log(this.CLASS, 3, "invalid context");
            return size;
        }
        GC gc = (GC)context;
        gc.setFont(this.font);
        Point swtSize = gc.textExtent(line);
        size.x = swtSize.x;
        size.y = swtSize.y;
        return size;
    }

    @Override
    public int getHeight(Object context, String line) {
        if (context == null || !(context instanceof GC)) {
            VM.log(this.CLASS, 3, "invalid context");
            return 0;
        }
        GC gc = (GC)context;
        Point swtSize = gc.textExtent(line);
        gc.setFont(this.font);
        return swtSize.y;
    }

    @Override
    public int getWidth(Object context, String line) {
        if (context == null || !(context instanceof GC)) {
            VM.log(this.CLASS, 3, "invalid context");
            return 0;
        }
        GC gc = (GC)context;
        Point swtSize = gc.textExtent(line);
        gc.setFont(this.font);
        return swtSize.x;
    }

    @Override
    public void paintTooltip(Object context, VMRect rect, String[] lines) {
        if (context == null || !(context instanceof GC)) {
            VM.log(this.CLASS, 3, "invalid context");
            return;
        }
        GC gc = (GC)context;
        this.eraseBackground(gc, rect);
        gc.setForeground(SESwtHelper.vmColorToSwtColor(VMColor.TOOLTIP_BORDER));
        gc.drawRectangle(rect.x, rect.y, rect.cx - 1, rect.cy - 1);
        gc.setFont(this.font);
        int x = rect.x + Tooltip.CX_EDGE;
        int y = rect.y + Tooltip.CY_EDGE;
        int dy = gc.textExtent((String)"").y;
        gc.setForeground(SESwtHelper.vmColorToSwtColor(VMColor.TOOLTIP_FOREGROUND));
        for (int i = 0; i < lines.length; ++i) {
            gc.drawString(lines[i], x, y);
            y += dy;
        }
    }

    private void eraseBackground(GC gc, VMRect rect) {
        gc.setBackground(SESwtHelper.vmColorToSwtColor(VMColor.TOOLTIP_BACKGROUND));
        gc.fillRectangle(rect.x, rect.y, rect.cx, rect.cy);
    }
}

