/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.IPersistenceStore;
import com.cognos.mobile.standardedition.DirectoryProcessor;
import com.cognos.mobile.vm.VM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TempFilePersistenceStore
implements IPersistenceStore {
    private static final Class CLASS = TempFilePersistenceStore.class;
    private static final Pattern cleaner = Pattern.compile("^[\\\\/]*(.+?)[\\\\/]*$");
    private final File dir;

    public TempFilePersistenceStore() throws IOException {
        File t = File.createTempFile("test", "test");
        this.dir = t.getParentFile();
        t.delete();
    }

    public TempFilePersistenceStore(File dir) {
        this.dir = dir;
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    @Override
    public String createTempPath(String prefix, String suffix, String path, boolean overwrite) throws IOException {
        Matcher m = cleaner.matcher(path);
        String cleaned = path;
        if (m.lookingAt()) {
            cleaned = m.group(1);
        }
        File cleanedF = new File(cleaned);
        File baseDir = this.dir;
        if (cleanedF.getParentFile() != null && !(baseDir = new File(this.dir.getAbsolutePath() + File.separator + cleanedF.getPath())).exists()) {
            baseDir.mkdirs();
        }
        File f = File.createTempFile(prefix, suffix, baseDir);
        f.createNewFile();
        String p = f.getAbsolutePath().substring(this.dir.getAbsolutePath().length());
        VM.log(CLASS, 0, "creating temp path: " + p);
        return p;
    }

    private File getFile(String path) {
        Matcher m = cleaner.matcher(path);
        String cleaned = path;
        if (m.lookingAt()) {
            cleaned = m.group(1);
        }
        File cleanedF = new File(cleaned);
        File baseDir = this.dir;
        if (cleanedF.getParentFile() != null && !(baseDir = new File(this.dir.getAbsolutePath() + File.separator + cleanedF.getParentFile().getPath())).exists()) {
            baseDir.mkdirs();
        }
        return new File(baseDir, cleanedF.getName());
    }

    @Override
    public OutputStream create(String path, boolean overwrite) throws IOException {
        File outF = this.getFile(path);
        VM.log(CLASS, 0, "creating: " + outF.getAbsolutePath());
        if (outF.exists() && overwrite) {
            outF.delete();
        }
        return new FileOutputStream(outF);
    }

    @Override
    public boolean exists(String path) {
        try {
            return this.get(path) != null;
        }
        catch (IOException ioe) {
            VM.log(CLASS, 0, "Couldn't look up path: " + path);
            return false;
        }
    }

    @Override
    public String[] findAllPaths() throws IOException {
        FindAll p = new FindAll(this.dir);
        p.processTree();
        List l = p.getList();
        return l.toArray(new String[l.size()]);
    }

    @Override
    public InputStream get(String path) throws IOException {
        File outF = this.getFile(path);
        VM.log(CLASS, 0, "getting: " + outF.getAbsolutePath());
        if (outF.exists()) {
            return new FileInputStream(outF);
        }
        return null;
    }

    @Override
    public boolean remove(String path) throws IOException {
        File outF = this.getFile(path);
        VM.log(CLASS, 0, "removing: " + outF.getAbsolutePath());
        if (!outF.exists()) {
            return false;
        }
        outF.delete();
        return true;
    }

    @Override
    public OutputStream createFileTempWriter(StringBuffer path, String tempSuffix) throws IOException {
        path.append(this.createTempPath("mob", tempSuffix, "", true));
        return this.create(path.toString(), true);
    }

    private class FindAll
    extends DirectoryProcessor {
        private final List l;

        FindAll(File dir) {
            super(dir);
            this.l = new ArrayList();
        }

        @Override
        protected final void processFile(File file) {
            String s = file.getAbsolutePath();
            this.l.add(s.substring(this.getRoot().getAbsolutePath().length() + 1));
        }

        final List getList() {
            return this.l;
        }
    }
}

