/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.drill.DrillContextAndTarget;
import com.cognos.mobile.drill.DrillContextParam;
import com.cognos.mobile.drill.DrillTargetParam;
import com.cognos.mobile.standardedition.IDrillthroughContextXMLHandler;
import com.cognos.mobile.standardedition.XMLSourceContextHandler;
import com.cognos.mobile.xml.IXMLParser;
import com.cognos.mobile.xml.XMLDrillThroughSelectionsHandler;
import com.cognos.mobile.xml.XMLHelper;
import com.cognos.mobile.xml.XMLStateHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDrillThroughContextHandler
extends XMLStateHandler
implements IDrillthroughContextXMLHandler {
    protected static final int STATE_DRILL_THROUGH = 1;
    protected static final int STATE_DRILL_CONTEXT = 2;
    protected static final int STATE_DRILL_INDEX = 3;
    protected static final int STATE_DRILL_PARAM = 4;
    protected static final int STATE_DRILL_PNAME = 5;
    protected static final int STATE_DRILL_PVALUE = 6;
    protected static final int STATE_DRILL_PMUN = 7;
    protected static final int STATE_DRILL_TARGET = 8;
    protected static final int STATE_DRILL_CMPATH = 9;
    protected static final int STATE_TARGET_PARAM = 10;
    protected static final int STATE_TARGET_PNAME = 11;
    protected static final int STATE_TARGET_PTYPE = 12;
    protected static final int STATE_TARGET_SPATH = 13;
    protected static final int STATE_AUTHORED_DRILL_REQUEST = 14;
    protected static final int STATE_PARAM = 15;
    protected static final int STATE_DRILL_PARAMETERS = 16;
    protected static final int STATE_DRILL_PARAMETER_PARAM = 17;
    private static final String MULTISELECTION_SIGNATURE = "<selectChoices";
    private DrillContextAndTarget drillContextTarget = null;
    private DrillTargetParam m_drillTarget = null;
    private DrillContextParam m_drillContext = null;
    private boolean inTargetParam = false;
    private boolean inSourceContext = false;
    private boolean inDrillParam = false;

    public XMLDrillThroughContextHandler() {
        super(true);
        this.addStateTransition("DrillThrough", 0, 1);
        this.addStateTransition("DrillContext", 1, 2);
        this.addStateTransition("DrillIndex", 2, 3);
        this.addStateTransition("Parameter", 2, 4);
        this.addStateTransition("name", 4, 5);
        this.addStateTransition("value", 4, 6);
        this.addStateTransition("mun", 4, 7);
        this.addStateTransition("DrillTarget", 1, 8);
        this.addStateTransition("cmPath", 8, 9);
        this.addStateTransition("Parameter", 8, 10);
        this.addStateTransition("name", 10, 11);
        this.addStateTransition("type", 10, 12);
        this.addStateTransition("pathObj", 8, 13);
        this.addStateTransition("authoredDrillRequest", 0, 14);
        this.addStateTransition("param", 14, 15);
        this.addStateTransition("drillParameters", 14, 16);
        this.addStateTransition("param", 16, 17);
    }

    @Override
    protected void onStateHandlerStartState(int state, Attributes attrs) throws SAXParseException {
        String name = null;
        switch (state) {
            case 1: 
            case 14: {
                this.drillContextTarget = new DrillContextAndTarget();
                break;
            }
            case 4: {
                this.m_drillContext = new DrillContextParam();
                break;
            }
            case 10: {
                this.m_drillTarget = new DrillTargetParam();
                break;
            }
            case 15: {
                name = attrs.getValue("name");
                if (name == null) break;
                if (name.equals("target")) {
                    this.inTargetParam = true;
                    break;
                }
                if (!name.equals("sourceContext")) break;
                this.inSourceContext = true;
                break;
            }
            case 17: {
                name = attrs.getValue("name");
                if (name == null) break;
                this.inDrillParam = true;
                this.m_drillContext = new DrillContextParam();
                this.m_drillContext.setName(name);
                break;
            }
            default: {
                this.inTargetParam = false;
                this.inSourceContext = false;
                this.inDrillParam = false;
            }
        }
    }

    @Override
    protected void onStateHandlerEndState(int state, String characters) throws SAXParseException {
        switch (state) {
            case 3: {
                this.drillContextTarget.getContext().setDrillIndex(CMStringHelper.parseInteger(characters, -1));
                break;
            }
            case 5: {
                if (this.m_drillContext == null) break;
                this.m_drillContext.setName(characters);
                break;
            }
            case 6: {
                if (this.m_drillContext == null) break;
                String xmlDecoded = XMLHelper.xmlDecode(characters);
                if (xmlDecoded.startsWith(MULTISELECTION_SIGNATURE)) {
                    try {
                        IXMLParser parser = new IXMLParser(){

                            @Override
                            public void parse(InputStream inputstream, DefaultHandler defaulthandler) throws SAXException, IOException {
                                try {
                                    SAXParserFactory.newInstance().newSAXParser().parse(inputstream, defaulthandler);
                                }
                                catch (ParserConfigurationException ex) {
                                    throw new SAXException(ex);
                                }
                            }
                        };
                        XMLDrillThroughSelectionsHandler handler = new XMLDrillThroughSelectionsHandler(this.m_drillContext);
                        ByteArrayInputStream stream = new ByteArrayInputStream(xmlDecoded.getBytes("UTF-8"));
                        handler.doParse(parser, stream);
                    }
                    catch (Exception parser) {}
                    break;
                }
                this.m_drillContext.setValue(xmlDecoded);
                break;
            }
            case 7: {
                if (this.m_drillContext == null) break;
                this.m_drillContext.setMun(characters);
                break;
            }
            case 4: {
                if (this.m_drillContext == null) break;
                this.drillContextTarget.getContext().addParameter(this.m_drillContext);
                this.m_drillContext = null;
                break;
            }
            case 9: {
                this.drillContextTarget.getTarget().setCMPath(characters);
                break;
            }
            case 10: {
                if (this.m_drillTarget == null) break;
                this.drillContextTarget.getTarget().addParameter(this.m_drillTarget.getName(), this.m_drillTarget.getType());
                this.m_drillTarget = null;
                break;
            }
            case 11: {
                if (this.m_drillTarget == null) break;
                this.m_drillTarget.setName(characters);
                break;
            }
            case 12: {
                if (this.m_drillTarget == null) break;
                this.m_drillTarget.setType(characters);
                break;
            }
            case 13: {
                this.drillContextTarget.getTarget().addSearchPathObject(characters);
                break;
            }
            case 15: {
                if (this.inTargetParam) {
                    this.drillContextTarget.getTarget().setCMPath(characters);
                    this.inTargetParam = false;
                    break;
                }
                if (!this.inSourceContext) break;
                String xmlDecoded = XMLHelper.xmlDecode(characters);
                try {
                    IXMLParser parser = new IXMLParser(){

                        @Override
                        public void parse(InputStream inputstream, DefaultHandler defaulthandler) throws SAXException, IOException {
                            try {
                                SAXParserFactory.newInstance().newSAXParser().parse(inputstream, defaulthandler);
                            }
                            catch (ParserConfigurationException ex) {
                                throw new SAXException(ex);
                            }
                        }
                    };
                    XMLSourceContextHandler handler = new XMLSourceContextHandler(this.drillContextTarget);
                    ByteArrayInputStream stream = new ByteArrayInputStream(xmlDecoded.getBytes("UTF-8"));
                    handler.doParse(parser, stream);
                }
                catch (Exception parser) {
                    // empty catch block
                }
                this.inSourceContext = false;
                break;
            }
            case 17: {
                if (this.inDrillParam && this.m_drillContext != null) {
                    String xmlDecoded = XMLHelper.xmlDecode(characters);
                    if (xmlDecoded.startsWith(MULTISELECTION_SIGNATURE)) {
                        try {
                            IXMLParser parser = new IXMLParser(){

                                @Override
                                public void parse(InputStream inputstream, DefaultHandler defaulthandler) throws SAXException, IOException {
                                    try {
                                        SAXParserFactory.newInstance().newSAXParser().parse(inputstream, defaulthandler);
                                    }
                                    catch (ParserConfigurationException ex) {
                                        throw new SAXException(ex);
                                    }
                                }
                            };
                            XMLDrillThroughSelectionsHandler handler = new XMLDrillThroughSelectionsHandler(this.m_drillContext);
                            ByteArrayInputStream stream = new ByteArrayInputStream(xmlDecoded.getBytes("UTF-8"));
                            handler.doParse(parser, stream);
                        }
                        catch (Exception exception) {}
                    } else {
                        this.m_drillContext.setValue(xmlDecoded);
                    }
                }
                this.drillContextTarget.getContext().addParameter(this.m_drillContext);
                this.m_drillContext = null;
                this.inDrillParam = false;
            }
        }
    }

    @Override
    protected void onStateHandlerInvalidElement(int state, String element) throws SAXParseException {
    }

    @Override
    public DrillContextAndTarget getDrillContext() {
        return this.drillContextTarget;
    }
}

