/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.status;

import com.cognos.mobile.status.IStatusProvider;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XMLHelper;

public class STStatusProviders {
    private static STStatusProviders instance = null;
    private Entry[] entries = new Entry[10];

    public static STStatusProviders getInstance() {
        if (instance == null) {
            VM.log(STStatusProviders.class, 0, "Creating STStatusProvider singleton");
            instance = new STStatusProviders();
        }
        return instance;
    }

    public static void dispose() {
        if (instance != null) {
            VM.log(STStatusProviders.class, 0, "disposing of STStatusProvider singleton");
            instance = null;
        }
    }

    public synchronized void addProvider(String name, IStatusProvider provider) {
        if (name != null && provider != null) {
            Entry entry = new Entry(name, provider);
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i] != null) continue;
                this.entries[i] = entry;
                return;
            }
            Entry[] l2 = new Entry[this.entries.length + 5];
            System.arraycopy(this.entries, 0, l2, 0, this.entries.length);
            l2[this.entries.length] = entry;
            this.entries = l2;
        }
    }

    public synchronized void removeProvider(IStatusProvider provider) {
        if (provider != null) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i] != provider) continue;
                this.entries[i] = null;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getStatus() {
        StringBuffer sb = new StringBuffer();
        sb.append("<status>\n");
        for (int i = 0; i < this.entries.length; ++i) {
            Entry entry = this.entries[i];
            if (entry == null) continue;
            sb.append("<component name='");
            sb.append(entry.name);
            sb.append("'>\n");
            try {
                sb.append(entry.provider.getStatus());
                continue;
            }
            catch (Exception t) {
                sb.append("<error>");
                sb.append(XMLHelper.encodeXml(t.toString()));
                sb.append("</error>");
                continue;
            }
            finally {
                sb.append("\n</component>\n");
            }
        }
        sb.append("\n</status>\n");
        return sb.toString();
    }

    private static class Entry {
        public String name;
        public IStatusProvider provider;

        public Entry(String name, IStatusProvider provider) {
            this.name = name;
            this.provider = provider;
        }
    }
}

