/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.tagsoup;

import com.cognos.mobile.tagsoup.AttributesImpl;
import com.cognos.mobile.tagsoup.AutoDetector;
import com.cognos.mobile.tagsoup.Element;
import com.cognos.mobile.tagsoup.ElementType;
import com.cognos.mobile.tagsoup.HTMLScanner;
import com.cognos.mobile.tagsoup.HTMLSchema;
import com.cognos.mobile.tagsoup.ScanHandler;
import com.cognos.mobile.tagsoup.Scanner;
import com.cognos.mobile.tagsoup.Schema;
import com.cognos.mobile.tagsoup.Util;
import com.cognos.mobile.xml.IXMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser
extends DefaultHandler
implements IXMLParser,
ScanHandler {
    private DefaultHandler theContentHandler = this;
    private Schema theSchema;
    private Scanner theScanner;
    private AutoDetector theAutoDetector;
    private static boolean DEFAULT_NAMESPACES = true;
    private static boolean DEFAULT_IGNORE_BOGONS = false;
    private static boolean DEFAULT_BOGONS_EMPTY = false;
    private static boolean DEFAULT_ROOT_BOGONS = true;
    private static boolean DEFAULT_DEFAULT_ATTRIBUTES = true;
    private static boolean DEFAULT_TRANSLATE_COLONS = false;
    private static boolean DEFAULT_RESTART_ELEMENTS = true;
    private static boolean DEFAULT_IGNORABLE_WHITESPACE = false;
    private static boolean DEFAULT_CDATA_ELEMENTS = true;
    private boolean namespaces = DEFAULT_NAMESPACES;
    private boolean ignoreBogons = DEFAULT_IGNORE_BOGONS;
    private boolean bogonsEmpty = DEFAULT_BOGONS_EMPTY;
    private boolean rootBogons = DEFAULT_ROOT_BOGONS;
    private boolean defaultAttributes = DEFAULT_DEFAULT_ATTRIBUTES;
    private boolean translateColons = DEFAULT_TRANSLATE_COLONS;
    private boolean restartElements = DEFAULT_RESTART_ELEMENTS;
    private boolean ignorableWhitespace = DEFAULT_IGNORABLE_WHITESPACE;
    private boolean CDATAElements = DEFAULT_CDATA_ELEMENTS;
    public static final String namespacesFeature = "http://xml.org/sax/features/namespaces";
    public static final String namespacePrefixesFeature = "http://xml.org/sax/features/namespace-prefixes";
    public static final String externalGeneralEntitiesFeature = "http://xml.org/sax/features/external-general-entities";
    public static final String externalParameterEntitiesFeature = "http://xml.org/sax/features/external-parameter-entities";
    public static final String isStandaloneFeature = "http://xml.org/sax/features/is-standalone";
    public static final String lexicalHandlerParameterEntitiesFeature = "http://xml.org/sax/features/lexical-handler/parameter-entities";
    public static final String resolveDTDURIsFeature = "http://xml.org/sax/features/resolve-dtd-uris";
    public static final String stringInterningFeature = "http://xml.org/sax/features/string-interning";
    public static final String useAttributes2Feature = "http://xml.org/sax/features/use-attributes2";
    public static final String useLocator2Feature = "http://xml.org/sax/features/use-locator2";
    public static final String useEntityResolver2Feature = "http://xml.org/sax/features/use-entity-resolver2";
    public static final String validationFeature = "http://xml.org/sax/features/validation";
    public static final String unicodeNormalizationCheckingFeature = "http://xml.org/sax/features/unicode-normalization-checking";
    public static final String xmlnsURIsFeature = "http://xml.org/sax/features/xmlns-uris";
    public static final String XML11Feature = "http://xml.org/sax/features/xml-1.1";
    public static final String ignoreBogonsFeature = "http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons";
    public static final String bogonsEmptyFeature = "http://www.ccil.org/~cowan/tagsoup/features/bogons-empty";
    public static final String rootBogonsFeature = "http://www.ccil.org/~cowan/tagsoup/features/root-bogons";
    public static final String defaultAttributesFeature = "http://www.ccil.org/~cowan/tagsoup/features/default-attributes";
    public static final String translateColonsFeature = "http://www.ccil.org/~cowan/tagsoup/features/translate-colons";
    public static final String restartElementsFeature = "http://www.ccil.org/~cowan/tagsoup/features/restart-elements";
    public static final String ignorableWhitespaceFeature = "http://www.ccil.org/~cowan/tagsoup/features/ignorable-whitespace";
    public static final String CDATAElementsFeature = "http://www.ccil.org/~cowan/tagsoup/features/cdata-elements";
    public static final String lexicalHandlerProperty = "http://xml.org/sax/properties/lexical-handler";
    public static final String scannerProperty = "http://www.ccil.org/~cowan/tagsoup/properties/scanner";
    public static final String schemaProperty = "http://www.ccil.org/~cowan/tagsoup/properties/schema";
    public static final String autoDetectorProperty = "http://www.ccil.org/~cowan/tagsoup/properties/auto-detector";
    private Hashtable theFeatures = new Hashtable();
    private Element theNewElement;
    private String theAttributeName;
    private String thePITarget;
    private Element theStack;
    private Element theSaved;
    private Element thePCDATA;
    private int theEntity;
    private static char[] etagchars = new char[]{'<', '/', '>'};
    private boolean virginStack;

    public Parser() {
        this.theFeatures.put(namespacesFeature, Parser.truthValue(DEFAULT_NAMESPACES));
        this.theFeatures.put(namespacePrefixesFeature, Boolean.FALSE);
        this.theFeatures.put(externalGeneralEntitiesFeature, Boolean.FALSE);
        this.theFeatures.put(externalParameterEntitiesFeature, Boolean.FALSE);
        this.theFeatures.put(isStandaloneFeature, Boolean.FALSE);
        this.theFeatures.put(lexicalHandlerParameterEntitiesFeature, Boolean.FALSE);
        this.theFeatures.put(resolveDTDURIsFeature, Boolean.TRUE);
        this.theFeatures.put(stringInterningFeature, Boolean.TRUE);
        this.theFeatures.put(useAttributes2Feature, Boolean.FALSE);
        this.theFeatures.put(useLocator2Feature, Boolean.FALSE);
        this.theFeatures.put(useEntityResolver2Feature, Boolean.FALSE);
        this.theFeatures.put(validationFeature, Boolean.FALSE);
        this.theFeatures.put(xmlnsURIsFeature, Boolean.FALSE);
        this.theFeatures.put(xmlnsURIsFeature, Boolean.FALSE);
        this.theFeatures.put(XML11Feature, Boolean.FALSE);
        this.theFeatures.put(ignoreBogonsFeature, Parser.truthValue(DEFAULT_IGNORE_BOGONS));
        this.theFeatures.put(bogonsEmptyFeature, Parser.truthValue(DEFAULT_BOGONS_EMPTY));
        this.theFeatures.put(rootBogonsFeature, Parser.truthValue(DEFAULT_ROOT_BOGONS));
        this.theFeatures.put(defaultAttributesFeature, Parser.truthValue(DEFAULT_DEFAULT_ATTRIBUTES));
        this.theFeatures.put(translateColonsFeature, Parser.truthValue(DEFAULT_TRANSLATE_COLONS));
        this.theFeatures.put(restartElementsFeature, Parser.truthValue(DEFAULT_RESTART_ELEMENTS));
        this.theFeatures.put(ignorableWhitespaceFeature, Parser.truthValue(DEFAULT_IGNORABLE_WHITESPACE));
        this.theFeatures.put(CDATAElementsFeature, Parser.truthValue(DEFAULT_CDATA_ELEMENTS));
        this.theNewElement = null;
        this.theAttributeName = null;
        this.thePITarget = null;
        this.theStack = null;
        this.theSaved = null;
        this.thePCDATA = null;
        this.theEntity = 0;
        this.virginStack = true;
    }

    private static Boolean truthValue(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean b = (Boolean)this.theFeatures.get(name);
        if (b == null) {
            throw new SAXNotRecognizedException("Unknown feature " + name);
        }
        return b;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean b = (Boolean)this.theFeatures.get(name);
        if (b == null) {
            throw new SAXNotRecognizedException("Unknown feature " + name);
        }
        if (value) {
            this.theFeatures.put(name, Boolean.TRUE);
        } else {
            this.theFeatures.put(name, Boolean.FALSE);
        }
        if (name.equals(namespacesFeature)) {
            this.namespaces = value;
        } else if (name.equals(ignoreBogonsFeature)) {
            this.ignoreBogons = value;
        } else if (name.equals(bogonsEmptyFeature)) {
            this.bogonsEmpty = value;
        } else if (name.equals(rootBogonsFeature)) {
            this.rootBogons = value;
        } else if (name.equals(defaultAttributesFeature)) {
            this.defaultAttributes = value;
        } else if (name.equals(translateColonsFeature)) {
            this.translateColons = value;
        } else if (name.equals(restartElementsFeature)) {
            this.restartElements = value;
        } else if (name.equals(ignorableWhitespaceFeature)) {
            this.ignorableWhitespace = value;
        } else if (name.equals(CDATAElementsFeature)) {
            this.CDATAElements = value;
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(scannerProperty)) {
            return this.theScanner;
        }
        if (name.equals(schemaProperty)) {
            return this.theSchema;
        }
        if (name.equals(autoDetectorProperty)) {
            return this.theAutoDetector;
        }
        throw new SAXNotRecognizedException("Unknown property " + name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(scannerProperty)) {
            if (!(value instanceof Scanner)) throw new SAXNotSupportedException("Your scanner is not a Scanner");
            this.theScanner = (Scanner)value;
            return;
        } else if (name.equals(schemaProperty)) {
            if (!(value instanceof Schema)) throw new SAXNotSupportedException("Your schema is not a Schema");
            this.theSchema = (Schema)value;
            return;
        } else {
            if (!name.equals(autoDetectorProperty)) throw new SAXNotRecognizedException("Unknown property " + name);
            if (!(value instanceof AutoDetector)) throw new SAXNotSupportedException("Your auto-detector is not an AutoDetector");
            this.theAutoDetector = (AutoDetector)value;
        }
    }

    public void setContentHandler(DefaultHandler handler) {
        this.theContentHandler = handler == null ? this : handler;
    }

    public DefaultHandler getContentHandler() {
        return this.theContentHandler == this ? null : this.theContentHandler;
    }

    private void setup() {
        if (this.theSchema == null) {
            this.theSchema = new HTMLSchema();
        }
        if (this.theScanner == null) {
            this.theScanner = new HTMLScanner();
        }
        if (this.theAutoDetector == null) {
            this.theAutoDetector = new AutoDetector(){

                @Override
                public Reader autoDetectingReader(InputStream i) {
                    return new InputStreamReader(i);
                }
            };
        }
        this.theStack = new Element(this.theSchema.getElementType("<root>"), this.defaultAttributes);
        this.thePCDATA = new Element(this.theSchema.getElementType("<pcdata>"), this.defaultAttributes);
        this.theNewElement = null;
        this.theAttributeName = null;
        this.thePITarget = null;
        this.theSaved = null;
        this.theEntity = 0;
        this.virginStack = true;
    }

    @Override
    public void adup(char[] buff, int offset, int length) throws SAXException {
        if (this.theNewElement == null || this.theAttributeName == null) {
            return;
        }
        this.theNewElement.setAttribute(this.theAttributeName, null, this.theAttributeName);
        this.theAttributeName = null;
    }

    @Override
    public void aname(char[] buff, int offset, int length) throws SAXException {
        if (this.theNewElement == null) {
            return;
        }
        this.theAttributeName = this.makeName(buff, offset, length).toLowerCase();
    }

    @Override
    public void aval(char[] buff, int offset, int length) throws SAXException {
        if (this.theNewElement == null || this.theAttributeName == null) {
            return;
        }
        String value = new String(buff, offset, length);
        value = this.expandEntities(value);
        this.theNewElement.setAttribute(this.theAttributeName, null, value);
        this.theAttributeName = null;
    }

    private String expandEntities(String src) {
        int refStart = -1;
        int len = src.length();
        char[] dst = new char[len];
        int dstlen = 0;
        for (int i = 0; i < len; ++i) {
            char ch = src.charAt(i);
            dst[dstlen++] = ch;
            if (ch == '&' && refStart == -1) {
                refStart = dstlen;
                continue;
            }
            if (refStart == -1 || Util.isLetter(ch) || Util.isDigit(ch) || ch == '#') continue;
            if (ch == ';') {
                int ent = this.lookupEntity(dst, refStart, dstlen - refStart - 1);
                if (ent > 65535) {
                    dst[refStart - 1] = (char)(((ent -= 65536) >> 10) + 55296);
                    dst[refStart] = (char)((ent & 0x3FF) + 56320);
                    dstlen = refStart + 1;
                } else if (ent != 0) {
                    dst[refStart - 1] = (char)ent;
                    dstlen = refStart;
                }
                refStart = -1;
                continue;
            }
            refStart = -1;
        }
        return new String(dst, 0, dstlen);
    }

    @Override
    public void entity(char[] buff, int offset, int length) throws SAXException {
        this.theEntity = this.lookupEntity(buff, offset, length);
    }

    private int lookupEntity(char[] buff, int offset, int length) {
        int result = 0;
        if (length < 1) {
            return result;
        }
        if (buff[offset] == '#') {
            if (length > 1 && (buff[offset + 1] == 'x' || buff[offset + 1] == 'X')) {
                try {
                    return Integer.parseInt(new String(buff, offset + 2, length - 2), 16);
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
            try {
                return Integer.parseInt(new String(buff, offset + 1, length - 1), 10);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return this.theSchema.getEntity(new String(buff, offset, length));
    }

    @Override
    public void eof(char[] buff, int offset, int length) throws SAXException {
        if (this.virginStack) {
            this.rectify(this.thePCDATA);
        }
        while (this.theStack.next() != null) {
            this.pop();
        }
        if (!this.theSchema.getURI().equals("")) {
            this.theContentHandler.endPrefixMapping(this.theSchema.getPrefix());
        }
        this.theContentHandler.endDocument();
    }

    @Override
    public void etag(char[] buff, int offset, int length) throws SAXException {
        if (this.etag_cdata(buff, offset, length)) {
            return;
        }
        this.etag_basic(buff, offset, length);
    }

    public boolean etag_cdata(char[] buff, int offset, int length) throws SAXException {
        String currentName = this.theStack.name();
        if (this.CDATAElements && (this.theStack.flags() & 2) != 0) {
            boolean realTag;
            boolean bl = realTag = length == currentName.length();
            if (realTag) {
                for (int i = 0; i < length; ++i) {
                    if (Character.toLowerCase(buff[offset + i]) == Character.toLowerCase(currentName.charAt(i))) continue;
                    realTag = false;
                    break;
                }
            }
            if (!realTag) {
                this.theContentHandler.characters(etagchars, 0, 2);
                this.theContentHandler.characters(buff, offset, length);
                this.theContentHandler.characters(etagchars, 2, 1);
                this.theScanner.startCDATA();
                return true;
            }
        }
        return false;
    }

    public void etag_basic(char[] buff, int offset, int length) throws SAXException {
        Element sp;
        String name;
        this.theNewElement = null;
        if (length != 0) {
            name = this.makeName(buff, offset, length);
            ElementType type = this.theSchema.getElementType(name);
            if (type == null) {
                return;
            }
            name = type.name();
        } else {
            name = this.theStack.name();
        }
        boolean inNoforce = false;
        for (sp = this.theStack; sp != null && !sp.name().equals(name); sp = sp.next()) {
            if ((sp.flags() & 4) == 0) continue;
            inNoforce = true;
        }
        if (sp == null) {
            return;
        }
        if (sp.next() == null || sp.next().next() == null) {
            return;
        }
        if (inNoforce) {
            sp.preclose();
        } else {
            while (this.theStack != sp) {
                this.restartablyPop();
            }
            this.pop();
        }
        while (this.theStack.isPreclosed()) {
            this.pop();
        }
        this.restart(null);
    }

    private void restart(Element e) throws SAXException {
        while (this.theSaved != null && this.theStack.canContain(this.theSaved) && (e == null || this.theSaved.canContain(e))) {
            Element next = this.theSaved.next();
            this.push(this.theSaved);
            this.theSaved = next;
        }
    }

    private void pop() throws SAXException {
        if (this.theStack == null) {
            return;
        }
        String name = this.theStack.name();
        String localName = this.theStack.localName();
        String namespace = this.theStack.namespace();
        String prefix = this.prefixOf(name);
        if (!this.namespaces) {
            localName = "";
            namespace = "";
        }
        this.theContentHandler.endElement(namespace, localName, name);
        if (this.foreign(prefix, namespace)) {
            this.theContentHandler.endPrefixMapping(prefix);
        }
        AttributesImpl atts = this.theStack.atts();
        for (int i = atts.getLength() - 1; i >= 0; --i) {
            String attNamespace = atts.getURI(i);
            String attPrefix = this.prefixOf(atts.getQName(i));
            if (!this.foreign(attPrefix, attNamespace)) continue;
            this.theContentHandler.endPrefixMapping(attPrefix);
        }
        this.theStack = this.theStack.next();
    }

    private void restartablyPop() throws SAXException {
        Element popped = this.theStack;
        this.pop();
        if (this.restartElements && (popped.flags() & 1) != 0) {
            popped.anonymize();
            popped.setNext(this.theSaved);
            this.theSaved = popped;
        }
    }

    private void push(Element e) throws SAXException {
        String name = e.name();
        String localName = e.localName();
        String namespace = e.namespace();
        String prefix = this.prefixOf(name);
        e.clean();
        if (!this.namespaces) {
            localName = "";
            namespace = "";
        }
        if (this.foreign(prefix, namespace)) {
            this.theContentHandler.startPrefixMapping(prefix, namespace);
        }
        AttributesImpl atts = e.atts();
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            String attNamespace = atts.getURI(i);
            String attPrefix = this.prefixOf(atts.getQName(i));
            if (!this.foreign(attPrefix, attNamespace)) continue;
            this.theContentHandler.startPrefixMapping(attPrefix, attNamespace);
        }
        this.theContentHandler.startElement(namespace, localName, name, e.atts());
        e.setNext(this.theStack);
        this.theStack = e;
        this.virginStack = false;
        if (this.CDATAElements && (this.theStack.flags() & 2) != 0) {
            this.theScanner.startCDATA();
        }
    }

    private String prefixOf(String name) {
        int i = name.indexOf(58);
        String prefix = "";
        if (i != -1) {
            prefix = name.substring(0, i);
        }
        return prefix;
    }

    private boolean foreign(String prefix, String namespace) {
        boolean foreign = !prefix.equals("") && !namespace.equals("") && !namespace.equals(this.theSchema.getURI());
        return foreign;
    }

    @Override
    public void decl(char[] buff, int offset, int length) throws SAXException {
    }

    @Override
    public void gi(char[] buff, int offset, int length) throws SAXException {
        if (this.theNewElement != null) {
            return;
        }
        String name = this.makeName(buff, offset, length);
        if (name == null) {
            return;
        }
        ElementType type = this.theSchema.getElementType(name);
        if (type == null) {
            if (this.ignoreBogons) {
                return;
            }
            int bogonModel = this.bogonsEmpty ? 0 : -1;
            int bogonMemberOf = this.rootBogons ? -1 : Integer.MAX_VALUE;
            this.theSchema.elementType(name, bogonModel, bogonMemberOf, 0);
            if (!this.rootBogons) {
                this.theSchema.parent(name, this.theSchema.rootElementType().name());
            }
            type = this.theSchema.getElementType(name);
        }
        this.theNewElement = new Element(type, this.defaultAttributes);
    }

    @Override
    public void cdsect(char[] buff, int offset, int length) throws SAXException {
        this.pcdata(buff, offset, length);
    }

    @Override
    public void pcdata(char[] buff, int offset, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        boolean allWhite = true;
        for (int i = 0; i < length; ++i) {
            if (Util.isWhitespace(buff[offset + i])) continue;
            allWhite = false;
        }
        if (allWhite && !this.theStack.canContain(this.thePCDATA)) {
            if (this.ignorableWhitespace) {
                this.theContentHandler.ignorableWhitespace(buff, offset, length);
            }
        } else {
            this.rectify(this.thePCDATA);
            this.theContentHandler.characters(buff, offset, length);
        }
    }

    @Override
    public void pitarget(char[] buff, int offset, int length) throws SAXException {
        if (this.theNewElement != null) {
            return;
        }
        this.thePITarget = this.makeName(buff, offset, length).replace(':', '_');
    }

    @Override
    public void pi(char[] buff, int offset, int length) throws SAXException {
        if (this.theNewElement != null || this.thePITarget == null) {
            return;
        }
        if ("xml".equalsIgnoreCase(this.thePITarget)) {
            return;
        }
        if (length > 0 && buff[length - 1] == '?') {
            --length;
        }
        this.theContentHandler.processingInstruction(this.thePITarget, new String(buff, offset, length));
        this.thePITarget = null;
    }

    @Override
    public void stagc(char[] buff, int offset, int length) throws SAXException {
        if (this.theNewElement == null) {
            return;
        }
        this.rectify(this.theNewElement);
        if (this.theStack.model() == 0) {
            this.etag_basic(buff, offset, length);
        }
    }

    @Override
    public void stage(char[] buff, int offset, int length) throws SAXException {
        if (this.theNewElement == null) {
            return;
        }
        this.rectify(this.theNewElement);
        this.etag_basic(buff, offset, length);
    }

    @Override
    public void cmnt(char[] buff, int offset, int length) throws SAXException {
    }

    private void rectify(Element e) throws SAXException {
        Element sp;
        while (true) {
            ElementType parentType;
            for (sp = this.theStack; sp != null && !sp.canContain(e); sp = sp.next()) {
            }
            if (sp != null || (parentType = e.parent()) == null) break;
            Element parent = new Element(parentType, this.defaultAttributes);
            parent.setNext(e);
            e = parent;
        }
        if (sp == null) {
            return;
        }
        while (this.theStack != sp && this.theStack != null && this.theStack.next() != null && this.theStack.next().next() != null) {
            this.restartablyPop();
        }
        while (e != null) {
            Element nexte = e.next();
            if (!e.name().equals("<pcdata>")) {
                this.push(e);
            }
            e = nexte;
            this.restart(e);
        }
        this.theNewElement = null;
    }

    @Override
    public int getEntity() {
        return this.theEntity;
    }

    private String makeName(char[] buff, int offset, int length) {
        StringBuffer dst = new StringBuffer(length + 2);
        boolean seenColon = false;
        boolean start = true;
        while (length-- > 0) {
            char ch = buff[offset];
            if (Util.isLetter(ch) || ch == '_') {
                start = false;
                dst.append(ch);
            } else if (Util.isDigit(ch) || ch == '-' || ch == '.') {
                if (start) {
                    dst.append('_');
                }
                start = false;
                dst.append(ch);
            } else if (ch == ':' && !seenColon) {
                seenColon = true;
                if (start) {
                    dst.append('_');
                }
                start = true;
                dst.append(this.translateColons ? (char)'_' : ch);
            }
            ++offset;
        }
        int dstLength = dst.length();
        if (dstLength == 0 || dst.charAt(dstLength - 1) == ':') {
            dst.append('_');
        }
        return dst.toString().intern();
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String name, String publicid, String systemid) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    private Reader getReader(InputStream s) throws SAXException, IOException {
        InputStream i = s;
        Reader r = this.theAutoDetector.autoDetectingReader(i);
        return r;
    }

    @Override
    public void parse(InputStream input, DefaultHandler handler) throws IOException, SAXException {
        this.setContentHandler(handler);
        this.setup();
        Reader r = this.getReader(input);
        this.theContentHandler.startDocument();
        this.theScanner.resetDocumentLocator(null, null);
        if (this.theScanner instanceof Locator) {
            this.theContentHandler.setDocumentLocator((Locator)((Object)this.theScanner));
        }
        if (!this.theSchema.getURI().equals("")) {
            this.theContentHandler.startPrefixMapping(this.theSchema.getPrefix(), this.theSchema.getURI());
        }
        this.theScanner.scan(r, this);
    }
}

