/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.tagsoup;

import java.io.IOException;
import java.io.Reader;

public class PushbackReader
extends Reader {
    private char[] m_buffer;
    private int m_bufferPos;
    private Reader m_reader;

    public PushbackReader(Reader reader) {
        this(reader, 1);
    }

    private PushbackReader(Reader reader, int i) {
        if (i <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.m_buffer = new char[i];
        this.m_bufferPos = i;
        this.m_reader = reader;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return 0;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.m_bufferPos < this.m_buffer.length) {
            return this.m_buffer[this.m_bufferPos++];
        }
        return this.m_reader.read();
    }

    @Override
    public void close() throws IOException {
        this.m_reader.close();
        this.m_buffer = null;
    }

    private void ensureOpen() throws IOException {
        if (this.m_buffer == null) {
            throw new IOException("Stream closed");
        }
    }

    public void unread(int i) throws IOException {
        this.ensureOpen();
        if (this.m_bufferPos == 0) {
            throw new IOException("Pushback buffer overflow");
        }
        this.m_buffer[--this.m_bufferPos] = (char)i;
    }
}

