/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.task;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.task.Callable;
import com.cognos.mobile.task.RunnableFuture;

public class FutureTask
implements RunnableFuture {
    private static final int RUNNING = 1;
    private static final int RAN = 2;
    private final Callable callable;
    private Object result = null;
    private CMException exception = null;
    private RuntimeException runtimeException = null;
    private int state;
    private volatile Thread runner;

    public FutureTask(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        this.callable = callable;
    }

    public FutureTask(Runnable runnable, Object result) {
        this(new RunnableAdapter(runnable, result));
    }

    @Override
    public synchronized boolean isDone() {
        return this.ran() && this.runner == null;
    }

    @Override
    public synchronized Object get() throws CMException {
        this.waitFor();
        return this.getResult();
    }

    protected void done() {
    }

    protected void set(Object v) {
        this.setCompleted(v);
    }

    protected void setException(Throwable t) {
        this.setFailed(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.state != 0) {
                return;
            }
            this.state = 1;
            this.runner = Thread.currentThread();
        }
        try {
            this.setCompleted(this.callable.call());
        }
        catch (Throwable ex) {
            this.setFailed(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runAndReset() {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.state != 0) {
                return false;
            }
            this.state = 1;
            this.runner = Thread.currentThread();
        }
        try {
            this.callable.call();
            futureTask = this;
            synchronized (futureTask) {
                this.runner = null;
                if (this.state == 1) {
                    this.state = 0;
                    return true;
                }
                return false;
            }
        }
        catch (Throwable ex) {
            this.setFailed(ex);
            return false;
        }
    }

    private boolean ran() {
        return (this.state & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCompleted(Object result) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.ran()) {
                return;
            }
            this.state = 2;
            this.result = result;
            this.runner = null;
            this.notifyAll();
        }
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFailed(Throwable exception) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.ran()) {
                return;
            }
            this.state = 2;
            if (exception instanceof CMException) {
                this.exception = (CMException)exception;
            } else if (exception instanceof RuntimeException) {
                this.runtimeException = (RuntimeException)exception;
            } else {
                this.exception = new CMException(1012, exception);
            }
            this.runner = null;
            this.notifyAll();
        }
        this.done();
    }

    private void waitFor() throws CMException {
        while (!this.isDone()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new CMException(1012, "task interrupted");
            }
        }
    }

    private Object getResult() throws CMException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.runtimeException != null) {
            throw this.runtimeException;
        }
        return this.result;
    }

    static final class RunnableAdapter
    implements Callable {
        final Runnable task;
        final Object result;

        RunnableAdapter(Runnable task, Object result) {
            this.task = task;
            this.result = result;
        }

        @Override
        public Object call() {
            this.task.run();
            return this.result;
        }
    }
}

