/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.task;

import com.cognos.mobile.common.IntMap;
import com.cognos.mobile.task.ICancellable;
import com.cognos.mobile.vm.VM;

public class TaskHeap {
    private static final Class CLASS = TaskHeap.class;
    private final IntMap tasks = new IntMap();
    private final Object lock = new Object();
    private int nextId = 1;
    private boolean running = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICancellable addOneTimeTask(Runnable task, long delayInMilliseconds) {
        Object object = this.lock;
        synchronized (object) {
            Entry entry = new Entry();
            entry.id = this.nextId++;
            entry.task = task;
            entry.nextRun = System.currentTimeMillis() + delayInMilliseconds;
            this.tasks.put(entry.id, entry);
            this.lock.notify();
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICancellable addIntervalTask(Runnable task, long delayInMilliseconds) {
        Object object = this.lock;
        synchronized (object) {
            Entry entry = new Entry();
            entry.id = this.nextId++;
            entry.task = task;
            entry.interval = delayInMilliseconds;
            entry.nextRun = System.currentTimeMillis();
            this.tasks.put(entry.id, entry);
            this.lock.notify();
            return entry;
        }
    }

    public void start() {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TaskHeap.this.running = true;
                    while (true) {
                        Entry next = null;
                        Object object = TaskHeap.this.lock;
                        synchronized (object) {
                            next = TaskHeap.this.blockUntilNext();
                            if (!TaskHeap.this.running) {
                                return;
                            }
                            if (next.interval == 0L) {
                                TaskHeap.this.tasks.remove(next.id);
                            } else {
                                next.nextRun = System.currentTimeMillis() + next.interval;
                            }
                        }
                        try {
                            next.task.run();
                        }
                        catch (Throwable t) {
                            VM.log(CLASS, 2, "exception while running task", t);
                        }
                    }
                }
                catch (Throwable t) {
                    VM.log(CLASS, 3, "unexpected exception in task heap", t);
                    return;
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            this.lock.notify();
        }
    }

    private Entry blockUntilNext() throws InterruptedException {
        while (true) {
            Entry next = null;
            IntMap.IntEnumeration e = this.tasks.keys();
            while (e.hasMoreElements()) {
                int key = e.nextElement();
                Entry entry = (Entry)this.tasks.get(key);
                if (next != null && entry.nextRun >= next.nextRun) continue;
                next = entry;
            }
            if (next == null) {
                this.lock.wait();
                continue;
            }
            if (next.nextRun <= System.currentTimeMillis()) {
                return next;
            }
            this.lock.wait(next.nextRun - System.currentTimeMillis());
        }
    }

    private class Entry
    implements ICancellable {
        public int id;
        public Runnable task;
        public long interval;
        public long nextRun;

        private Entry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Object object = TaskHeap.this.lock;
            synchronized (object) {
                TaskHeap.this.tasks.remove(this.id);
                TaskHeap.this.lock.notify();
            }
        }
    }
}

