/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.task;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.status.IStatusProvider;
import com.cognos.mobile.status.STStatusProviders;
import com.cognos.mobile.task.Callable;
import com.cognos.mobile.task.Future;
import com.cognos.mobile.task.FutureTask;
import com.cognos.mobile.task.ICancellable;
import com.cognos.mobile.task.IThreadPool;
import com.cognos.mobile.task.TaskHeap;
import com.cognos.mobile.vm.VM;
import java.util.Vector;

public class ThreadPool
implements IStatusProvider,
IThreadPool {
    private static final Class CLASS = ThreadPool.class;
    private final Object lock = new Object();
    private final Vector tasks = new Vector();
    private final Vector backgroundTasks = new Vector();
    private final Thread[] workerThreads;
    private final TaskHeap scheduler = new TaskHeap();
    private boolean isWorking = true;
    private boolean backgroundTaskIsRunning = false;

    public ThreadPool(int size) {
        this.workerThreads = new Thread[size];
        for (int i = 0; i < size; ++i) {
            final String name = "mob-worker-" + i;
            this.workerThreads[i] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    try {
                        VM.log(ThreadPool.access$000(), 0, name + " started");
                        while (true) lbl-1000:
                        // 5 sources

                        {
                            task = null;
                            isBackground = false;
                            var3_4 = ThreadPool.access$100(ThreadPool.this);
                            synchronized (var3_4) {
                                if (!ThreadPool.access$200(ThreadPool.this)) {
                                    VM.log(ThreadPool.access$000(), 0, name + " terminated");
                                    return;
                                }
                                if (!ThreadPool.access$300(ThreadPool.this).isEmpty()) {
                                    task = (Runnable)ThreadPool.access$300(ThreadPool.this).firstElement();
                                    ThreadPool.access$300(ThreadPool.this).removeElementAt(0);
                                } else if (!ThreadPool.access$400(ThreadPool.this) && !ThreadPool.access$500(ThreadPool.this).isEmpty()) {
                                    task = (Runnable)ThreadPool.access$500(ThreadPool.this).firstElement();
                                    ThreadPool.access$500(ThreadPool.this).removeElementAt(0);
                                    isBackground = true;
                                    ThreadPool.access$402(ThreadPool.this, true);
                                }
                                if (task == null) {
                                    ThreadPool.access$100(ThreadPool.this).wait();
                                }
                            }
                            if (task == null) continue;
                            try {
                                VM.log(ThreadPool.access$000(), 0, "started " + (isBackground != false ? "background" : "normal") + " task " + task.toString());
                                task.run();
                                VM.log(ThreadPool.access$000(), 0, "completed " + (isBackground != false ? "background" : "normal") + " task " + task.toString());
                            }
                            catch (Throwable t) {
                                VM.log(ThreadPool.access$000(), 0, "error in " + (isBackground != false ? "background" : "normal") + " task" + task.toString(), t);
                            }
                            finally {
                                if (!isBackground) continue;
                                var3_4 = ThreadPool.access$100(ThreadPool.this);
                                synchronized (var3_4) {
                                    ThreadPool.access$402(ThreadPool.this, false);
                                }
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        VM.log(ThreadPool.access$000(), 3, "unexpected exception in " + name, t);
                        return;
                    }
                    ** GOTO lbl-1000
                }
            }, "mob-worker-" + i);
            this.workerThreads[i].start();
        }
        this.scheduler.start();
        VM.log(CLASS, 0, "thread pool started");
        STStatusProviders.getInstance().addProvider("thread pool", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        Object object = this.lock;
        synchronized (object) {
            this.isWorking = false;
            this.lock.notifyAll();
        }
        this.scheduler.stop();
        VM.log(CLASS, 0, "Thread pool terminated!");
        STStatusProviders.getInstance().removeProvider(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasThreadAlive() {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.workerThreads.length; ++i) {
                if (!this.workerThreads[i].isAlive()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) throws CMException {
        if (task == null) {
            throw new IllegalArgumentException("can't pass null Runnable to thread pool");
        }
        VM.log(CLASS, 0, "execute: " + task.toString());
        Object object = this.lock;
        synchronized (object) {
            if (this.isWorking) {
                this.tasks.addElement(task);
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBackground(Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException("can't pass null Runnable to thread pool");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isWorking) {
                this.backgroundTasks.addElement(task);
                this.lock.notify();
            }
        }
    }

    @Override
    public ICancellable executeBackground(final Runnable task, int delayInMs) {
        VM.log(CLASS, 0, "scheduled background task '" + task.toString() + "' in " + delayInMs + " ms");
        return this.scheduler.addOneTimeTask(new Runnable(){

            @Override
            public void run() {
                VM.log(CLASS, 0, "scheduled task '" + task.toString() + "' on background thread");
                ThreadPool.this.executeBackground(task);
            }
        }, delayInMs);
    }

    @Override
    public ICancellable executeIntervalBackground(final Runnable task, int delayInMs) {
        VM.log(CLASS, 0, "scheduled background task '" + task.toString() + "' in " + delayInMs + " ms");
        return this.scheduler.addIntervalTask(new Runnable(){

            @Override
            public void run() {
                VM.log(CLASS, 0, "scheduled interval task '" + task.toString() + "' on background thread");
                ThreadPool.this.executeBackground(task);
            }
        }, delayInMs);
    }

    @Override
    public Future submit(Callable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        FutureTask ftask = new FutureTask(task);
        try {
            this.execute(ftask);
        }
        catch (CMException e) {
            VM.log(CLASS, 2, e);
        }
        return ftask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus() {
        StringBuffer sb = new StringBuffer();
        Object object = this.lock;
        synchronized (object) {
            sb.append("<workerThreads>");
            sb.append(this.workerThreads.length);
            sb.append("</workerThreads>");
            sb.append("<tasks>");
            sb.append(this.tasks.size());
            sb.append("</tasks>");
            sb.append("<isWorking>");
            sb.append(this.isWorking ? "true" : "false");
            sb.append("</isWorking>");
        }
        return sb.toString();
    }

    static /* synthetic */ Object access$100(ThreadPool x0) {
        return x0.lock;
    }

    static /* synthetic */ boolean access$200(ThreadPool x0) {
        return x0.isWorking;
    }

    static /* synthetic */ Vector access$300(ThreadPool x0) {
        return x0.tasks;
    }

    static /* synthetic */ boolean access$400(ThreadPool x0) {
        return x0.backgroundTaskIsRunning;
    }

    static /* synthetic */ Vector access$500(ThreadPool x0) {
        return x0.backgroundTasks;
    }

    static /* synthetic */ boolean access$402(ThreadPool x0, boolean x1) {
        x0.backgroundTaskIsRunning = x1;
        return x0.backgroundTaskIsRunning;
    }
}

