/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.cam.CAMCookie;
import com.cognos.mobile.common.CMPropertiesCookie;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.event.Event;
import com.cognos.mobile.event.IEventManager;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class AuthenticationState {
    private static final Class CLASS = AuthenticationState.class;
    private final VMOptions options;
    private CAMCookie passport;
    private boolean demo;
    private final Hashtable credentials = new Hashtable();
    private final IEventManager eventManager;
    private CMPropertiesCookie sessionCookie;
    private int credentialCacheDurationSeconds;
    private int leaseDurationSeconds;
    private long leaseStartTimeMillis;

    public AuthenticationState(VMOptions options, IEventManager eventManager) {
        this.options = options;
        this.eventManager = eventManager;
    }

    public void setDemoMode(boolean mode) {
        VM.log(CLASS, 0, "Setting demo mode: " + mode);
        this.demo = mode;
    }

    public int getCredentialCacheDuration() {
        return this.credentialCacheDurationSeconds;
    }

    public void setCredentialCacheDuration(int s) {
        VM.log(CLASS, 0, "Setting credential cache duration: " + s);
        this.credentialCacheDurationSeconds = s;
    }

    public void setLeaseDuration(int s) {
        VM.log(CLASS, 0, "Setting lease duration: " + s);
        this.leaseDurationSeconds = s;
    }

    public String getUserName() {
        if (this.sessionCookie == null) {
            return null;
        }
        return this.sessionCookie.getProperty("un");
    }

    public String getUserID() {
        if (this.sessionCookie == null) {
            return null;
        }
        return this.sessionCookie.getProperty("uid");
    }

    public String getDisplayName() {
        if (this.sessionCookie == null) {
            return null;
        }
        return this.sessionCookie.getProperty("dn");
    }

    public void setLeaseStart(long millis) {
        VM.log(CLASS, 0, "Setting lease start: " + millis);
        this.leaseStartTimeMillis = millis;
    }

    public long getLeaseStart() {
        return this.leaseStartTimeMillis;
    }

    public Hashtable getCredentials() {
        return this.credentials;
    }

    public int getLeaseDuration() {
        return this.leaseDurationSeconds;
    }

    public void clear() {
        VM.log(CLASS, 0, "Clearing authentication state...");
        int state = this.getAuthenticationState();
        this.sessionCookie = null;
        this.passport = null;
        this.leaseDurationSeconds = 0;
        this.leaseStartTimeMillis = 0L;
        if (state != this.getAuthenticationState()) {
            this.eventManager.postEvent(new Event(this.options, 10));
        }
    }

    public void clearCredentials() {
        VM.log(CLASS, 0, "Clearing credentials...");
        this.credentials.clear();
    }

    public void setPassport(String value) {
        VM.log(CLASS, 0, "Setting the passport to: " + value);
        int state = this.getAuthenticationState();
        if (value != null && value.length() != 0 && !value.equals("\"\"")) {
            this.passport = new CAMCookie(value);
        }
        if (state != this.getAuthenticationState()) {
            this.eventManager.postEvent(new Event(this.options, 10));
        }
    }

    public void setSessionCookie(String value) {
        VM.log(CLASS, 0, "Setting the session cookie to: " + value);
        int state = this.getAuthenticationState();
        if (value == null || value.length() == 0) {
            this.sessionCookie = null;
        }
        this.sessionCookie = new CMPropertiesCookie(value);
        if (state != this.getAuthenticationState()) {
            this.eventManager.postEvent(new Event(this.options, 10));
        }
    }

    public String getSessionCookieProperty(String property) {
        if (this.sessionCookie == null) {
            return null;
        }
        return this.sessionCookie.getProperty(property);
    }

    public void setSessionCookieProperty(String property, String value) {
        VM.log(CLASS, 0, "Setting the session cookie property: " + property + " to: " + value);
        if (this.sessionCookie == null) {
            this.sessionCookie = new CMPropertiesCookie();
        }
        this.sessionCookie.setProperty(property, value);
    }

    public String getCookiesHeader() {
        if (this.sessionCookie == null) {
            return "";
        }
        StringBuffer cookiesBuilder = new StringBuffer();
        cookiesBuilder.append("mob_session");
        cookiesBuilder.append("=");
        cookiesBuilder.append(this.sessionCookie.toString());
        cookiesBuilder.append(";");
        return cookiesBuilder.toString();
    }

    public void setCredentials(String signature, Hashtable credentials) {
        VM.log(CLASS, 0, "Setting credentials...");
        CredentialsEntry entry = new CredentialsEntry();
        entry.credentialsWereCachedAt = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        String sep = "";
        Enumeration e = credentials.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            sb.append(sep);
            sb.append(CMUrlHelper.encodeUrl(key));
            sb.append('=');
            String value = (String)credentials.get(key);
            sb.append(CMUrlHelper.encodeUrl(value));
            sep = "|";
        }
        entry.serializedCredentials = sb.toString();
        this.credentials.put(signature, entry);
        VM.log(CLASS, 0, "cached credentials for '" + signature + "': '" + entry.serializedCredentials + "'");
    }

    public Hashtable getCredentials(String signature, boolean respectCacheDuration) {
        CredentialsEntry entry = (CredentialsEntry)this.credentials.get(signature);
        if (entry == null) {
            VM.log(CLASS, 0, "no cached credentials for '" + signature + "'");
            return null;
        }
        long expiry = entry.credentialsWereCachedAt + (long)this.credentialCacheDurationSeconds * 1000L;
        if (respectCacheDuration && expiry < System.currentTimeMillis()) {
            VM.log(CLASS, 0, "credentials expired for '" + signature + "'");
            return null;
        }
        String[] pairs = CMStringHelper.split(entry.serializedCredentials, '|', true);
        Hashtable<String, String> credentials = new Hashtable<String, String>();
        if (pairs != null) {
            for (int i = 0; i < pairs.length; ++i) {
                String[] keyValue = CMStringHelper.split(pairs[i], '=', true);
                if (keyValue != null && keyValue.length == 1) {
                    credentials.put(CMUrlHelper.decodeUrl(keyValue[0]), "");
                    continue;
                }
                if (keyValue == null || keyValue.length != 2) continue;
                credentials.put(CMUrlHelper.decodeUrl(keyValue[0]), keyValue[1] == null ? "" : CMUrlHelper.decodeUrl(keyValue[1]));
            }
        }
        VM.log(CLASS, 0, "found credentials for '" + signature + "': '" + entry.serializedCredentials + "'");
        return credentials;
    }

    public int getAuthenticationState() {
        if (this.demo) {
            return 3;
        }
        if (this.passport == null || this.sessionCookie == null) {
            return 0;
        }
        if (this.passport.isCurrentUserAnonymous()) {
            return 1;
        }
        return 2;
    }

    public void readCredentials(DataInputStream in) throws IOException {
        int credentialSize = in.readInt();
        if (credentialSize > 0) {
            for (int i = 0; i < credentialSize; ++i) {
                long expiry;
                String signature = in.readUTF();
                CredentialsEntry entry = new CredentialsEntry();
                entry.credentialsWereCachedAt = in.readLong();
                entry.serializedCredentials = in.readUTF();
                if (signature == null || signature.length() <= 0 || entry.serializedCredentials == null || entry.serializedCredentials.length() <= 0 || (expiry = entry.credentialsWereCachedAt + (long)this.credentialCacheDurationSeconds * 1000L) < System.currentTimeMillis()) continue;
                this.credentials.put(signature, entry);
            }
        }
    }

    public void saveCredentials(DataOutputStream out) throws IOException {
        out.writeInt(this.getCredentialCacheDuration());
        if (this.getCredentialCacheDuration() <= 0) {
            out.writeInt(0);
            return;
        }
        out.writeInt(this.credentials.size());
        Enumeration e = this.credentials.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            CredentialsEntry entry = (CredentialsEntry)this.credentials.get(key);
            long expiry = entry.credentialsWereCachedAt + (long)this.credentialCacheDurationSeconds * 1000L;
            if (expiry > System.currentTimeMillis()) {
                out.writeUTF(key);
                out.writeLong(entry.credentialsWereCachedAt);
                out.writeUTF(entry.serializedCredentials);
                continue;
            }
            out.writeUTF("");
            out.writeLong(0L);
            out.writeUTF("");
        }
    }

    public void saveSessionCookie(DataOutputStream out) throws IOException {
        out.writeUTF("mob_session");
        out.writeUTF(this.sessionCookie == null ? "" : this.sessionCookie.toString());
    }

    public void saveLeaseDuration(DataOutputStream out) throws IOException {
        out.writeInt(this.leaseDurationSeconds);
    }

    public void dump(StringBuffer sb) {
        sb.append("CCD " + this.getCredentialCacheDuration() + "s; LD " + this.getLeaseDuration() + "s; LST " + this.getLeaseStart() + "m;\n");
        if (this.sessionCookie != null) {
            sb.append("SC '" + this.sessionCookie.toString() + "'\n");
        }
    }

    private static class CredentialsEntry {
        String serializedCredentials;
        long credentialsWereCachedAt;

        private CredentialsEntry() {
        }
    }
}

