/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.vm.IVMReader;
import com.cognos.mobile.vm.VM;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class CachingReader
implements IVMReader {
    private static Class CLASS = CachingReader.class;
    private static final int CODE_PAGE_SIZE = 256;
    private static final int STRING_PAGE_SIZE = 64;
    private static final int BLOB_PAGE_SIZE = 4;
    private IVMReader reader;
    protected IVMReader.CodeRecord currentCodeRecord;
    protected Vector codeRecords = new Vector();
    protected Vector stringRecords = new Vector();
    protected Vector blobRecords = new Vector();

    public void attachReader(IVMReader reader) throws CMException {
        this.reader = reader;
        reader.onReaderOpen();
        this.cacheCodePage();
        this.cacheStringsPage();
        this.cacheBlobsPage();
    }

    private boolean cacheCodePage() throws CMException {
        int readAddress;
        int stopAddress = (readAddress / 256 + 1) * 256;
        this.codeRecords.ensureCapacity(stopAddress);
        int oldSize = this.codeRecords.size();
        for (readAddress = this.codeRecords.size(); readAddress >= 0 && readAddress < stopAddress; ++readAddress) {
            IVMReader.CodeRecord buf = new IVMReader.CodeRecord();
            if (!this.reader.onReaderLoadCode(readAddress, buf)) {
                VM.log(CLASS, 2, "premature EOF");
                break;
            }
            this.codeRecords.addElement(buf);
            if (buf.opcode == 0) break;
        }
        VM.log(CLASS, 1, "cached code (" + CMStringHelper.formatAddress(0) + "," + CMStringHelper.formatAddress(this.codeRecords.size()) + "]");
        return oldSize != this.codeRecords.size();
    }

    private boolean cacheStringsPage() throws CMException {
        int oldSize;
        int readStringID;
        int stopStringID = (readStringID / 64 + 1) * 64;
        this.stringRecords.ensureCapacity(stopStringID);
        for (readStringID = oldSize = this.stringRecords.size(); readStringID < stopStringID; ++readStringID) {
            StringRecord rec = new StringRecord();
            rec.id = readStringID;
            rec.string = this.reader.onReaderLoadString(readStringID);
            if (rec.string == null) break;
            this.stringRecords.addElement(rec);
        }
        VM.log(CLASS, 1, "cached strings (0," + Integer.toString(this.stringRecords.size()) + "]");
        return oldSize != this.stringRecords.size();
    }

    private boolean cacheBlobsPage() throws CMException {
        int oldSize;
        int readBlobID;
        int stopBlobID = (readBlobID / 4 + 1) * 4;
        this.blobRecords.ensureCapacity(stopBlobID);
        for (readBlobID = oldSize = this.blobRecords.size(); readBlobID < stopBlobID; ++readBlobID) {
            BlobRecord rec = new BlobRecord();
            rec.id = readBlobID;
            rec.blob = this.reader.onReaderLoadBlob(readBlobID);
            if (rec.blob == null) break;
            this.blobRecords.addElement(rec);
        }
        VM.log(CLASS, 1, "cached blobs (0," + Integer.toString(this.blobRecords.size()) + "]");
        return oldSize != this.blobRecords.size();
    }

    @Override
    public int onReaderOpen() throws CMException {
        return 0;
    }

    @Override
    public void onReaderClose() throws CMException {
        this.reader.onReaderClose();
    }

    @Override
    public boolean onReaderLoadCode(int address, IVMReader.CodeRecord code) throws CMException {
        if (address < 0) {
            return false;
        }
        boolean added = true;
        while (added && address > this.codeRecords.size() - 1) {
            added = this.cacheCodePage();
        }
        if (address >= this.codeRecords.size()) {
            return false;
        }
        IVMReader.CodeRecord load = (IVMReader.CodeRecord)this.codeRecords.elementAt(address);
        code.copy(load);
        return true;
    }

    @Override
    public String onReaderLoadString(int stringID) throws CMException {
        boolean added = true;
        if (stringID < 0) {
            return "";
        }
        while (added && stringID > this.stringRecords.size() - 1) {
            added = this.cacheStringsPage();
        }
        if (stringID >= this.stringRecords.size()) {
            throw new CMException(1200, "bad string ID: " + stringID);
        }
        StringRecord rec = (StringRecord)this.stringRecords.elementAt(stringID);
        if (rec.id == stringID) {
            return rec.string;
        }
        VM.log(CLASS, 3, "failed to find string " + stringID + " at expected position");
        for (int i = 0; i < this.stringRecords.size(); ++i) {
            rec = (StringRecord)this.stringRecords.elementAt(i);
            if (rec.id != stringID) continue;
            return rec.string;
        }
        return "";
    }

    @Override
    public byte[] onReaderLoadBlob(int blobID) throws CMException {
        boolean added = true;
        if (blobID < 0) {
            return null;
        }
        while (added && blobID > this.blobRecords.size() - 1) {
            added = this.cacheBlobsPage();
        }
        if (blobID >= this.blobRecords.size()) {
            throw new CMException(1200, "bad blob id: " + blobID);
        }
        BlobRecord rec = (BlobRecord)this.blobRecords.elementAt(blobID);
        if (rec.id == blobID) {
            return rec.blob;
        }
        VM.log(CLASS, 3, "failed to find blob " + blobID + " at expected position");
        for (int i = 0; i < this.blobRecords.size(); ++i) {
            rec = (BlobRecord)this.blobRecords.elementAt(i);
            if (rec.id != blobID) continue;
            return rec.blob;
        }
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void serialize(OutputStream out) throws IOException {
    }

    public class BlobRecord {
        public int id;
        public byte[] blob;
    }

    public class StringRecord {
        public int id;
        public String string;
    }
}

