/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.common.ByteVector;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.IntVector;
import com.cognos.mobile.vm.IVMReader;
import com.cognos.mobile.vm.IVMWriter;
import com.cognos.mobile.vm.MemReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public final class ClientMemDatabase
implements IVMWriter,
IVMReader {
    private ByteVector opcode;
    private IntVector p1;
    private IntVector p2;
    private Vector string_value;
    private Vector blob_value;
    private MemReader reader;
    private Hashtable m_blobCache = null;
    private Hashtable m_tmpCache = null;

    @Override
    public void onWriterClose() throws CMException {
        byte[] _opcode = this.opcode.toArrayAndFlush();
        int[] _p1 = this.p1.toArrayAndFlush();
        int[] _p2 = this.p2.toArrayAndFlush();
        String[] _string_value = new String[this.string_value.size()];
        for (int i = 0; i < this.string_value.size(); ++i) {
            _string_value[i] = (String)this.string_value.elementAt(i);
        }
        byte[][] _blob_value = new byte[this.blob_value.size()][];
        for (int i = 0; i < this.blob_value.size(); ++i) {
            _blob_value[i] = (byte[])this.blob_value.elementAt(i);
        }
        this.opcode = null;
        this.p1 = null;
        this.p2 = null;
        this.string_value = null;
        this.blob_value = null;
        this.reader = new MemReader(_opcode, _p1, _p2, _string_value, _blob_value);
    }

    @Override
    public int onWriterOpen() throws CMException {
        this.opcode = new ByteVector();
        this.p1 = new IntVector();
        this.p2 = new IntVector();
        this.string_value = new Vector();
        this.blob_value = new Vector();
        return 0;
    }

    @Override
    public int onWriterWriteCode(int _opcode, int _p1, int _p2) throws CMException {
        this.opcode.add((byte)_opcode);
        this.p1.add(_p1);
        this.p2.add(_p2);
        return this.opcode.length();
    }

    @Override
    public int onWriterWriteString(String literal) throws CMException {
        this.string_value.addElement(literal);
        return this.string_value.size();
    }

    @Override
    public int onWriterWriteBlob(byte[] bytes, int format) throws CMException {
        return this.onWriterWriteBlob(bytes, null, format, -1, -1, -1, -1);
    }

    @Override
    public int onWriterWriteBlob(byte[] bytes, String location, int format, int height, int width, int objectIndex, int page) throws CMException {
        this.blob_value.addElement(bytes);
        return this.blob_value.size();
    }

    @Override
    public void dispose() {
        this.opcode = null;
        this.p1 = null;
        this.p2 = null;
        this.string_value = null;
        this.blob_value = null;
        this.reader = null;
    }

    public boolean equals(Object obj) {
        return this.reader.equals(obj);
    }

    public int hashCode() {
        return this.reader.hashCode();
    }

    @Override
    public void onReaderClose() throws CMException {
        this.reader.onReaderClose();
    }

    @Override
    public byte[] onReaderLoadBlob(int blobID) throws CMException {
        return this.reader.onReaderLoadBlob(blobID);
    }

    @Override
    public boolean onReaderLoadCode(int address, IVMReader.CodeRecord code) throws CMException {
        return this.reader.onReaderLoadCode(address, code);
    }

    @Override
    public String onReaderLoadString(int stringID) throws CMException {
        return this.reader.onReaderLoadString(stringID);
    }

    @Override
    public int onReaderOpen() throws CMException {
        return this.reader.onReaderOpen();
    }

    public String toString() {
        return this.reader.toString();
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        this.reader.serialize(outputStream);
    }

    public static IVMReader fromInputStream(InputStream inputStream) throws CMException {
        return MemReader.create(inputStream);
    }

    public static IVMReader fromData(byte[] code_opcode, int[] code_p1, int[] code_p2, String[] string_value, byte[][] blob_value) throws CMException {
        return new MemReader(code_opcode, code_p1, code_p2, string_value, blob_value);
    }

    @Override
    public int getSize() {
        return -1;
    }

    @Override
    public Hashtable getBlobCache() {
        if (this.m_blobCache == null) {
            this.m_blobCache = new Hashtable();
        }
        return this.m_blobCache;
    }

    @Override
    public Hashtable getTempCache() {
        if (this.m_tmpCache == null) {
            this.m_tmpCache = new Hashtable();
        }
        return this.m_tmpCache;
    }

    @Override
    public boolean isShinkImages() {
        return true;
    }
}

