/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VMRender;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.node.GroupNode;
import com.cognos.mobile.vm.node.RowColumnFocusBuilder;

public class CommandHelper {
    public static long getEnabledCommands(VMScene scene) {
        int zoomLevel;
        long state = 0L;
        if (scene == null) {
            return state;
        }
        state = scene.getType() == 1 ? (state |= 0x800000L) : (state |= 0x1000000L);
        Node node = scene.getSelection().getSelectedNode();
        if (node != null) {
            if (node.checkStyle(32)) {
                state |= 1L;
            } else if (node.checkStyle(0x400000)) {
                state |= 0x8000000L;
            }
            if (node.checkStyle(64)) {
                state |= 2L;
            }
            if (node.checkStyle(128)) {
                state |= 4L;
            }
            if (node.checkStyle(65536)) {
                state = node.checkStyle(131072) ? (state |= 0x20000L) : (state |= 0x10000L);
            }
            if (scene.checkStyle(4)) {
                if (RowColumnFocusBuilder.isAbleToSwitchFocus(node)) {
                    state |= 0x200000L;
                }
                if (node.checkStyle(256)) {
                    state |= 0x10L;
                }
                if (node.checkStyle(512)) {
                    state |= 0x20L;
                }
            }
            if (scene.checkStyle(8)) {
                if (RowColumnFocusBuilder.isAbleToSwitchFocus(node)) {
                    state |= 0x400000L;
                }
                if (node.checkStyle(1024)) {
                    state |= 0x40L;
                }
                if (node.checkStyle(2048)) {
                    state |= 0x80L;
                }
            }
            if (node.checkStyle(262144)) {
                state |= 0x40000L;
            }
            if (node.checkStyle(0x800000) && node.getStyleCount_AllDescendant(0x800000) == 1) {
                state |= 0x10000000L;
            }
            if (node.checkStyle(0x1000000)) {
                state |= 0x20000000L;
            }
            if (node.checkStyle(0x2000000)) {
                state |= 0x40000000L;
            }
            if (node.getType() == 6 || node.getChildCount() == 1 && node.getChild(0).getType() == 6) {
                state |= 0x2000000L;
                state |= 0x4000000L;
            }
        }
        if (scene.getRootNode() != null && scene.getRootNode().checkStyle(16384)) {
            state |= 0x4000L;
            if (scene.isFindNextActive()) {
                state |= 0x8000L;
            }
        }
        if (scene.getRootNode() != null && scene.getRootNode().checkStyle(16384)) {
            state |= 0x100000L;
            state |= 0x80000L;
        }
        if ((zoomLevel = scene.getZoomLevel()) < 300) {
            state |= 0x800L;
        }
        if (zoomLevel > 10) {
            state |= 0x1000L;
        }
        state |= 0x2000L;
        VMRender render = scene.getRender();
        if (render != null) {
            int pageCount = render.getPageCount();
            int pageIndex = scene.getPageIndex();
            if (pageCount > 1) {
                state |= 0x100L;
                if (pageIndex > 0) {
                    state |= 0x400L;
                }
                if (pageIndex < pageCount - 1) {
                    state |= 0x200L;
                }
            }
        }
        return state;
    }

    public static String getFocusObjectText(VMScene scene) {
        return CommandHelper.getFocusObjectText(scene.getSelection().getSelectedNode());
    }

    public static String getFocusObjectText(Node selectedNode) {
        String key = CMIDs.MENU_FOCUS_OBJECT;
        if (selectedNode != null) {
            block0 : switch (selectedNode.getType()) {
                case 4: {
                    GroupNode groupNode = (GroupNode)selectedNode;
                    switch (groupNode.getGroupType()) {
                        case 3: {
                            key = CMIDs.MENU_FOCUS_FOOTER;
                            break block0;
                        }
                        case 2: {
                            key = CMIDs.MENU_FOCUS_HEADER;
                            break block0;
                        }
                        case 5: {
                            key = CMIDs.MENU_FOCUS_CHART;
                            break block0;
                        }
                        case 4: {
                            key = CMIDs.MENU_FOCUS_IMAGE;
                            break block0;
                        }
                    }
                    if (selectedNode.checkStyle(16384) && !selectedNode.checkStyle(32768)) {
                        key = CMIDs.MENU_FOCUS_TEXT;
                        break;
                    }
                    if (selectedNode.checkStyle(16384) || !selectedNode.checkStyle(32768)) break;
                    key = CMIDs.MENU_FOCUS_IMAGE;
                    break;
                }
                case 2: 
                case 3: {
                    key = CMIDs.MENU_FOCUS_TABLE;
                    break;
                }
                case 8: {
                    key = CMIDs.MENU_FOCUS_IMAGE;
                    break;
                }
                case 6: {
                    key = CMIDs.MENU_FOCUS_TEXT;
                }
            }
        }
        return key;
    }

    public long getDefaultCommand(long state) {
        if ((state & 2L) != 0L) {
            return 2L;
        }
        if ((state & 4L) != 0L) {
            return 4L;
        }
        if ((state & 1L) != 0L) {
            return 1L;
        }
        return 0L;
    }
}

