/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

public final class FontCache {
    private static final int FONT_MASK = 7;
    private final Object[] painterFonts;
    private double painterFontsScale;
    private Object tooltipFont;
    private final IFontFactory ff;

    public FontCache(IFontFactory ff) {
        this.ff = ff;
        this.painterFonts = new Object[8];
        this.painterFontsScale = 1.0;
        this.tooltipFont = ff.createFont(8, 0.7);
    }

    public final IFontFactory getFontFactory() {
        return this.ff;
    }

    public final Object getPainterFont(int flags, double scale) {
        Object newFont = null;
        if ((flags & 8) != 0) {
            newFont = this.tooltipFont = this.ff.createFont(8, 0.7);
        } else {
            if (scale != this.painterFontsScale) {
                this.cleanFontCache();
                this.painterFontsScale = scale;
            }
            if (this.painterFonts[flags &= 7] != null) {
                newFont = this.painterFonts[flags];
            } else {
                this.painterFonts[flags] = newFont = this.ff.createFont(flags, scale);
            }
        }
        return newFont;
    }

    public final void cleanFontCache() {
        for (int i = 0; i < this.painterFonts.length; ++i) {
            this.painterFonts[i] = null;
        }
    }

    public static interface IFontFactory {
        public Object createFont(int var1, double var2);
    }
}

