/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.common.CMBase64;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import java.io.IOException;
import java.io.OutputStream;

public interface IVMReader {
    public static final Formatter PrintFormatter = new Formatter(){
        private static final int MAX_BLOB_BYTES = 16;

        @Override
        public String format(CodeRecord codeRecord) {
            StringBuffer sb = new StringBuffer();
            sb.append(CMStringHelper.formatAddress(codeRecord.address));
            sb.append(":\t");
            sb.append(Integer.toHexString(codeRecord.opcode));
            sb.append("\t");
            sb.append(codeRecord.p1);
            sb.append("\t");
            sb.append(codeRecord.p2);
            return sb.toString();
        }

        @Override
        public String format(StringRecord stringRecord) {
            StringBuffer sb = new StringBuffer();
            sb.append(stringRecord.id);
            sb.append(":\t");
            sb.append(stringRecord.string);
            return sb.toString();
        }

        @Override
        public String format(BlobRecord blobRecord) {
            StringBuffer sb = new StringBuffer();
            sb.append(blobRecord.id);
            sb.append(":\t");
            int len = Math.min(blobRecord.blob.length, 16);
            String blobString = CMBase64.encodeBytes(blobRecord.blob, 0, len);
            if (len < blobRecord.blob.length) {
                blobString = blobString + "...";
            }
            blobString = blobString + " (" + blobRecord.blob.length + " bytes)";
            sb.append(blobString);
            return sb.toString();
        }
    };

    public int onReaderOpen() throws CMException;

    public void onReaderClose() throws CMException;

    public boolean onReaderLoadCode(int var1, CodeRecord var2) throws CMException;

    public String onReaderLoadString(int var1) throws CMException;

    public byte[] onReaderLoadBlob(int var1) throws CMException;

    public void dispose();

    public void serialize(OutputStream var1) throws IOException;

    public static interface Formatter {
        public String format(CodeRecord var1);

        public String format(StringRecord var1);

        public String format(BlobRecord var1);
    }

    public static final class BlobRecord {
        public int id;
        public byte[] blob;
    }

    public static final class StringRecord {
        public int id;
        public String string;
    }

    public static final class CodeRecord {
        public int address;
        public int opcode;
        public int p1;
        public int p2;

        public void copy(CodeRecord other) {
            this.address = other.address;
            this.opcode = other.opcode;
            this.p1 = other.p1;
            this.p2 = other.p2;
        }
    }
}

