/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.common.CMServerHelper;
import com.cognos.mobile.vm.IVMCache;
import com.cognos.mobile.vm.IVMImage;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMScene;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class ImageCache {
    private static final Class CLASS = ImageCache.class;
    private VMScene scene;
    private IVMCache cache;
    private Hashtable imageHash;

    public ImageCache(VMScene scene, IVMCache cache) {
        this.scene = scene;
        this.cache = cache;
        this.imageHash = new Hashtable();
    }

    public void dispose() {
        Enumeration e = this.imageHash.elements();
        while (e.hasMoreElements()) {
            IVMImage image = (IVMImage)e.nextElement();
            if (image == null) continue;
            image.onImageDispose();
        }
    }

    public IVMImage loadZoomImageFromCache(String nodePath, int pageWidth) {
        int renderID = this.scene.getRender().getMeta().renderID;
        String fileName = CMServerHelper.buildZoomImageCacheFilename(renderID, this.scene.getPageIndex(), this.scene.getScenePath(), nodePath, pageWidth, 1);
        IVMImage image = (IVMImage)this.imageHash.get(fileName);
        if (image != null) {
            return image;
        }
        if (this.cache != null) {
            try {
                image = this.cache.onCacheLoadImage(fileName);
            }
            catch (IOException ioe) {
                VM.log(CLASS, 3, "failed to load " + fileName, ioe);
            }
        }
        return image;
    }

    public void saveZoomImageToCache(IVMImage image, String nodePath, int pageWidth, boolean saveToPlatformCache) {
        if (image == null) {
            return;
        }
        int renderID = this.scene.getRender().getMeta().renderID;
        String fileName = CMServerHelper.buildZoomImageCacheFilename(renderID, this.scene.getPageIndex(), this.scene.getScenePath(), nodePath, pageWidth, 1);
        IVMImage oldImage = (IVMImage)this.imageHash.get(fileName);
        if (oldImage != null && oldImage != image) {
            VM.log(CLASS, 2, "found old cache item for " + fileName);
            oldImage.onImageDispose();
        }
        this.imageHash.put(fileName, image);
        if (saveToPlatformCache && this.cache != null && renderID > 0 && this.cache.canWrite()) {
            this.cache.onCacheSaveImage(fileName, image);
        }
    }
}

