/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.IVMReader;
import com.cognos.mobile.vm.PlatformIndependentReader;
import com.cognos.mobile.vm.PlatformIndependentWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class MemReader
implements IVMReader {
    private static final int MAGIC = 57040;
    private static final int VERSION = 1;
    private final byte[] code_opcode;
    private final int[] code_p1;
    private final int[] code_p2;
    private final String[] string_value;
    private final byte[][] blob_value;

    MemReader(byte[] code_opcode, int[] code_p1, int[] code_p2, String[] string_value, byte[][] blob_value) {
        this.code_opcode = code_opcode;
        this.code_p1 = code_p1;
        this.code_p2 = code_p2;
        this.string_value = string_value;
        this.blob_value = blob_value;
    }

    public static IVMReader create(InputStream inputStream) throws CMException {
        try {
            PlatformIndependentReader in = new PlatformIndependentReader(inputStream);
            int magic = in.readInt();
            if (magic != 57040) {
                throw new CMException(2016, "invalid demo file");
            }
            int version = in.readInt();
            switch (version) {
                case 1: {
                    break;
                }
                default: {
                    throw new CMException(2016, "unsupported demo version: " + version);
                }
            }
            int codeSize = in.readInt();
            if (codeSize < 0) {
                throw new CMException(2016, "illegal code record count: " + codeSize);
            }
            byte[] code_opcode = new byte[codeSize];
            int[] code_p1 = new int[codeSize];
            int[] code_p2 = new int[codeSize];
            for (int i = 0; i < codeSize; ++i) {
                code_opcode[i] = (byte)in.readInt();
                code_p1[i] = in.readInt();
                code_p2[i] = in.readInt();
            }
            int stringSize = in.readInt();
            if (stringSize < 0) {
                throw new CMException(2016, "illegal string record count: " + stringSize);
            }
            String[] string_value = new String[stringSize];
            for (int i = 0; i < stringSize; ++i) {
                int id = in.readInt();
                string_value[i] = in.readString();
                if (id == i) continue;
                throw new CMException(2016, "bad string order at string #" + i);
            }
            int blobSize = in.readInt();
            if (blobSize < 0) {
                throw new CMException(2016, "illegal blob record count: " + blobSize);
            }
            byte[][] blob_value = new byte[blobSize][];
            for (int i = 0; i < blobSize; ++i) {
                int id = in.readInt();
                int length = in.readInt();
                blob_value[i] = new byte[length];
                in.readBytes(blob_value[i], 0, length);
                if (id == i) continue;
                throw new CMException(2016, "bad blob order at string #" + i);
            }
            return new MemReader(code_opcode, code_p1, code_p2, string_value, blob_value);
        }
        catch (IOException ex) {
            throw new CMException(2016, (Throwable)ex);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void onReaderClose() throws CMException {
    }

    @Override
    public byte[] onReaderLoadBlob(int blobID) throws CMException {
        try {
            return this.blob_value[blobID];
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            throw new CMException(1200, "bad blob ID: " + blobID);
        }
    }

    @Override
    public boolean onReaderLoadCode(int address, IVMReader.CodeRecord code) throws CMException {
        if (address < 0 || address >= this.code_p1.length) {
            return false;
        }
        code.address = address;
        code.opcode = this.code_opcode[address];
        code.p1 = this.code_p1[address];
        code.p2 = this.code_p2[address];
        return true;
    }

    @Override
    public String onReaderLoadString(int stringID) throws CMException {
        if (stringID < 0 || stringID >= this.string_value.length) {
            return null;
        }
        return this.string_value[stringID];
    }

    @Override
    public int onReaderOpen() throws CMException {
        return 0;
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        int i;
        PlatformIndependentWriter out = new PlatformIndependentWriter(outputStream);
        out.write(57040);
        out.write(1);
        out.write(this.code_opcode.length);
        for (i = 0; i < this.code_opcode.length; ++i) {
            out.write(this.code_opcode[i]);
            out.write(this.code_p1[i]);
            out.write(this.code_p2[i]);
        }
        out.write(this.string_value.length);
        for (i = 0; i < this.string_value.length; ++i) {
            out.write(i);
            out.write(this.string_value[i]);
        }
        out.write(this.blob_value.length);
        for (i = 0; i < this.blob_value.length; ++i) {
            out.write(i);
            out.write(this.blob_value[i].length);
            out.write(this.blob_value[i]);
        }
    }
}

