/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMMathHelper;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.vm.IKeyHandler;
import com.cognos.mobile.vm.IMouseHandler;
import com.cognos.mobile.vm.INodeVisibility;
import com.cognos.mobile.vm.IVMImage;
import com.cognos.mobile.vm.IVMPainter;
import com.cognos.mobile.vm.IVMReader;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMColor;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.ZoomImageBuilder;
import com.cognos.mobile.vm.layout.FlowLayout;
import com.cognos.mobile.vm.layout.ILayout;
import com.cognos.mobile.vm.node.CellNode;
import com.cognos.mobile.vm.node.DefaultNodeVisibility;
import com.cognos.mobile.vm.node.ImageNode;
import com.cognos.mobile.vm.node.TableNode;
import com.cognos.mobile.vm.node.TablePartNode;
import com.cognos.mobile.vm.node.TextNode;
import com.cognos.mobile.vm.render.DrillUpDownState;
import com.cognos.mobile.vm.render.FindState;
import com.cognos.mobile.vm.render.RenderState;
import java.util.Vector;

public class Node {
    public static final int TYPE_ROOT = 0;
    public static final int TYPE_BODY = 1;
    public static final int TYPE_TABLE = 2;
    public static final int TYPE_TABLE_CELL = 3;
    public static final int TYPE_GROUP = 4;
    public static final int TYPE_SPOT = 5;
    public static final int TYPE_TEXT = 6;
    public static final int TYPE_TABLE_PART = 7;
    public static final int TYPE_IMAGE = 8;
    public static final int TYPE_BLOCK = 9;
    public static final int DOWNLOAD_TILE_SIZE = 240;
    public static final int STYLE_SELECT_PAGE = 8;
    public static final int STYLE_SELECT_OBJECT = 16;
    public static final int STYLE_FOCUS_OBJECT = 32;
    public static final int STYLE_FOCUS_ROW = 64;
    public static final int STYLE_FOCUS_COLUMN = 128;
    public static final int STYLE_TABLE_ROW_PREV = 256;
    public static final int STYLE_TABLE_ROW_NEXT = 512;
    public static final int STYLE_TABLE_COL_PREV = 1024;
    public static final int STYLE_TABLE_COL_NEXT = 2048;
    public static final int STYLE_TABLE_LAYOUT = 4096;
    public static final int STYLE_ZOOM_IMAGE = 8192;
    public static final int STYLE_HAS_TEXT = 16384;
    public static final int STYLE_HAS_IMAGES = 32768;
    public static final int STYLE_MARKABLE = 65536;
    public static final int STYLE_MARKED = 131072;
    public static final int STYLE_DRILL_THROUGH = 262144;
    public static final int STYLE_LAYOUT_DISPLAY_BLOCK = 524288;
    public static final int STYLE_LAYOUT_ABSOLUTE_POSITIONED = 0x100000;
    public static final int STYLE_LAYOUT_NEXT_LINE = 0x200000;
    public static final int STYLE_CONTAINS_SUBFOCUSABLE = 0x400000;
    public static final int STYLE_MAILTO = 0x800000;
    public static final int STYLE_DRILL_UP = 0x1000000;
    public static final int STYLE_DRILL_DOWN = 0x2000000;
    private static final Class CLASS = Node.class;
    private static boolean wouldDebugLog = VM.wouldLog(CLASS, 0);
    protected static final boolean DEBUG_DRAW_CLIENT_RECT = false;
    private static final boolean DEBUG_LOG_STYLES = false;
    protected static final boolean DEBUG_FORCE_BUILD_ZOOM_IMAGES = false;
    private static final boolean DEBUG_LOG_TREES = false;
    private VMScene scene;
    private Node parent;
    private final int type;
    protected int startAddress;
    protected int endAddress;
    protected Vector children;
    protected int numchildren = 0;
    private int style;
    private String id;
    private String label;
    private int horizontalAlign;
    private int verticalAlign;
    private VMRect rect;
    private VMRect layoutRect;
    private VMRect unzoomedRect;
    protected IVMImage zoomImage;
    protected IVMImage paintZoomImage;
    protected int tempLayoutCx;
    private VMPoint maxSize;

    public boolean hasNestedTable() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.getChild(i) instanceof TableNode) {
                return true;
            }
            if (!this.getChild(i).hasNestedTable()) continue;
            return true;
        }
        return false;
    }

    public Node(int type, int style) {
        this.type = type;
        this.style = style;
        this.scene = null;
        this.parent = null;
        this.startAddress = -1;
        this.endAddress = -1;
        this.id = null;
        this.label = null;
        this.horizontalAlign = -1;
        this.verticalAlign = -1;
        this.rect = new VMRect();
        this.layoutRect = new VMRect();
        this.unzoomedRect = null;
        this.zoomImage = null;
        this.paintZoomImage = null;
    }

    public Node(Node other) {
        this.parent = null;
        this.scene = other.scene;
        this.type = other.type;
        this.style = other.style;
        this.startAddress = other.startAddress;
        this.endAddress = other.endAddress;
        this.id = other.id;
        this.label = other.label;
        this.horizontalAlign = other.horizontalAlign;
        this.verticalAlign = other.verticalAlign;
        this.rect = other.rect == null ? null : new VMRect(other.rect);
        this.layoutRect = other.layoutRect == null ? null : new VMRect(other.layoutRect);
        this.unzoomedRect = other.unzoomedRect == null ? null : new VMRect(other.unzoomedRect);
        this.zoomImage = other.zoomImage;
        this.paintZoomImage = other.paintZoomImage;
    }

    public void setScene(VMScene scene) {
        this.scene = scene;
        if (this.children != null) {
            for (int i = 0; i < this.numchildren; ++i) {
                Node child = (Node)this.children.elementAt(i);
                child.setScene(scene);
            }
        }
    }

    public Node cloneNode() {
        return new Node(this);
    }

    public Node cloneTree() throws CMException {
        Node clone = this.cloneNode();
        if (this.children != null) {
            for (int i = 0; i < this.numchildren; ++i) {
                Node child = (Node)this.children.elementAt(i);
                if (clone instanceof TablePartNode) {
                    TablePartNode cloneAsTP = (TablePartNode)clone;
                    cloneAsTP.addCell((CellNode)child.cloneTree());
                    continue;
                }
                clone.addChild(child.cloneTree());
            }
        }
        return clone;
    }

    public final VMScene getScene() {
        return this.scene;
    }

    public final Node getParent() {
        return this.parent;
    }

    public final int getType() {
        return this.type;
    }

    public final int getStartAddress() {
        return this.startAddress;
    }

    public final int getEndAddress() {
        return this.endAddress;
    }

    public final void setHorizontalAlign(int align) {
        this.horizontalAlign = align;
    }

    public final void setVerticalAlign(int align) {
        this.verticalAlign = align;
    }

    public final int getHorizontalAlign() {
        Node node = this;
        do {
            if (node.horizontalAlign == -1) continue;
            return node.horizontalAlign;
        } while ((node = node.getType() != 2 && node.getType() != 7 && node.getType() != 3 ? node.parent : null) != null);
        return 0;
    }

    public final int getVerticalAlign() {
        Node node = this;
        do {
            if (node.verticalAlign == -1) continue;
            return node.verticalAlign;
        } while ((node = node.getType() != 2 && node.getType() != 7 && node.getType() != 3 ? node.parent : null) != null);
        return 0;
    }

    public boolean checkStyle(int styleMask) {
        if ((this instanceof TextNode || this instanceof ImageNode) && (styleMask == 262144 || styleMask == 0x800000 || styleMask == 0x1000000 || styleMask == 0x1000000)) {
            return this.getParent().checkStyle(styleMask);
        }
        return (this.getStyle() & styleMask) == styleMask;
    }

    public final void setStyle(int styleFlags, boolean invalidate) {
        if ((this.style & styleFlags) != styleFlags) {
            this.style |= styleFlags;
            if (invalidate && this.scene.getHost() != null) {
                VMRect rect = this.getAbsoluteRect();
                this.scene.getHost().onSceneInvalidateRect(this.scene, rect);
            }
        }
    }

    public static final void setStyle_AllAncestors(Node node, int styleFlags, boolean invalidate) {
        while (node != null) {
            node.setStyle(styleFlags, invalidate);
            node = node.parent;
        }
    }

    private int getStyleCount(Node start, int styleMask) {
        int count = 0;
        for (int i = 0; i < start.numchildren; ++i) {
            Node node = start.getChild(i);
            count += node.getStyleCount(node, styleMask);
        }
        if (count == 0) {
            return (start.getStyle() & styleMask) == styleMask ? 1 : 0;
        }
        return count;
    }

    public int getStyleCount_AllDescendant(int styleMask) {
        if (this instanceof TextNode || this instanceof ImageNode) {
            return this.getStyleCount(this.getParent(), styleMask);
        }
        return this.getStyleCount(this, styleMask);
    }

    public static final void setStyle_Parent(Node node, int styleFlags, boolean invalidate) {
        if (node != null && node.parent != null) {
            node.parent.setStyle(styleFlags, invalidate);
        }
    }

    public final void clearStyle(int styleMask, boolean invalidate) {
        if ((this.style & styleMask) != 0) {
            this.style &= ~styleMask;
            if (invalidate && this.scene.getHost() != null) {
                VMRect rect = this.getAbsoluteRect();
                this.scene.getHost().onSceneInvalidateRect(this.scene, rect);
            }
        }
    }

    public int getStyle() {
        return this.style;
    }

    public final int getChildCount() {
        return this.numchildren;
    }

    public final Node getChild(int i) {
        if (this.children != null) {
            return (Node)this.children.elementAt(i);
        }
        return null;
    }

    public final void resetChildren() {
        if (this.children != null) {
            this.children.removeAllElements();
            this.children = null;
            this.numchildren = 0;
        }
    }

    public final void addChild(Node node) {
        if (this.children == null) {
            this.children = new Vector();
        }
        ++this.numchildren;
        node.parent = this;
        node.scene = this.scene;
        this.children.addElement(node);
    }

    public final VMRect getAbsoluteRect() {
        return this.getAbsoluteRect(null);
    }

    public final VMRect getAbsoluteRect(RenderState state) {
        int absTopLeftX = this.getAbsoluteTopLeftX(state);
        int absTopLeftY = this.getAbsoluteTopLeftY(state);
        return new VMRect(absTopLeftX, absTopLeftY, this.getRenderRect((RenderState)state).cx, this.getRenderRect((RenderState)state).cy);
    }

    public final VMRect getRect() {
        return this.rect;
    }

    public VMRect getRenderRect() {
        return this.getRenderRect(null);
    }

    public VMRect getRenderRect(RenderState state) {
        return state == null || state.isZoomed() ? this.getRect() : this.getUnzoomedRect();
    }

    public final void move(int newX, int newY) {
        this.rect.x = newX;
        this.rect.y = newY;
        this.unzoomedRect.x = newX;
        this.unzoomedRect.y = newY;
    }

    public final VMRect relativeToAbsolute(VMRect relRect, RenderState state) {
        int absTopLeftX = this.getAbsoluteTopLeftX(state);
        int absTopLeftY = this.getAbsoluteTopLeftY(state);
        VMRect absRect = new VMRect();
        absRect.x = absTopLeftX + relRect.x;
        absRect.y = absTopLeftY + relRect.y;
        absRect.cx = relRect.cx;
        absRect.cy = relRect.cy;
        return absRect;
    }

    public final VMRect absoluteToRelative(VMRect absRect, RenderState state) {
        int absTopLeftX = this.getAbsoluteTopLeftX(state);
        int absTopLeftY = this.getAbsoluteTopLeftY(state);
        VMRect relRect = new VMRect();
        relRect.x = absRect.x - absTopLeftX;
        relRect.y = absRect.y - absTopLeftY;
        relRect.cx = absRect.cx;
        relRect.cy = absRect.cy;
        return relRect;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSearchContext(VMScene scene) {
        String loadedText;
        if (this.getChildCount() > 0) {
            return "";
        }
        if (!this.checkStyle(16384)) {
            return "";
        }
        try {
            loadedText = scene.loadText(this);
        }
        catch (CMException ex) {
            if (VM.wouldLog(CLASS, 2)) {
                VM.log(CLASS, 2, "unable to build search context: " + ex.toString());
            }
            loadedText = "";
        }
        return loadedText;
    }

    public final Vector getMailtoContext(VMScene scene) {
        Vector mailtoContexts;
        block4: {
            if (this instanceof TextNode || this instanceof ImageNode) {
                return this.getParent().getMailtoContext(scene);
            }
            mailtoContexts = new Vector();
            if (!this.checkStyle(0x800000)) {
                return mailtoContexts;
            }
            try {
                mailtoContexts = scene.loadMailtoContext(this);
            }
            catch (CMException ex) {
                if (!VM.wouldLog(CLASS, 2)) break block4;
                VM.log(CLASS, 2, "unable to build drill context: " + ex.toString());
            }
        }
        return mailtoContexts;
    }

    public final DrillUpDownState getDrillUpDownContext(VMScene scene) {
        if (this instanceof TextNode || this instanceof ImageNode) {
            return this.getParent().getDrillUpDownContext(scene);
        }
        if (!this.checkStyle(0x1000000) && !this.checkStyle(0x2000000)) {
            return null;
        }
        try {
            return scene.loadDrillUpDownContext(this);
        }
        catch (CMException ex) {
            if (VM.wouldLog(CLASS, 2)) {
                VM.log(CLASS, 2, "unable to build drillUpDown context: " + ex.toString());
            }
            return null;
        }
    }

    public final Vector getDrillContext(VMScene scene) {
        Vector drillContexts;
        block4: {
            if (this instanceof TextNode || this instanceof ImageNode) {
                return this.getParent().getDrillContext(scene);
            }
            drillContexts = new Vector();
            if (!this.checkStyle(262144)) {
                return drillContexts;
            }
            try {
                drillContexts = scene.loadDrillContext(this);
            }
            catch (CMException ex) {
                if (!VM.wouldLog(CLASS, 2)) break block4;
                VM.log(CLASS, 2, "unable to build drill context: " + ex.toString());
            }
        }
        return drillContexts;
    }

    public Node findNodeFromAddress(int address) {
        if (address < this.startAddress) {
            return null;
        }
        if (address >= this.endAddress) {
            return null;
        }
        if (this.numchildren == 0) {
            return this;
        }
        for (int i = 0; i < this.numchildren; ++i) {
            Node descendent = (Node)this.children.elementAt(i);
            if ((descendent = descendent.findNodeFromAddress(address)) == null) continue;
            return descendent;
        }
        return this;
    }

    public Node findNodeFromPoint(int x, int y) {
        int margin = this.getMargin();
        if (x < this.rect.x - margin) {
            return null;
        }
        if (x >= this.rect.getRight() + margin) {
            return null;
        }
        if (y < this.rect.y - margin) {
            return null;
        }
        if (y >= this.rect.getBottom() + margin) {
            return null;
        }
        if (this.numchildren == 0 || this.checkStyle(8192)) {
            return this;
        }
        x -= this.rect.x;
        y -= this.rect.y;
        for (int i = 0; i < this.numchildren; ++i) {
            Node descendent = (Node)this.children.elementAt(i);
            if ((descendent = descendent.findNodeFromPoint(x, y)) == null) continue;
            return descendent;
        }
        return this;
    }

    public Node findNodeFromID(String targetID) {
        if (targetID == null) {
            return null;
        }
        if (this.id != null && targetID.equals(this.id)) {
            return this;
        }
        for (int i = 0; i < this.numchildren; ++i) {
            Node descendent = (Node)this.children.elementAt(i);
            if ((descendent = descendent.findNodeFromID(targetID)) == null) continue;
            return descendent;
        }
        return null;
    }

    public Node createFocusTree(Node parent, int focus, VMScene.Hints hints) throws CMException {
        return null;
    }

    public Vector findDescendentsFromStyle(int styleMask, boolean descendMatches) {
        Vector<Node> matches = new Vector<Node>();
        boolean checkChildren = true;
        if (this.checkStyle(styleMask)) {
            matches.addElement(this);
            if (!descendMatches) {
                checkChildren = false;
            }
        }
        if (checkChildren) {
            for (int i = 0; i < this.numchildren; ++i) {
                Node child = this.getChild(i);
                Vector childMatches = child.findDescendentsFromStyle(styleMask, descendMatches);
                int childCount = childMatches.size();
                for (int j = 0; j < childCount; ++j) {
                    matches.addElement((Node)childMatches.elementAt(j));
                }
            }
        }
        return matches;
    }

    protected boolean isVisible(RenderState state) {
        INodeVisibility visibility = this.getVisibility();
        return visibility.isVisible(this, state);
    }

    public boolean isSelectable() {
        return false;
    }

    public boolean isColorable() {
        if (!this.checkStyle(16384)) {
            return false;
        }
        if (this.checkStyle(32768)) {
            return false;
        }
        switch (this.getType()) {
            case 2: 
            case 4: {
                return false;
            }
        }
        return true;
    }

    public VMRect measureSelection(VMRect suggestedRect) {
        suggestedRect.inflateRect(1, 1);
        return suggestedRect;
    }

    public void paintSelection(RenderState state) {
        int cx = this.getRenderRect((RenderState)state).cx;
        int cy = this.getRenderRect((RenderState)state).cy;
        state.getPainter().setColor(VMColor.SELECTION_FILL_COLOR);
        state.getPainter().drawRect(0, 0, cx, cy);
        state.getPainter().drawRect(1, 1, cx - 2, cy - 2);
        state.getPainter().setColor(VMColor.DEFAULT_BACK_COLOR);
        state.getPainter().drawRect(2, 2, cx - 4, cy - 4);
    }

    public INodeVisibility getVisibility() {
        return DefaultNodeVisibility.instance();
    }

    public IKeyHandler getKeyHandler() {
        return null;
    }

    public IMouseHandler getMouseHandler() {
        return null;
    }

    public final IVMImage getZoomImage() {
        return this.zoomImage;
    }

    public final IVMImage buildZoomImageIfNecessary(IVMPainter painter, int pageWidth) throws CMException {
        int sceneWidth = this.getScene().getRootNode().getUnzoomedRect().cx;
        double zoomScale = (double)pageWidth / (double)sceneWidth;
        int zoomLevel = (int)(zoomScale * 100.0 + 0.5);
        return this.buildZoomImageIfNecessary(painter, zoomLevel, zoomScale, pageWidth);
    }

    public final int getPageWidth(int pageHeight) {
        int sceneHeight = this.getScene().getRootNode().getUnzoomedRect().cy;
        double zoomScale = (double)pageHeight / (double)sceneHeight;
        return (int)(zoomScale * (double)this.getScene().getRootNode().getUnzoomedRect().cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IVMImage buildZoomImageIfNecessary(IVMPainter painter, int zoomLevel, double zoomScale, int pageWidth) throws CMException {
        IVMReader reader = this.getScene().getRender().reader;
        RenderState state = new RenderState(3, reader, painter, null, pageWidth, pageWidth, zoomLevel, zoomScale, null, 240, false, this.getScene().getUnzoomedSampleTextSize());
        try {
            IVMImage iVMImage = this.zoomImage = this.loadZoomImage(state);
            return iVMImage;
        }
        finally {
            state.dispose();
        }
    }

    public boolean isZoomable(RenderState state) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (child.isZoomable(state)) continue;
            return false;
        }
        return true;
    }

    protected IVMImage loadZoomImage(RenderState state) throws CMException {
        return this.loadZoomImage(state, false);
    }

    protected IVMImage loadZoomImage(RenderState state, boolean cacheChecked) throws CMException {
        IVMImage image = null;
        String nodePath = this.getNodePath();
        if (!cacheChecked) {
            image = this.scene.getImageCache().loadZoomImageFromCache(nodePath, state.getPageWidth());
        }
        if (image == null) {
            image = this.generateZoomImage(state, cacheChecked);
        }
        return image;
    }

    protected IVMImage generateZoomImage(RenderState state, boolean cacheChecked) throws CMException {
        IVMImage image = null;
        double scale = this.getType() == 3 && state.getWidth(this) > 0 ? state.getWidthConversion() : state.getZoomScale();
        int cx = this.calculateZoomedTargetSize(this.getUnzoomedRect().cx, scale);
        int cy = this.calculateZoomedTargetSize(this.getUnzoomedRect().cy, scale);
        image = ZoomImageBuilder.buildNodeZoomImage(this, state, cx, cy);
        return image;
    }

    protected int calculateZoomedTargetSize(int unzoomedSize, double zoomScale) throws CMException {
        int cxFull = Math.max(1, unzoomedSize);
        int cx = CMMathHelper.multiplyIntByDouble(cxFull, zoomScale);
        if (cx <= 0) {
            if (VM.wouldLog(CLASS, 2)) {
                VM.log(CLASS, 2, "empty target size");
            }
            return 0;
        }
        if (cx > 16) {
            cx = cx / 4 * 4;
        }
        return cx;
    }

    public final VMRect getUnzoomedRect() {
        if (this.unzoomedRect == null) {
            return this.getRect();
        }
        return this.unzoomedRect;
    }

    public final void setUnzoomedRect(VMRect rect) {
        if (this.unzoomedRect == null) {
            this.unzoomedRect = new VMRect(rect);
        } else {
            this.unzoomedRect.copy(rect);
        }
    }

    public void transferToRenderRect(boolean isZoomed) {
        this.rect.copy(this.layoutRect);
        if (!isZoomed) {
            this.setUnzoomedRect(this.layoutRect);
        }
    }

    public final void logTree(String indent) {
        this.logTree(indent, VM.LOGTREEFORMAT_REGULAR, null, false, null);
    }

    public final void logTree(String indent, RenderState state) {
        this.logTree(indent, VM.LOGTREEFORMAT_REGULAR, null, false, state);
    }

    public final void logTree(String indent, int format, VMRect clipRect, boolean trimmed, RenderState state) {
    }

    public String getLogLine(int format, VMRect clipRect, boolean trimmed, RenderState state) {
        StringBuffer sb = new StringBuffer();
        if (format == VM.LOGTREEFORMAT_CSV) {
            if (trimmed && this.getRenderRect((RenderState)state).x > 0 && this.getRenderRect((RenderState)state).y > 0) {
                sb.append(",");
                sb.append("\"" + this.getNodePath() + "\"");
                sb.append(",");
                sb.append(this.getRenderRect((RenderState)state).x);
                sb.append(",");
                sb.append(this.getRenderRect((RenderState)state).y);
                sb.append(",");
                sb.append(this.getRenderRect((RenderState)state).cx);
                sb.append(",");
                sb.append(this.getRenderRect((RenderState)state).cy);
                sb.append(",");
                sb.append(this.getAbsoluteTopLeftX(state));
                sb.append(",");
                sb.append(this.getAbsoluteTopLeftY(state));
                VMRect absRect = this.getAbsoluteRect(state);
                VMRect rect = this.getRenderRect(state);
                if (clipRect == null) {
                    clipRect = new VMRect(0, 0, rect.cx, rect.cy);
                } else {
                    clipRect = this.getAbsoluteRect(state);
                    clipRect.intersectRect(clipRect);
                    clipRect = this.absoluteToRelative(clipRect, state);
                }
                if (clipRect != null && clipRect.intersects(absRect)) {
                    sb.append(",\"YES\"");
                } else {
                    sb.append(",\"NO\"");
                }
            }
        } else {
            sb.append("*" + this.getNodePath() + "* ");
            sb.append(CMStringHelper.formatAddress(this.startAddress));
            sb.append("-");
            sb.append(CMStringHelper.formatAddress(this.endAddress));
            sb.append(" rect.x:");
            sb.append(this.getRect().x);
            sb.append(" rect.y:");
            sb.append(this.getRect().y);
            sb.append(" rect.cx:");
            sb.append(this.getRect().cx);
            sb.append(" rect.cy:");
            sb.append(this.getRect().cy);
            sb.append(" urect.x:");
            sb.append(this.getUnzoomedRect().x);
            sb.append(" urect.y:");
            sb.append(this.getUnzoomedRect().y);
            sb.append(" urect.cx:");
            sb.append(this.getUnzoomedRect().cx);
            sb.append(" urect.cy:");
            sb.append(this.getUnzoomedRect().cy);
            sb.append(" lrect.x:");
            sb.append(this.getLayoutRect().x);
            sb.append(" lrect.y:");
            sb.append(this.getLayoutRect().y);
            sb.append(" lrect.cx:");
            sb.append(this.getLayoutRect().cx);
            sb.append(" lrect.cy:");
            sb.append(this.getLayoutRect().cy);
            VMRect absRect = this.getAbsoluteRect(state);
            sb.append(" arect.x:");
            sb.append(absRect.x);
            sb.append(" arect.y:");
            sb.append(absRect.y);
            sb.append(" arect.cx:");
            sb.append(absRect.cx);
            sb.append(" arect.cy:");
            sb.append(absRect.cy);
            sb.append(" rel: ");
            sb.append(CMStringHelper.formatPoint(this.getRenderRect((RenderState)state).x, this.getRenderRect((RenderState)state).y));
            sb.append("-");
            sb.append(CMStringHelper.formatPoint(this.getRenderRect(state).getRight(), this.getRenderRect(state).getBottom()));
            int wtlX = this.getAbsoluteTopLeftX(state);
            int wtlY = this.getAbsoluteTopLeftY(state);
            sb.append(" abs: ");
            sb.append(CMStringHelper.formatPoint(wtlX, wtlY));
            sb.append("-");
            sb.append(CMStringHelper.formatPoint(wtlX + this.getRenderRect((RenderState)state).cx, wtlY + this.getRenderRect((RenderState)state).cy));
            if (this.scene.getSelection().isSelectable(this)) {
                sb.append(" selectable");
            }
            switch (this.getHorizontalAlign()) {
                case 2: {
                    sb.append(" center");
                    break;
                }
                case 0: {
                    sb.append(" left");
                    break;
                }
                case 1: {
                    sb.append(" right");
                }
            }
        }
        return sb.toString();
    }

    public boolean isFullWidth() {
        return false;
    }

    public final void onBuildBegin(Node parent, int startAddress) {
        this.parent = parent;
        this.startAddress = startAddress;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public void onBuildEnd(int endAddress) throws CMException {
        this.endAddress = endAddress;
    }

    public void size(RenderState state) throws CMException {
        state.pushCurrentNode(this);
        this.clearStyle(8192, false);
        boolean cacheChecked = false;
        if (this.alwaysCheckCache()) {
            this.zoomImage = this.scene.getImageCache().loadZoomImageFromCache(this.getNodePath(), state.getPageWidth());
            cacheChecked = true;
        }
        if (this.zoomImage == null && state.isZoomed() && this.scene.getSelection().isSelectable(this) && !this.isZoomable(state)) {
            this.zoomImage = this.loadZoomImage(state, cacheChecked);
        }
        if (this.zoomImage != null) {
            this.setStyle(8192, false);
            int cx = this.zoomImage.onImageGetSize().x;
            int cy = this.zoomImage.onImageGetSize().y;
            this.setPreferredSize(cx, cy, state);
            this.scene.getImageCache().saveZoomImageToCache(this.zoomImage, this.getNodePath(), state.getPageWidth(), false);
        } else if (this.children != null) {
            for (int i = 0; i < this.numchildren; ++i) {
                Node child = (Node)this.children.elementAt(i);
                child.size(state);
            }
        }
        state.popCurrentNode(0);
    }

    public void setPreferredSize(int cx, int cy, RenderState state) {
        this.layoutRect.ensureMinimumSize(cx, cy);
    }

    public void onSizeEnd(int cx, int cy, RenderState state) {
        this.setPreferredSize(cx, cy, state);
    }

    public VMPoint getPreferredSize(RenderState state) {
        int cx = this.getPreferredSizeX();
        int cy = this.getPreferredSizeY();
        return new VMPoint(cx, cy);
    }

    public int getPreferredSizeX() {
        if (this.checkStyle(8192) && this.zoomImage != null) {
            return this.zoomImage.onImageGetSize().x;
        }
        return this.layoutRect.cx;
    }

    public int getPreferredSizeY() {
        if (this.checkStyle(8192) && this.zoomImage != null) {
            return this.zoomImage.onImageGetSize().y;
        }
        return this.layoutRect.cy;
    }

    public VMPoint getMaxSize(RenderState state) {
        if (this.maxSize == null) {
            return VMPoint.ZERO;
        }
        return this.maxSize;
    }

    public void setMaxSize(VMPoint maxSize) {
        this.maxSize = maxSize;
    }

    public void resetLayout() {
        this.layoutRect.setRect(0, 0, 0, 0);
        this.zoomImage = null;
        this.clearStyle(8192, false);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).resetLayout();
        }
    }

    public void layout(RenderState renderState, int x, int y) throws CMException {
        renderState.pushCurrentNode(this);
        if (this.checkStyle(8192) && this.zoomImage != null) {
            int cx = this.zoomImage.onImageGetSize().x;
            int cy = this.zoomImage.onImageGetSize().y;
            this.setLayout(x, y, cx, cy, renderState);
        } else {
            ILayout layout = this.getLayout();
            layout.layout(this, renderState, x, y);
        }
        renderState.popCurrentNode(0);
    }

    public void layout2(RenderState renderState, int x, int y) throws CMException {
        renderState.pushCurrentNode(this);
        if (!this.checkStyle(8192)) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                Node child = this.getChild(i);
                boolean widthForced = false;
                if (this.type == 3 && renderState.getWidth(this) == 0) {
                    CellNode cell = (CellNode)this;
                    TableNode table = cell.getTable();
                    int colspan = Math.min(cell.getColspan(), table.getColumnCount() - cell.getColumn());
                    if (colspan > 1 && cell.hasTextNodeChild()) {
                        TablePartNode part = cell.getTablePart();
                        VMRect cellExtent = new VMRect();
                        for (int span = 0; span < colspan; ++span) {
                            cellExtent.cx += table.getColumnWidth(cell.getColumn() + span);
                        }
                        if (this.layoutRect.cx >= cellExtent.cx) {
                            this.layoutRect.cx = cellExtent.cx;
                            renderState.setWidth(cellExtent.cx);
                            widthForced = true;
                        }
                    }
                }
                child.layout2(renderState, x, y);
                if (!widthForced) continue;
                renderState.setWidth(0);
            }
            ILayout layout = this.getLayout();
            layout.layout(this, renderState, x, y);
        }
        renderState.popCurrentNode(0);
    }

    public ILayout getLayout() {
        return FlowLayout.instance();
    }

    public int getMargin() {
        return 2;
    }

    public int getPadding() {
        return 0;
    }

    public void setLayout(int x, int y, int cx, int cy, RenderState state) {
        this.layoutRect.setRect(x, y, cx, cy);
    }

    public final VMRect getLayoutRect() {
        return this.layoutRect;
    }

    public void setTempLayoutCx(int tempLayoutCx) {
        this.tempLayoutCx = tempLayoutCx;
    }

    public void onLayoutEnd(RenderState renderState) throws CMException {
        renderState.pushCurrentNode(this);
        int childCount = this.getChildCount();
        if (!this.checkStyle(8192) && this.getLayout().layoutType() == 0 && this.type != 7 && this.tempLayoutCx != 0) {
            if (this.isFullWidth()) {
                this.layoutRect.x = 0;
                this.layoutRect.cx = this.getPreferredSize((RenderState)renderState).x;
            }
            int offset = this.layoutRect.cx - this.tempLayoutCx;
            for (int i = 0; i < childCount; ++i) {
                int hAlign;
                Node child = this.getChild(i);
                int n = hAlign = this.type == 3 && this.getHorizontalAlign() != 0 ? this.getHorizontalAlign() : child.getHorizontalAlign();
                if (hAlign != 2 && hAlign != 1) continue;
                int x = child.getLayoutRect().x;
                if ((x += hAlign == 2 ? offset / 2 : offset) < 0 && child.getLayoutRect().x > 0) break;
                if (x < 0) {
                    x = 0;
                }
                child.getLayoutRect().x = x;
            }
        }
        this.transferToRenderRect(renderState.isZoomed());
        if (!this.checkStyle(8192)) {
            for (int i = 0; i < childCount; ++i) {
                Node child = this.getChild(i);
                child.onLayoutEnd(renderState);
            }
            this.paintZoomImage = null;
        } else if (this.zoomImage != null) {
            this.paintZoomImage = this.zoomImage;
            this.zoomImage = null;
        }
        this.maxSize = null;
        renderState.popCurrentNode(0);
    }

    public void paint(RenderState state) throws CMException {
        if (wouldDebugLog && VM.wouldLog(CLASS, 0)) {
            VM.log(CLASS, 0, this.toString() + " paint begin");
        }
        if (state.getClipRect() != null) {
            VMRect rect = this.getAbsoluteRect(state);
            if (!state.getClipRect().intersects(rect)) {
                if (wouldDebugLog && VM.wouldLog(CLASS, 0)) {
                    VM.log(CLASS, 0, this.toString() + " paint end (clipped out)");
                }
                return;
            }
        }
        state.pushCurrentNode(this);
        VMRect clientRect = new VMRect(this.getRenderRect(state));
        if (this.paintZoomImage != null && state.getExec() != 11) {
            if (this.paintZoomImage.onImageGetSize().x < clientRect.cx || this.paintZoomImage.onImageGetSize().y < clientRect.cy) {
                this.paintBackground(state, clientRect, true);
            }
            state.getPainter().drawImage(0, 0, this.paintZoomImage);
            if (state.isSelected()) {
                this.paintSelection(state);
            }
            state.popCurrentNode(0);
            if (wouldDebugLog && VM.wouldLog(CLASS, 0)) {
                VM.log(CLASS, 0, this.toString() + " paint end (zoom image)");
            }
            return;
        }
        boolean drawSelection = false;
        drawSelection = this.paintBackground(state, clientRect, false);
        if (this.numchildren > 0) {
            for (int i = 0; i < this.numchildren; ++i) {
                Node child = (Node)this.children.elementAt(i);
                child.paint(state);
            }
        }
        if (state.isSelected() && drawSelection) {
            this.paintSelection(state);
        }
        state.popCurrentNode(0);
    }

    public boolean paintBackground(RenderState state, VMRect clientRect, boolean forceDrawSelection) {
        int backColor;
        boolean drawSelection = true;
        if (state.isSelected() && this.isColorable() && !forceDrawSelection) {
            state.setBackColor(VMColor.SELECTION_FILL_COLOR);
            state.setTextColor(VMColor.SELECTION_TEXT_COLOR);
            drawSelection = false;
        }
        if ((backColor = state.getBackColor()) != 0xF000000) {
            CellNode c;
            state.getPainter().setColor(backColor);
            int xOffset = 0;
            int xLength = clientRect.cx + 1;
            if (this instanceof CellNode && (c = (CellNode)this).hasTextNodeChild()) {
                xOffset = 1;
                xLength = clientRect.cx;
            }
            state.getPainter().fillRect(xOffset, 0, xLength, clientRect.cy + 1);
        }
        return drawSelection;
    }

    public void onPaintEnd(RenderState state) {
    }

    public void find(FindState state) throws CMException {
        state.pushCurrentNode(this);
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            child.find(state);
        }
        state.popCurrentNode(0);
    }

    public String getNodePath() {
        if (this.parent == null || this.parent.children == null) {
            return "";
        }
        int siblingCount = this.parent.numchildren;
        int siblingIndex = -1;
        for (int i = 0; i < siblingCount; ++i) {
            if (this != this.parent.children.elementAt(i)) continue;
            siblingIndex = i;
            break;
        }
        if (siblingIndex == -1) {
            if (VM.wouldLog(CLASS, 3)) {
                VM.log(CLASS, 3, "can't find sibling index");
            }
            return "e";
        }
        String nodePathID = this.parent.getNodePath();
        if (nodePathID.length() > 0) {
            nodePathID = nodePathID + ".";
        }
        nodePathID = nodePathID + Integer.toString(siblingIndex);
        return nodePathID;
    }

    public Node findNodeFromNodePath(String nodePath, int startIndex) {
        if (nodePath == null) {
            return null;
        }
        if (startIndex < 0) {
            return null;
        }
        if (startIndex >= nodePath.length()) {
            return this;
        }
        int childIndex = 0;
        boolean done = false;
        while (!done && startIndex < nodePath.length()) {
            char ch = nodePath.charAt(startIndex);
            switch (ch) {
                case '.': {
                    done = true;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    childIndex *= 10;
                    childIndex += ch - 48;
                    break;
                }
                default: {
                    if (!VM.wouldLog(CLASS, 2)) break;
                    VM.log(CLASS, 2, "invalid char in node path: " + ch);
                }
            }
            ++startIndex;
        }
        if (childIndex < 0 || childIndex >= this.numchildren) {
            if (VM.wouldLog(CLASS, 3)) {
                VM.log(CLASS, 3, "invalid child index in node path: " + childIndex);
            }
            return null;
        }
        Node child = this.getChild(childIndex);
        return child.findNodeFromNodePath(nodePath, startIndex);
    }

    public boolean alwaysCheckCache() {
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof Node) {
            Node other = (Node)o;
            return this.getStartAddress() == other.getStartAddress() && this.getEndAddress() == other.getEndAddress() && this.getType() == other.getType();
        }
        return false;
    }

    private int getAbsoluteTopLeftX(RenderState state) {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getAbsoluteTopLeftX(state) + this.getRenderRect((RenderState)state).x;
    }

    private int getAbsoluteTopLeftY(RenderState state) {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getAbsoluteTopLeftY(state) + this.getRenderRect((RenderState)state).y;
    }
}

