/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.node.CellNode;
import com.cognos.mobile.vm.node.TableNode;

public class NodeFinder {
    private static final Class CLASS = NodeFinder.class;

    public static Node findNodeByNodePath(VMScene scene, String nodePath) {
        return scene.getRootNode().findNodeFromNodePath(nodePath, 0);
    }

    public static CellNode findTableCell(VMScene scene, String tableID, int row, int column) {
        Node node = scene.getRootNode().findNodeFromID(tableID);
        if (node == null || node.getType() != 2) {
            VM.log(CLASS, 2, "table '" + tableID + "' not found");
            return null;
        }
        TableNode table = (TableNode)node;
        CellNode cell = table.findTableCell(row, column);
        if (cell == null) {
            VM.log(CLASS, 2, "failed to find cell " + CMStringHelper.formatPoint(row, column));
            return null;
        }
        return cell;
    }

    public static CellNode findOtherTableCell(VMScene scene, VMScene otherScene, int drow, int dcol) {
        CellNode otherCell;
        block7: {
            Node selectedNode = scene.getSelection().getSelectedNode();
            if (selectedNode == null || selectedNode.getType() != 3) {
                VM.log(CLASS, 2, "no table cell selected");
                return null;
            }
            CellNode selectedCell = (CellNode)selectedNode;
            VMPoint before = selectedCell.getTable().focusToAbsolute(selectedCell.getRow(), selectedCell.getColumn());
            if (VM.wouldLog(CLASS, 0)) {
                VM.log(CLASS, 0, "old selected cell: " + CMStringHelper.formatPoint(before.x, before.y));
            }
            if ((otherCell = NodeFinder.findTableCell(otherScene, selectedCell.getTable().getID(), before.y, before.x)) == null) {
                VM.log(CLASS, 3, "failed to find " + CMStringHelper.formatPoint(before.x, before.y));
                return null;
            }
            VMPoint after = new VMPoint();
            do {
                after.x = otherCell.getColumn();
                after.y = otherCell.getRow();
                if (dcol > 0) {
                    after.x += otherCell.getColspan();
                    --dcol;
                    continue;
                }
                if (dcol < 0) {
                    --after.x;
                    ++dcol;
                    continue;
                }
                if (drow > 0) {
                    after.y += otherCell.getRowspan();
                    --drow;
                    continue;
                }
                if (drow >= 0) break block7;
                --after.y;
                ++drow;
            } while ((otherCell = otherCell.getTable().findTableCell(after.y, after.x)) != null);
            VM.log(CLASS, 3, "failed to find " + CMStringHelper.formatPoint(after.x, after.y));
            return null;
        }
        return otherCell;
    }
}

