/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import java.io.IOException;
import java.io.InputStream;

public class PlatformIndependentReader {
    private final InputStream _in;

    public PlatformIndependentReader(InputStream in) {
        this._in = in;
    }

    public int readInt() throws IOException {
        int i = 0;
        i |= this._in.read() & 0xFF;
        i <<= 8;
        i |= this._in.read() & 0xFF;
        i <<= 8;
        i |= this._in.read() & 0xFF;
        i <<= 8;
        return i |= this._in.read() & 0xFF;
    }

    public byte readByte() throws IOException {
        return (byte)(this._in.read() & 0xFF);
    }

    public int available() throws IOException {
        return this._in.available();
    }

    public String readString() throws IOException {
        int len = this._in.read() & 0xFF;
        len <<= 8;
        byte[] buf = new byte[len |= this._in.read() & 0xFF];
        this.readBytes(buf, 0, len);
        String s = new String(buf, "UTF-8");
        s.intern();
        return s;
    }

    public void readBytes(byte[] b, int offset, int length) throws IOException {
        int pos;
        int r;
        for (pos = 0; pos < length && (r = this._in.read(b, offset + pos, length - pos)) >= 1; pos += r) {
        }
        if (pos < length) {
            throw new IOException("premature end of stream");
        }
    }
}

