/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PlatformIndependentWriter {
    private final OutputStream _out;

    public PlatformIndependentWriter(OutputStream out) {
        this._out = out;
    }

    public void write(int i) throws IOException {
        this._out.write((i & 0xFF000000) >> 24 & 0xFF);
        this._out.write((i & 0xFF0000) >> 16 & 0xFF);
        this._out.write((i & 0xFF00) >> 8 & 0xFF);
        this._out.write(i & 0xFF);
    }

    public void write(String s) throws IOException {
        byte[] b = this.convertToJavaModifiedUTF8(s);
        this._out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this._out.write(b);
    }

    public byte[] convertToJavaModifiedUTF8(String value) throws IOException {
        char c;
        int i;
        int len = value.length();
        int sum = 0;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(value.length() * 2);
        for (i = 0; i < len && sum <= 65535; ++i) {
            c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++sum;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                sum += 2;
                continue;
            }
            sum += 3;
        }
        if (sum > 65535) {
            throw new IOException("string too long");
        }
        bytes.write((sum & 0xFF00) >> 8);
        bytes.write(sum & 0xFF);
        for (i = 0; i < len; ++i) {
            c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytes.write(c);
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                bytes.write(0xC0 | 0x1F & c >> 6);
                bytes.write(0x80 | 0x3F & c);
                continue;
            }
            bytes.write(0xE0 | 0xF & c >> 12);
            bytes.write(0x80 | 0x3F & c >> 6);
            bytes.write(0x80 | 0x3F & c);
        }
        return bytes.toByteArray();
    }
}

