/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.node.GroupNode;
import com.cognos.mobile.vm.node.SpotNode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public class Selection {
    private static final int SEARCH_INCREMENT = 2;
    public static final int FLAG_INVALIDATE = 1;
    public static final int FLAG_FORCE = 2;
    public static final int FLAG_LIMIT_SCROLL = 4;
    public static final int FLAG_SCROLL_UP = 8;
    public static final int FLAG_SCROLL_DOWN = 16;
    public static final int FLAG_SCROLL_LEFT = 32;
    public static final int FLAG_SCROLL_RIGHT = 64;
    public static final int FLAG_SCROLL_MASK = 120;
    public static final int PAGE_TO_LINE_DIVISOR = 4;
    public static final int SPOTS_INIT_CAP = 20;
    private static final Class CLASS = Selection.class;
    private VMScene scene;
    private Vector selectable;
    private Vector tagged;
    private Vector spots;
    private String tagString;
    private int current;

    public Selection(VMScene scene) {
        this.scene = scene;
        this.current = -1;
        this.selectable = new Vector();
        this.tagged = new Vector();
        this.spots = new Vector(20);
    }

    public void buildSelectableNodes() {
        this.selectable = new Vector();
        this.selectable = this.buildSelectableNodes(true, this.scene.getRootNode(), this.selectable);
        if (this.selectable.size() == 1) {
            Node newRoot = (Node)this.selectable.elementAt(0);
            this.selectable.removeAllElements();
            this.selectable = this.buildSelectableNodes(true, newRoot, this.selectable);
        }
        this.spots.trimToSize();
        this.selectFirst(1, 0);
    }

    public void sortSelectableNodes() {
        int i;
        int count = this.selectable.size();
        Node[] array = new Node[count];
        for (i = 0; i < count; ++i) {
            array[i] = (Node)this.selectable.elementAt(i);
        }
        Arrays.sort(array, new SelectionComparator(true));
        for (i = 0; i < count; ++i) {
            this.selectable.setElementAt(array[i], i);
        }
    }

    public Node getSelectedNode() {
        if (this.current < 0 || this.current >= this.selectable.size()) {
            return null;
        }
        return (Node)this.selectable.elementAt(this.current);
    }

    public boolean isSelectable(Node node) {
        return this.selectable.contains(node);
    }

    public boolean isTagged(Node node) {
        return this.tagged.contains(node);
    }

    public int getSelectableCount() {
        return this.selectable.size();
    }

    public Node getSelectable(int index) {
        return (Node)this.selectable.elementAt(index);
    }

    public Node selectFirst(int dir, int flags) {
        if (this.selectable.isEmpty()) {
            return null;
        }
        int newCurrent = dir > 0 ? 0 : this.selectable.size() - 1;
        return this.select(newCurrent, dir, flags | 2);
    }

    public Node selectNext(int dir, int flags, boolean allowWraparound) {
        if (this.selectable.isEmpty()) {
            return null;
        }
        int newCurrent = this.current + (dir > 0 ? 1 : -1);
        if (allowWraparound) {
            if (newCurrent < 0) {
                newCurrent = this.selectable.size() - 1;
            }
            if (newCurrent > this.selectable.size() - 1) {
                newCurrent = 0;
            }
        } else if (newCurrent < 0 || newCurrent > this.selectable.size() - 1) {
            return null;
        }
        return this.select(newCurrent, dir, flags | 2);
    }

    public Node selectDown(int dir, int flags) {
        int maxSearchHeight = this.scene.getViewport().getViewportHeight() / 4;
        return this.selectDirectional(maxSearchHeight, 0, dir, flags);
    }

    public Node selectRight(int dir, int flags) {
        int maxSearchWidth = this.scene.getViewport().getViewportWidth() / 2;
        return this.selectDirectional(maxSearchWidth, dir, 0, flags);
    }

    public Node selectByPoint(int x, int y, int flags) {
        Node hitNode = this.scene.getRootNode().findNodeFromPoint(x, y);
        if (hitNode == null) {
            return null;
        }
        int newCurrent = this.findSelectableNode(hitNode);
        if (newCurrent == -1) {
            return null;
        }
        return this.select(newCurrent, 1, flags);
    }

    private Node selectDirectional(int maxSearchPixels, int xdir, int ydir, int flags) {
        int[] curX;
        if (this.selectable.isEmpty()) {
            return null;
        }
        int curY = 0;
        int dir = 0;
        VMRect absRect = this.getSelectedNode().getAbsoluteRect();
        VMRect parentAbsRect = this.getSelectedNode().getParent().getAbsoluteRect();
        if (xdir > 0) {
            dir = 1;
            xdir = 1;
            ydir = 0;
            curX = new int[]{absRect.getRight()};
            curY = absRect.y + 2;
        } else if (xdir < 0) {
            dir = -1;
            xdir = -1;
            ydir = 0;
            curX = new int[]{absRect.x};
            curY = absRect.y + 2;
        } else if (ydir > 0) {
            dir = 1;
            xdir = 0;
            ydir = 1;
            curX = new int[]{absRect.x, parentAbsRect.x, parentAbsRect.x + parentAbsRect.cx / 2, parentAbsRect.x + parentAbsRect.cx};
            curY = absRect.getBottom() + 2;
        } else {
            dir = 1;
            xdir = 0;
            ydir = -1;
            curX = new int[]{absRect.x, parentAbsRect.x, parentAbsRect.x + parentAbsRect.cx / 2, parentAbsRect.x + parentAbsRect.cx};
            curY = absRect.y - 2;
        }
        if (dir == 0) {
            return null;
        }
        int newCurrent = -1;
        for (int i = 0; i < curX.length && !this.isFound(newCurrent = this.findNode(maxSearchPixels, curX[i], curY, xdir, ydir)); ++i) {
        }
        if (!this.isFound(newCurrent)) {
            VM.log(CLASS, 3, "no node found in direction specified @@@@REPLACE@@@@");
            return null;
        }
        return this.select(newCurrent, dir, flags | 2);
    }

    private int findNode(int maxSearchPixels, int curX, int curY, int xdir, int ydir) {
        int newCurrent = -1;
        for (int attempts = 0; attempts < maxSearchPixels / 2 && !this.isFound(newCurrent); ++attempts) {
            Node hitNode = this.findSelectableNodeFromPoint(curX += 2 * xdir, curY += 2 * ydir);
            if (hitNode != null && (newCurrent = this.findSelectableNode(hitNode)) != -1 && newCurrent != this.current) continue;
        }
        return newCurrent;
    }

    private boolean isFound(int newCurrent) {
        return newCurrent != -1 && newCurrent != this.current;
    }

    public void reselect() {
        if (this.current >= 0 && this.current < this.selectable.size()) {
            this.select(this.current, 1, 2);
        }
    }

    public Node select(Node newSelectedNode) {
        return this.select(newSelectedNode, 1, 2);
    }

    public Node select(Node newSelectedNode, int dir, int flags) {
        int newCurrent = this.selectable.indexOf(newSelectedNode);
        if (newCurrent == -1) {
            return null;
        }
        return this.select(newCurrent, dir, flags);
    }

    public void tag(Vector nodes, String findString, boolean invalidate) {
        if (invalidate && this.scene.getHost() != null) {
            this.invalidateTaggedNodes();
        }
        this.tagged = new Vector(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = (Node)nodes.elementAt(i);
            this.tagNode(node);
        }
        this.tagString = findString;
        if (invalidate && this.scene.getHost() != null) {
            this.invalidateTaggedNodes();
        }
    }

    public String getTagString() {
        return this.tagString;
    }

    public int getTaggedCount() {
        return this.tagged.size();
    }

    public Node selectFirstTagged(int dir, int flags) {
        if (this.tagged.isEmpty()) {
            return null;
        }
        int index = dir > 0 ? 0 : this.tagged.size() - 1;
        Node node = (Node)this.tagged.elementAt(index);
        return this.select(node, dir, flags | 2);
    }

    public Node selectNextTagged(int dir, int flags) {
        Node node;
        int increment;
        if (this.tagged.isEmpty()) {
            return null;
        }
        int newCurrent = this.current;
        int n = increment = dir > 0 ? 1 : -1;
        do {
            if ((newCurrent += increment) < 0) {
                newCurrent = this.selectable.size() - 1;
            }
            if (newCurrent > this.selectable.size() - 1) {
                newCurrent = 0;
            }
            if (newCurrent != this.current) continue;
            return null;
        } while (!this.tagged.contains(node = (Node)this.selectable.elementAt(newCurrent)));
        return this.select(node, dir, flags | 2);
    }

    private Vector buildSelectableNodes(boolean isSceneRoot, Node node, Vector selectable) {
        if (!isSceneRoot && node.isSelectable()) {
            this.addSelectableElement(selectable, node);
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                Node child = node.getChild(i);
                if (child.isSelectable()) {
                    if (child.getType() == 8 && node.getType() == 4 && ((GroupNode)node).getGroupType() == 5) continue;
                    this.addSelectableElement(selectable, child);
                    continue;
                }
                if (!child.checkStyle(16384) && !child.checkStyle(32768) && child.getType() != 3 && child.getType() != 7) continue;
                selectable = this.buildSelectableNodes(false, child, selectable);
            }
        }
        return selectable;
    }

    private void addSelectableElement(Vector selectable, Node node) {
        int index;
        selectable.addElement(node);
        if (node.getType() == 5 && (index = ((SpotNode)node).getIndex()) != -1) {
            if (this.spots.size() < index + 1) {
                this.spots.ensureCapacity(index + 1);
                this.spots.setSize(index + 1);
            }
            try {
                this.spots.setElementAt(node, index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                boolean bl = true;
            }
        }
    }

    private Node select(int newCurrent, int dir, int flags) {
        if (newCurrent < 0 || newCurrent >= this.selectable.size()) {
            VM.log(CLASS, 2, "invalid selection index: " + newCurrent);
            return null;
        }
        Node oldSelectedNode = this.getSelectedNode();
        Node newSelectedNode = (Node)this.selectable.elementAt(newCurrent);
        int oldViewportX = this.scene.viewport.x;
        int oldViewportY = this.scene.viewport.y;
        boolean scrolled = false;
        if (newCurrent != this.current || 0 != (flags & 2)) {
            scrolled = newSelectedNode.getVisibility().ensureNodeVisible(newSelectedNode, true, dir, false);
        }
        if (scrolled && 0 != (flags & 4)) {
            int maxX = this.scene.viewport.getViewportWidth() / 4;
            int maxY = this.scene.viewport.getViewportHeight() / 4;
            int deltaX = this.scene.viewport.x - oldViewportX;
            int deltaY = this.scene.viewport.y - oldViewportY;
            boolean cancel = false;
            switch (flags & 0x78) {
                case 32: {
                    if (deltaX <= maxX || this.scene.viewport.y != oldViewportY) break;
                    this.scene.viewport.x = oldViewportX + maxX;
                    cancel = true;
                    break;
                }
                case 64: {
                    if (deltaX >= -maxX || this.scene.viewport.y != oldViewportY) break;
                    this.scene.viewport.x = oldViewportX - maxX;
                    cancel = true;
                    break;
                }
                case 8: {
                    if (deltaY <= maxY || this.scene.viewport.x != oldViewportX) break;
                    this.scene.viewport.y = oldViewportY + maxY;
                    cancel = true;
                    break;
                }
                case 16: {
                    if (deltaY >= -maxY || this.scene.viewport.x != oldViewportX) break;
                    this.scene.viewport.y = oldViewportY - maxY;
                    cancel = true;
                }
            }
            if (cancel) {
                newSelectedNode = oldSelectedNode;
            }
        }
        if (newCurrent != this.current) {
            this.current = newCurrent;
            if (this.scene.getHost() != null) {
                this.scene.getHost().onSceneSelectionChanged(this.scene, this.getSelectedNode());
            }
        }
        if (0 != (flags & 1) && this.scene.getHost() != null) {
            if (scrolled) {
                this.scene.getHost().onSceneInvalidateRect(this.scene, null);
            } else if (newSelectedNode != oldSelectedNode) {
                if (newSelectedNode != null) {
                    VMRect rect = newSelectedNode.getAbsoluteRect();
                    rect = newSelectedNode.measureSelection(rect);
                    this.scene.getHost().onSceneInvalidateRect(this.scene, rect);
                }
                if (oldSelectedNode != null) {
                    VMRect rect = oldSelectedNode.getAbsoluteRect();
                    rect = newSelectedNode.measureSelection(rect);
                    this.scene.getHost().onSceneInvalidateRect(this.scene, rect);
                }
            }
        }
        return this.getSelectedNode();
    }

    private void tagNode(Node node) {
        while (node != null && !this.selectable.contains(node)) {
            node = node.getParent();
        }
        if (node != null && !this.tagged.contains(node)) {
            this.tagged.addElement(node);
        }
    }

    private Node findSelectableNodeFromPoint(int x, int y) {
        for (int j = 0; j < this.selectable.size(); ++j) {
            Node thisNode = (Node)this.selectable.elementAt(j);
            int margin = thisNode.getMargin() / 2;
            if (y < thisNode.getAbsoluteRect().y - margin || y >= thisNode.getAbsoluteRect().getBottom() + margin || x < thisNode.getAbsoluteRect().x - margin || x >= thisNode.getAbsoluteRect().getRight() + margin) continue;
            return thisNode;
        }
        return null;
    }

    private int findSelectableNode(Node hitNode) {
        int newCurrent = this.selectable.indexOf(hitNode);
        while (hitNode != null && newCurrent == -1) {
            hitNode = hitNode.getParent();
            newCurrent = this.selectable.indexOf(hitNode);
        }
        return newCurrent;
    }

    private void invalidateTaggedNodes() {
        for (int i = 0; i < this.tagged.size(); ++i) {
            Node node = (Node)this.tagged.elementAt(i);
            this.scene.getHost().onSceneInvalidateRect(this.scene, node.getAbsoluteRect());
        }
    }

    public Vector getSelectable() {
        return this.selectable;
    }

    public Node getSpot(int index) {
        try {
            return (Node)this.spots.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    private class SelectionComparator
    implements Comparator {
        private boolean sortByY;

        public SelectionComparator(boolean sortByY) {
            this.sortByY = sortByY;
        }

        public int compare(Object o1, Object o2) {
            int coord2;
            Node n1 = (Node)o1;
            Node n2 = (Node)o2;
            int coord1 = this.sortByY ? n1.getAbsoluteRect().y : n1.getAbsoluteRect().x;
            int n = coord2 = this.sortByY ? n2.getAbsoluteRect().y : n2.getAbsoluteRect().x;
            if (coord1 < coord2) {
                return -1;
            }
            if (coord1 > coord2) {
                return 1;
            }
            coord1 = this.sortByY ? n1.getAbsoluteRect().x : n1.getAbsoluteRect().y;
            int n3 = coord2 = this.sortByY ? n2.getAbsoluteRect().x : n2.getAbsoluteRect().y;
            if (coord1 < coord2) {
                return -1;
            }
            if (coord1 > coord2) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    }
}

