/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMIntSet;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.CMUrlConstants;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.common.RangeList;
import com.cognos.mobile.event.Event;
import com.cognos.mobile.event.IEvent;
import com.cognos.mobile.event.IEventListener;
import com.cognos.mobile.event.IEventManager;
import com.cognos.mobile.inbox.EmptyInbox;
import com.cognos.mobile.inbox.IInboxSource;
import com.cognos.mobile.model.data.Render;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.ISynchronizer;
import com.cognos.mobile.vm.IVMSerializable;
import com.cognos.mobile.vm.InboxItem;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;
import com.cognos.mobile.vm.VMRender;
import com.cognos.mobile.xml.XML;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class VMInbox
implements IVMSerializable,
IEventListener,
IInboxSource.Listener,
MobileServiceProxy.ServerRequestModifier {
    private static final Class CLASS = VMInbox.class;
    private static boolean wouldDebugLog = VM.wouldLog(CLASS, 0);
    private static final int CURRENT_VERSION = 2;
    private final RangeList openedRendersList = new RangeList();
    private CMIntSet deletedRenderIds = new CMIntSet(16);
    private XML.RenderComparator sortOrder;
    private final IEventManager eventManager;
    private IInboxSource inboxSource = EmptyInbox.instance;
    private final Vector favourites = new Vector();
    private String welcome;
    private View view;
    private final CurrentView CURRENT_VIEW = new CurrentView();

    public VMInbox(IEventManager eventManager, VMOptions options) {
        this.view = this.CURRENT_VIEW;
        this.sortOrder = options != null ? options.getInboxSortOrder() : XML.RenderComparator.DATE_DESCENDING;
        if (eventManager == null) {
            throw new IllegalArgumentException("eventManager can't be null");
        }
        this.eventManager = eventManager;
        this.eventManager.addEventListener(this);
    }

    public void setInboxSource(IInboxSource inboxSource) {
        if (inboxSource == null) {
            throw new IllegalArgumentException("inboxSource can't be null");
        }
        this.inboxSource = inboxSource;
        this.inboxSource.setListener(this);
        if (wouldDebugLog) {
            VM.log(CLASS, 0, "set new inbox source " + this.inboxSource);
        }
        this.view.select(0);
        this.view.invalidate();
        this.eventManager.postEvent(new Event(this, 7, Boolean.TRUE));
    }

    public void dispose() throws CMException {
        this.inboxSource = EmptyInbox.instance;
    }

    public IInboxSource getInboxSource() {
        return this.inboxSource;
    }

    public void setWelcome(String sourcePath) {
        VM.log(CLASS, 1, "VMInbox.setWelcome: " + sourcePath);
        this.welcome = sourcePath == null || sourcePath.length() == 0 ? null : sourcePath;
        this.eventManager.postEvent(new Event(this, 17, this));
    }

    public void removeWelcome() {
        if (this.welcome == null) {
            return;
        }
        if (this.findItemFromSourcePath(this.welcome) == null) {
            return;
        }
        this.welcome = null;
        this.eventManager.postEvent(new Event(this, 17, this));
    }

    public InboxItem getWelcomeItem() {
        if (this.welcome == null) {
            return null;
        }
        return this.findItemFromSourcePath(this.welcome);
    }

    public void addFavourite(String sourcePath) {
        VM.log(CLASS, 1, "VMInbox.addFavourite: " + sourcePath);
        this.favourites.addElement(sourcePath);
        this.eventManager.postEvent(new Event(this, 16, this));
    }

    public void removeFavourite(String sourcePath) {
        this.favourites.removeElement(sourcePath);
        this.eventManager.postEvent(new Event(this, 16, this));
    }

    public void clearFavourites() {
        this.favourites.removeAllElements();
        this.eventManager.postEvent(new Event(this, 16, this));
    }

    public void setFavourites(String[] sourcePaths) {
        this.favourites.removeAllElements();
        if (sourcePaths != null && sourcePaths.length > 0) {
            for (int i = 0; i < sourcePaths.length; ++i) {
                this.favourites.addElement(sourcePaths[i]);
            }
        }
        this.eventManager.postEvent(new Event(this, 16, this));
    }

    public String[] getFavourites() {
        Object[] result = new String[this.favourites.size()];
        this.favourites.copyInto(result);
        return result;
    }

    public boolean isFavourite(InboxItem item) {
        return this.favourites.contains(item.getMetadata().sourcePath);
    }

    public boolean isFavourite(Render item) {
        return this.favourites.contains(item.sourcePath);
    }

    public boolean isFavourite(String sourcePath) {
        return this.favourites.contains(sourcePath);
    }

    public ISynchronizer getSynchronizer() {
        if (this.inboxSource instanceof ISynchronizer) {
            return (ISynchronizer)((Object)this.inboxSource);
        }
        return null;
    }

    public InboxItem[] getItems() {
        InboxItem[] list = this.view.getItems();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                int flags = 0;
                if (list[i].getMetadata() != null) {
                    flags |= 1;
                    if (this.openedRendersList.contains(list[i].getMetadata().renderID)) {
                        flags |= 2;
                    }
                    if (list[i].getMetadata().status == 99) {
                        flags |= 8;
                    }
                }
                list[i].setFlags(flags);
            }
        }
        return list;
    }

    public void setSelected(int index) {
        this.view.select(index);
    }

    public void setSelectedByID(int renderID) {
        InboxItem[] items = this.view.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i].getMetadata() == null || items[i].getMetadata().renderID != renderID) continue;
            this.setSelected(i);
            return;
        }
    }

    public int getSelected() {
        return this.view.getSelected();
    }

    public Render getSelectedRender() {
        InboxItem[] items = this.getItems();
        int index = this.view.getSelected();
        if (index >= 0 && index < items.length) {
            return items[index].getMetadata();
        }
        return null;
    }

    public VMRender getRenderByRenderID(int renderID, ITaskMonitor taskMonitor, boolean includeDeleted) throws CMException {
        return this.getRenderByRenderID(renderID, 0, taskMonitor, includeDeleted);
    }

    public boolean isDeletedRender(int renderID) {
        return this.deletedRenderIds.contains(renderID);
    }

    public VMRender getRenderByRenderID(int renderID, int pageIndex, ITaskMonitor taskMonitor, boolean includeDeleted) throws CMException {
        if (wouldDebugLog) {
            VM.log(CLASS, 0, "getting render ID: " + renderID + " page: " + pageIndex);
        }
        if (!includeDeleted && this.deletedRenderIds.contains(renderID)) {
            return null;
        }
        VMRender render = this.inboxSource.getRender(renderID, pageIndex, taskMonitor);
        if (wouldDebugLog) {
            VM.log(CLASS, 0, "got render");
        }
        return render;
    }

    public boolean checkIfRenderExists(int renderID, int pageIndex) {
        return this.inboxSource == null ? false : this.inboxSource.checkIfRenderExists(renderID, pageIndex);
    }

    public void markAllItemsAsOpened(boolean isOpen) {
        boolean changed = false;
        InboxItem[] items = this.view.getItems();
        for (int i = 0; i < items.length; ++i) {
            InboxItem item = items[i];
            if (item == null || item.getMetadata() == null) continue;
            int renderID = item.getMetadata().renderID;
            if (isOpen) {
                this.openedRendersList.add(renderID);
            } else {
                this.openedRendersList.remove(renderID);
            }
            changed = true;
        }
        if (this.view.getSelected() >= 0 && changed) {
            this.eventManager.postEvent(new Event(this, 12, items[this.view.getSelected()].getMetadata()));
        }
    }

    public void markRenderAsOpened(int renderID, boolean isOpen) {
        InboxItem item = this.findItemFromRenderID(renderID);
        if (item != null && item.getMetadata() != null) {
            if (isOpen) {
                this.openedRendersList.add(renderID);
            } else {
                this.openedRendersList.remove(renderID);
            }
            this.eventManager.postEvent(new Event(this, 12, item.getMetadata()));
        }
    }

    public InboxItem findItemFromSourcePath(String sourcePath) {
        VM.log(CLASS, 1, "VMInbox.findItemFromSourcePath: " + sourcePath);
        int[] renderIds = this.inboxSource.listRenders();
        VM.log(CLASS, 1, "VMInbox.findItemFromSourcePath: length: " + renderIds.length);
        for (int index = 0; index < renderIds.length; ++index) {
            Render meta = this.inboxSource.getMetadata(renderIds[index]);
            if (meta == null || !meta.sourcePath.equals(sourcePath)) continue;
            return new InboxItem(meta);
        }
        VM.log(CLASS, 1, "VMInbox.findItemFromSourcePath: done!");
        return null;
    }

    public InboxItem findItemFromRenderID(int renderID) {
        if (this.deletedRenderIds.contains(renderID)) {
            return null;
        }
        int[] renderIds = this.inboxSource.listRenders();
        for (int index = 0; index < renderIds.length; ++index) {
            if (renderIds[index] != renderID) continue;
            return new InboxItem(this.inboxSource.getMetadata(renderIds[index]));
        }
        return null;
    }

    public int getRequestedRenderStatus(int renderID) {
        return this.inboxSource.getRequestedRenderStatus(renderID);
    }

    public void clearRequestedRenderStatus() {
        this.inboxSource.clearRequestedRenderStatus();
    }

    public boolean hasUnopenedRenders() {
        int[] renderIds = this.inboxSource.listRenders();
        for (int i = 0; i < renderIds.length; ++i) {
            if (this.deletedRenderIds.contains(renderIds[i]) || this.openedRendersList.contains(renderIds[i])) continue;
            return true;
        }
        return false;
    }

    public int countUnopenedRenders() {
        int[] renderIds = this.inboxSource.listRenders();
        int j = 0;
        for (int i = 0; i < renderIds.length; ++i) {
            if (this.deletedRenderIds.contains(renderIds[i]) || this.openedRendersList.contains(renderIds[i])) continue;
            ++j;
        }
        return j;
    }

    public int getSize() {
        int[] r = this.inboxSource.listRenders();
        if (r.length == 0) {
            return 0;
        }
        int count = r.length;
        for (int j = 0; j < r.length; ++j) {
            if (!this.deletedRenderIds.contains(r[j])) continue;
            --count;
        }
        return count;
    }

    public int findRenderByStoreIDParams(String storeID, String params) {
        InboxItem[] _items = this.getOrderedInboxItems(null, storeID);
        for (int index = 0; index < _items.length; ++index) {
            InboxItem item = _items[index];
            Render meta = item.getMetadata();
            if (meta.storeID == null || meta.drillParamsStr == null || !meta.storeID.equals(storeID) || !meta.drillParamsStr.equals(params)) continue;
            return meta.renderID;
        }
        return -1;
    }

    public int findRenderByCMPathParams(String cmpath, String params) {
        InboxItem[] _items = this.getOrderedInboxItems(cmpath, null);
        for (int index = 0; index < _items.length; ++index) {
            InboxItem item = _items[index];
            Render meta = item.getMetadata();
            if (meta.cmPath == null || meta.drillParamsStr == null || !meta.cmPath.equals(cmpath) || !meta.drillParamsStr.equals(params)) continue;
            return meta.renderID;
        }
        return -1;
    }

    public InboxItem[] getOrderedInboxItems(String cmpath, String storeID) {
        int[] renderIds = this.inboxSource.listRenders();
        Vector<InboxItem> items = new Vector<InboxItem>();
        for (int i = 0; i < renderIds.length; ++i) {
            Render meta = this.inboxSource.getMetadata(renderIds[i]);
            if (meta == null || this.deletedRenderIds.contains(meta.renderID)) continue;
            boolean add = false;
            if (cmpath != null && meta.sourcePath != null && meta.cmPath != null) {
                if (meta.cmPath.equals(cmpath)) {
                    add = true;
                }
            } else if (storeID != null && meta.storeID != null) {
                if (meta.storeID.equals(storeID)) {
                    add = true;
                }
            } else {
                add = true;
            }
            if (!add) continue;
            items.addElement(new InboxItem(meta));
        }
        Object[] _items = new InboxItem[items.size()];
        items.copyInto(_items);
        Arrays.sort(_items, new VMInboxRenderComparator(XML.RenderComparator.DATE_DESCENDING));
        return _items;
    }

    public Render getRenderMetaByID(int renderID) {
        return this.inboxSource.getMetadata(renderID);
    }

    public int[] getAllRenders() {
        int[] allRenderIDs = this.inboxSource.listRenders();
        int newLength = 0;
        for (int i = 0; i < allRenderIDs.length; ++i) {
            if (this.deletedRenderIds.contains(allRenderIDs[i])) {
                allRenderIDs[i] = -1;
                continue;
            }
            ++newLength;
        }
        int[] nonDeletedRenderIDs = new int[newLength];
        int j = 0;
        for (int i = 0; i < allRenderIDs.length; ++i) {
            if (allRenderIDs[i] == -1) continue;
            nonDeletedRenderIDs[j++] = allRenderIDs[i];
        }
        return nonDeletedRenderIDs;
    }

    public void deleteRender(int renderID) {
        if (this.deletedRenderIds.add(renderID)) {
            this.view.invalidate();
            this.eventManager.postEvent(new Event(this, 7));
        }
    }

    public void deleteAllVersions(Render r) {
        int[] renderIDs = this.getAllVersions(r.sourcePath);
        this.deleteRenders(renderIDs);
    }

    public void deleteAll() {
        int[] r = this.inboxSource.listRenders();
        this.deleteRenders(r);
    }

    public void deleteRendersPriorToSelected(Render r) {
        InboxItem[] items = this.getItems();
        int start = this.getSelected() + 1;
        int limit = items.length;
        int[] tempIDs = new int[limit - start];
        int count = 0;
        for (int i = start; i < limit; ++i) {
            if (items[i].getMetadata() == null || items[i].getMetadata().sourcePath == null || !items[i].getMetadata().sourcePath.equals(r.sourcePath)) continue;
            tempIDs[count++] = items[i].getMetadata().renderID;
        }
        int[] renderIDs = new int[count];
        System.arraycopy(tempIDs, 0, renderIDs, 0, count);
        this.deleteRenders(renderIDs);
    }

    public void deleteRenders(int[] renderIDs) {
        boolean deletedAtLeastOne = false;
        for (int i = 0; i < renderIDs.length; ++i) {
            if (!this.deletedRenderIds.add(renderIDs[i])) continue;
            deletedAtLeastOne = true;
        }
        if (deletedAtLeastOne) {
            this.view.invalidate();
            this.eventManager.postEvent(new Event(this, 7));
        }
    }

    public int[] getAllVersions(String sourcePath) {
        int[] ids = this.inboxSource.listRenders();
        int count = 0;
        int[] tempIDs = new int[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            Render meta = this.inboxSource.getMetadata(ids[i]);
            if (meta == null || meta.sourcePath == null || !meta.sourcePath.equals(sourcePath) || this.deletedRenderIds.contains(meta.renderID)) continue;
            tempIDs[count++] = meta.renderID;
        }
        int[] renderIDs = new int[count];
        System.arraycopy(tempIDs, 0, renderIDs, 0, count);
        return renderIDs;
    }

    public int findUnopened(int start) {
        InboxItem[] items = this.getItems();
        if (start < 0) {
            start = 0;
        }
        for (int i = start; i <= items.length; ++i) {
            int flags = items[i].getFlags();
            if ((flags & 3) != 1) continue;
            return i;
        }
        return -1;
    }

    public void switchToCurrentView() {
        if (this.view != this.CURRENT_VIEW) {
            this.view = this.CURRENT_VIEW;
            this.view.invalidate();
            this.eventManager.postEvent(new Event(this, 7));
        }
    }

    public void setSortOrder(XML.RenderComparator newSortOrder) {
        if (newSortOrder == this.sortOrder) {
            return;
        }
        this.sortOrder = newSortOrder;
        this.view.invalidate();
        this.eventManager.postEvent(new Event(this, 7));
    }

    public InboxItem getWelcomeItem(VMOptions options) {
        InboxItem[] items;
        InboxItem dashboardItem = null;
        String dashboardIDStr = options.getSessionCookieProperty("dsh");
        int sessionDashboardID = 0;
        if (dashboardIDStr != null) {
            try {
                sessionDashboardID = Integer.valueOf(dashboardIDStr.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sessionDashboardID != 0 && (items = this.getItems()) != null) {
            for (int i = 0; i < items.length; ++i) {
                if ((items[i].getFlags() & 1) == 0 || items[i].getMetadata().renderID != sessionDashboardID) continue;
                dashboardItem = items[i];
                break;
            }
        }
        return dashboardItem;
    }

    @Override
    public void onEvent(IEvent event) {
        switch (event.getCode()) {
            case 11: {
                VMOptions options = (VMOptions)event.getArgument();
                this.setSortOrder(options.getInboxSortOrder());
            }
        }
    }

    @Override
    public void onSerializableSave(DataOutputStream out) throws IOException {
        VM.log(CLASS, 2, "Saving inbox - version: 2");
        out.writeByte(2);
        out.writeUTF(this.openedRendersList.getString());
        out.writeUTF(this.deletedRenderIds.toString());
        out.writeUTF(CMStringHelper.join(this.getFavourites(), "\n"));
        out.writeUTF(this.welcome == null ? "" : this.welcome);
    }

    @Override
    public void onSerializableLoad(DataInputStream in) throws IOException {
        this.clearFavourites();
        this.removeWelcome();
        byte version = in.readByte();
        VM.log(CLASS, 2, "Loading inbox - version: " + version);
        switch (version) {
            case 2: {
                this.readVersion2(in);
                break;
            }
            case 1: {
                this.readVersion1(in);
                break;
            }
            case 0: {
                this.readVersion0(in);
                break;
            }
            default: {
                VM.log(CLASS, 3, "invalid or unsupported version: " + version);
                throw new IOException("invalid version");
            }
        }
    }

    private void readVersion2(DataInputStream in) throws IOException {
        this.readVersion1(in);
        String favs = in.readUTF();
        String welcome = in.readUTF();
        VM.log(CLASS, 3, "VMInbox.readVersion2: setting favs: " + favs + " welcome: " + welcome);
        this.setFavourites(CMStringHelper.split(favs, '\n', false));
        this.setWelcome(welcome);
    }

    private void readVersion1(DataInputStream in) throws IOException {
        this.readVersion0(in);
        this.deletedRenderIds = CMIntSet.fromString(in.readUTF());
    }

    private void readVersion0(DataInputStream in) throws IOException {
        try {
            this.openedRendersList.parseString(in.readUTF());
        }
        catch (NumberFormatException ex) {
            VM.log(CLASS, 3, "invalid renders list", ex);
            throw new IOException("invalid open renders list");
        }
    }

    @Override
    public void modify(IServerRequest request) throws CMException {
        if (this.deletedRenderIds.getCount() > 0) {
            request.setArgument(CMUrlConstants.PARAM_DELETED_IDS[0], this.deletedRenderIds.toString());
        }
    }

    @Override
    public void inboxChanged(boolean includesNewRenders) {
        this.view.invalidate();
        this.eventManager.postEvent(new Event(this, 7, includesNewRenders ? Boolean.TRUE : Boolean.FALSE));
    }

    @Override
    public void inboxIsAccurate() {
        int i;
        if (wouldDebugLog) {
            VM.log(CLASS, 0, "updating deleted render IDs; current list is '" + this.deletedRenderIds.toString() + "'");
        }
        int[] renderIDs = this.inboxSource.listRenders();
        CMIntSet copyOfDeletedRendersIDs = new CMIntSet(this.deletedRenderIds);
        for (i = 0; i < renderIDs.length; ++i) {
            copyOfDeletedRendersIDs.remove(renderIDs[i]);
        }
        for (i = 0; i < copyOfDeletedRendersIDs.getCount(); ++i) {
            if (wouldDebugLog) {
                VM.log(CLASS, 0, "removing render ID " + copyOfDeletedRendersIDs.get(i) + " from soft list b/c it's no longer present in the inbox source");
            }
            this.deletedRenderIds.remove(copyOfDeletedRendersIDs.get(i));
        }
    }

    private static class VMInboxRenderComparator
    implements Comparator {
        private final Comparator xmlRenderComparator;

        public VMInboxRenderComparator(Comparator xmlRenderComparator) {
            this.xmlRenderComparator = xmlRenderComparator;
        }

        public Comparator getWrappedComparator() {
            return this.xmlRenderComparator;
        }

        public int compare(Object lhsO, Object rhsO) {
            if (lhsO instanceof InboxItem && rhsO instanceof InboxItem) {
                InboxItem lhs = (InboxItem)lhsO;
                InboxItem rhs = (InboxItem)rhsO;
                if (lhs.getMetadata() != null && rhs.getMetadata() != null) {
                    return this.xmlRenderComparator.compare(lhs.getMetadata(), rhs.getMetadata());
                }
            }
            return 0;
        }
    }

    private class CurrentView
    extends View {
        public CurrentView() {
            super(VMInbox.this);
        }

        @Override
        protected InboxItem[] buildItemList() {
            Hashtable<String, Render> items = new Hashtable<String, Render>();
            int[] renderIds = VMInbox.this.inboxSource.listRenders();
            for (int i = 0; i < renderIds.length; ++i) {
                Render latestRender;
                int sourceType;
                Render meta = VMInbox.this.inboxSource.getMetadata(renderIds[i]);
                if (meta == null || meta.storeID == null || VMInbox.this.deletedRenderIds.contains(meta.renderID) || (sourceType = meta.sourceCode & 0xF) == 2 || sourceType == 3 || (latestRender = (Render)items.get(meta.storeID + meta.burstValue)) != null && XML.RenderComparator.DATE_DESCENDING.compare(latestRender, meta) <= 0) continue;
                items.put(meta.storeID + meta.burstValue, meta);
            }
            InboxItem[] _items = new InboxItem[items.size()];
            int i = 0;
            Enumeration e = items.keys();
            while (e.hasMoreElements()) {
                Render meta = (Render)items.get((String)e.nextElement());
                _items[i++] = new InboxItem(meta);
            }
            return _items;
        }
    }

    private static abstract class View {
        private InboxItem[] items = null;
        private int selectedIndex = -1;
        protected VMInbox inbox;
        private int previouslySelectedRenderID = -1;

        public View(VMInbox inbox) {
            this.inbox = inbox;
        }

        public final void select(int i) {
            this.ensureItemListIsBuilt();
            if (i >= 0 && i < this.size()) {
                this.selectedIndex = i;
            }
        }

        public final int getSelected() {
            return this.selectedIndex;
        }

        public final InboxItem[] getItems() {
            this.ensureItemListIsBuilt();
            return this.items;
        }

        public final int size() {
            this.ensureItemListIsBuilt();
            return this.items.length;
        }

        public final void invalidate() {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.items.length) {
                this.previouslySelectedRenderID = this.items[this.selectedIndex].getMetadata().renderID;
            }
            this.items = null;
            this.selectedIndex = -1;
        }

        private final void ensureItemListIsBuilt() {
            if (this.items == null) {
                this.items = this.buildItemList();
                if (this.inbox == null || this.items == null) {
                    VM.log(CLASS, 3, "internal error; inbox is null (" + (this.inbox == null) + "); items is null (" + (this.items == null) + ")");
                } else {
                    if (this.inbox.sortOrder != null) {
                        Arrays.sort(this.items, new VMInboxRenderComparator(this.inbox.sortOrder));
                    }
                    if (this.previouslySelectedRenderID != -1) {
                        for (int i = 0; i < this.items.length; ++i) {
                            if (this.items[i] == null || this.items[i].getMetadata() == null || this.items[i].getMetadata().renderID != this.previouslySelectedRenderID) continue;
                            this.selectedIndex = i;
                            this.previouslySelectedRenderID = -1;
                            break;
                        }
                    }
                }
            }
        }

        protected abstract InboxItem[] buildItemList();
    }
}

