/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMVectorHelper;
import com.cognos.mobile.vm.IVMReader;
import com.cognos.mobile.vm.IVMWriter;
import com.cognos.mobile.vm.PlatformIndependentReader;
import com.cognos.mobile.vm.PlatformIndependentWriter;
import com.cognos.mobile.vm.VM;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

public class VMMemDatabase
implements IVMReader,
IVMWriter {
    private static Class CLASS = VMMemDatabase.class;
    private static final int MAGIC = 57040;
    private static final int VERSION = 1;
    private Vector codeRecords = new Vector();
    private Vector stringRecords = new Vector();
    private Vector blobRecords = new Vector();
    private int m_reportSize;
    private int m_smallThumbnailIndex;
    private int m_dashboardIndex;
    private Hashtable m_blobCache = null;
    private Hashtable m_tmpCache = null;

    public static VMMemDatabase fromReader(IVMReader reader) throws CMException {
        IVMReader.CodeRecord code;
        VMMemDatabase db = new VMMemDatabase();
        for (int address = reader.onReaderOpen(); address >= 0 && reader.onReaderLoadCode(address, code = new IVMReader.CodeRecord()); ++address) {
            CMVectorHelper.growBeforeAppend(db.codeRecords);
            db.codeRecords.addElement(code);
            if (code.opcode == 0) break;
        }
        int stringID = 0;
        while (true) {
            IVMReader.StringRecord rec = new IVMReader.StringRecord();
            rec.id = ++stringID;
            try {
                rec.string = reader.onReaderLoadString(stringID);
                if (rec.string == null) {
                }
            }
            catch (CMException ignored) {}
            break;
            if (rec.id != db.stringRecords.size()) {
                throw new CMException(1207, "bad string order at string #" + rec.id);
            }
            CMVectorHelper.growBeforeAppend(db.stringRecords);
            db.stringRecords.addElement(rec);
        }
        int blobID = 0;
        while (true) {
            IVMReader.BlobRecord rec = new IVMReader.BlobRecord();
            rec.id = ++blobID;
            try {
                rec.blob = reader.onReaderLoadBlob(blobID);
                if (rec.blob == null) {
                }
            }
            catch (CMException ignored) {}
            break;
            if (rec.id != db.blobRecords.size()) {
                throw new CMException(1207, "bad blob order at blob #" + rec.id);
            }
            CMVectorHelper.growBeforeAppend(db.blobRecords);
            db.blobRecords.addElement(rec);
        }
        reader.onReaderClose();
        if (db.numCodeRecords() == 0 && db.numBlobRecords() == 1) {
            byte[] blobArray = db.getBlob(0);
            ByteArrayInputStream bais = new ByteArrayInputStream(blobArray);
            db = VMMemDatabase.fromInputStream(bais);
        }
        VM.log(CLASS, 1, "loaded: code records=" + Integer.toString(db.codeRecords.size()) + ", string records=" + Integer.toString(db.stringRecords.size()) + ", blob records=" + Integer.toString(db.blobRecords.size()));
        return db;
    }

    public static VMMemDatabase fromInputStream(InputStream inputStream) throws CMException {
        try {
            Object rec;
            int i;
            PlatformIndependentReader in = new PlatformIndependentReader(inputStream);
            VMMemDatabase db = new VMMemDatabase();
            int n = in.readInt();
            if (n != 57040) {
                throw new CMException(1207, "invalid demo file");
            }
            n = in.readInt();
            switch (n) {
                case 1: {
                    break;
                }
                default: {
                    throw new CMException(1207, "unsupported demo version: " + n);
                }
            }
            n = in.readInt();
            if (n < 0) {
                throw new CMException(1207, "illegal code record count: " + n);
            }
            db.codeRecords.setSize(n);
            for (i = 0; i < db.codeRecords.size(); ++i) {
                rec = new IVMReader.CodeRecord();
                ((IVMReader.CodeRecord)rec).address = i;
                ((IVMReader.CodeRecord)rec).opcode = in.readInt();
                ((IVMReader.CodeRecord)rec).p1 = in.readInt();
                ((IVMReader.CodeRecord)rec).p2 = in.readInt();
                db.codeRecords.setElementAt(rec, i);
            }
            n = in.readInt();
            if (n < 0) {
                throw new CMException(1207, "illegal string record count: " + n);
            }
            db.stringRecords.setSize(n);
            for (i = 0; i < db.stringRecords.size(); ++i) {
                rec = new IVMReader.StringRecord();
                ((IVMReader.StringRecord)rec).id = in.readInt();
                ((IVMReader.StringRecord)rec).string = in.readString();
                if (((IVMReader.StringRecord)rec).id != i) {
                    throw new CMException(1207, "bad string order at string #" + i);
                }
                db.stringRecords.setElementAt(rec, i);
            }
            n = in.readInt();
            if (n < 0) {
                throw new CMException(1207, "illegal blob record count: " + n);
            }
            db.blobRecords.setSize(n);
            for (i = 0; i < db.blobRecords.size(); ++i) {
                rec = new IVMReader.BlobRecord();
                ((IVMReader.BlobRecord)rec).id = in.readInt();
                int length = in.readInt();
                ((IVMReader.BlobRecord)rec).blob = new byte[length];
                in.readBytes(((IVMReader.BlobRecord)rec).blob, 0, length);
                if (((IVMReader.BlobRecord)rec).id != i) {
                    throw new CMException(1207, "bad blob order at string #" + i);
                }
                db.blobRecords.setElementAt(rec, i);
            }
            VM.log(CLASS, 1, "loaded: code records=" + Integer.toString(db.codeRecords.size()) + ", string records=" + Integer.toString(db.stringRecords.size()) + ", blob records=" + Integer.toString(db.blobRecords.size()));
            return db;
        }
        catch (IOException ex) {
            VM.log(CLASS, 3, ex);
            throw new CMException(1207, (Throwable)ex);
        }
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        Object rec;
        int i;
        PlatformIndependentWriter out = new PlatformIndependentWriter(outputStream);
        out.write(57040);
        out.write(1);
        out.write(this.codeRecords.size());
        for (i = 0; i < this.codeRecords.size(); ++i) {
            rec = (IVMReader.CodeRecord)this.codeRecords.elementAt(i);
            out.write(((IVMReader.CodeRecord)rec).opcode);
            out.write(((IVMReader.CodeRecord)rec).p1);
            out.write(((IVMReader.CodeRecord)rec).p2);
        }
        out.write(this.stringRecords.size());
        for (i = 0; i < this.stringRecords.size(); ++i) {
            rec = (IVMReader.StringRecord)this.stringRecords.elementAt(i);
            out.write(((IVMReader.StringRecord)rec).id);
            out.write(((IVMReader.StringRecord)rec).string);
        }
        out.write(this.blobRecords.size());
        for (i = 0; i < this.blobRecords.size(); ++i) {
            rec = (IVMReader.BlobRecord)this.blobRecords.elementAt(i);
            out.write(((IVMReader.BlobRecord)rec).id);
            out.write(((IVMReader.BlobRecord)rec).blob.length);
            out.write(((IVMReader.BlobRecord)rec).blob);
        }
    }

    public int numCodeRecords() {
        return this.codeRecords.size();
    }

    public int numStringRecords() {
        return this.stringRecords.size();
    }

    public int numBlobRecords() {
        return this.blobRecords.size();
    }

    public byte[] getBlob(int index) {
        IVMReader.BlobRecord br = (IVMReader.BlobRecord)this.blobRecords.elementAt(index);
        if (br != null) {
            return br.blob;
        }
        return null;
    }

    @Override
    public int onReaderOpen() throws CMException {
        return 0;
    }

    @Override
    public void onReaderClose() throws CMException {
    }

    @Override
    public boolean onReaderLoadCode(int address, IVMReader.CodeRecord code) throws CMException {
        if (address < 0 || address >= this.codeRecords.size()) {
            return false;
        }
        IVMReader.CodeRecord load = (IVMReader.CodeRecord)this.codeRecords.elementAt(address);
        code.copy(load);
        return true;
    }

    @Override
    public String onReaderLoadString(int stringID) throws CMException {
        IVMReader.StringRecord rec;
        if (stringID >= 0 && stringID < this.stringRecords.size()) {
            rec = (IVMReader.StringRecord)this.stringRecords.elementAt(stringID);
            if (rec.id == stringID) {
                return rec.string;
            }
        }
        for (int i = 0; i < this.stringRecords.size(); ++i) {
            rec = (IVMReader.StringRecord)this.stringRecords.elementAt(i);
            if (rec.id != stringID) continue;
            return rec.string;
        }
        throw new CMException(1200, "bad string ID: " + stringID);
    }

    @Override
    public byte[] onReaderLoadBlob(int blobID) throws CMException {
        try {
            IVMReader.BlobRecord rec;
            if (blobID >= 0 && blobID < this.blobRecords.size()) {
                rec = (IVMReader.BlobRecord)this.blobRecords.elementAt(blobID);
                if (rec.id == blobID) {
                    return rec.blob;
                }
            }
            for (int i = 0; i < this.blobRecords.size(); ++i) {
                rec = (IVMReader.BlobRecord)this.blobRecords.elementAt(i);
                if (rec.id != blobID) continue;
                return rec.blob;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new CMException(1200, "bad blob ID: " + blobID);
    }

    @Override
    public int onWriterOpen() throws CMException {
        this.codeRecords = new Vector();
        this.stringRecords = new Vector();
        this.blobRecords = new Vector();
        this.m_reportSize = 0;
        return 0;
    }

    @Override
    public void onWriterClose() throws CMException {
    }

    public int onWriterGetCodeAddress() {
        return this.codeRecords.size();
    }

    @Override
    public int onWriterWriteCode(int opcode, int p1, int p2) throws CMException {
        IVMReader.CodeRecord codeRecord = new IVMReader.CodeRecord();
        codeRecord.address = this.codeRecords.size();
        codeRecord.opcode = opcode;
        codeRecord.p1 = p1;
        codeRecord.p2 = p2;
        CMVectorHelper.growBeforeAppend(this.codeRecords);
        this.codeRecords.addElement(codeRecord);
        if (opcode == 4) {
            if (p1 == 18) {
                this.m_smallThumbnailIndex = this.codeRecords.size() - 1;
            } else if (p1 == 19) {
                this.m_dashboardIndex = this.codeRecords.size() - 1;
            }
        }
        this.m_reportSize += 3;
        return this.codeRecords.size();
    }

    @Override
    public int onWriterWriteString(String literal) throws CMException {
        IVMReader.StringRecord stringRecord = new IVMReader.StringRecord();
        stringRecord.id = this.stringRecords.size();
        stringRecord.string = literal;
        CMVectorHelper.growBeforeAppend(this.stringRecords);
        this.stringRecords.addElement(stringRecord);
        ++this.m_reportSize;
        this.m_reportSize += literal.length();
        return stringRecord.id;
    }

    @Override
    public int onWriterWriteBlob(byte[] bytes, int format) throws CMException {
        int blobID = this.onWriterWriteBlob(bytes, null, format, -1, -1, -1, -1);
        return blobID;
    }

    @Override
    public int onWriterWriteBlob(byte[] bytes, String location, int format, int height, int width, int objectIndex, int page) throws CMException {
        IVMReader.BlobRecord blobRecord = new IVMReader.BlobRecord();
        blobRecord.id = this.blobRecords.size();
        blobRecord.blob = bytes;
        CMVectorHelper.growBeforeAppend(this.blobRecords);
        this.blobRecords.addElement(blobRecord);
        ++this.m_reportSize;
        this.m_reportSize += bytes.length;
        if (format == 6) {
            this.setSmallThumbnail(blobRecord.id);
        } else if (format == 14) {
            this.setDashboard(blobRecord.id);
        }
        return blobRecord.id;
    }

    @Override
    public int getSize() {
        return this.m_reportSize;
    }

    private void setSmallThumbnail(int blobID) {
        IVMReader.CodeRecord record = (IVMReader.CodeRecord)this.codeRecords.elementAt(this.m_smallThumbnailIndex);
        record.p2 = blobID;
        this.codeRecords.setElementAt(record, this.m_smallThumbnailIndex);
    }

    private void setDashboard(int dashboard) {
        IVMReader.CodeRecord record = (IVMReader.CodeRecord)this.codeRecords.elementAt(this.m_dashboardIndex);
        record.p2 = dashboard;
        this.codeRecords.setElementAt(record, this.m_dashboardIndex);
    }

    public void setPageCount(int pageCount) {
        for (int i = 0; i < this.codeRecords.size(); ++i) {
            IVMReader.CodeRecord record = (IVMReader.CodeRecord)this.codeRecords.elementAt(i);
            if (record.opcode != 4 || record.p1 != 4) continue;
            record.p2 = pageCount;
            this.codeRecords.setElementAt(record, i);
            break;
        }
    }

    @Override
    public Hashtable getBlobCache() {
        if (this.m_blobCache == null) {
            this.m_blobCache = new Hashtable();
        }
        return this.m_blobCache;
    }

    @Override
    public Hashtable getTempCache() {
        if (this.m_tmpCache == null) {
            this.m_tmpCache = new Hashtable();
        }
        return this.m_tmpCache;
    }

    @Override
    public boolean isShinkImages() {
        return true;
    }

    public void print(PrintStream out, IVMReader.Formatter formatter) {
        Object rec;
        int i;
        out.println();
        out.println("Code Table");
        out.println("----------");
        for (i = 0; i < this.codeRecords.size(); ++i) {
            rec = (IVMReader.CodeRecord)this.codeRecords.elementAt(i);
            out.println(formatter.format((IVMReader.CodeRecord)rec));
        }
        out.println();
        out.println("String Table");
        out.println("------------");
        for (i = 0; i < this.stringRecords.size(); ++i) {
            rec = (IVMReader.StringRecord)this.stringRecords.elementAt(i);
            out.println(formatter.format((IVMReader.StringRecord)rec));
        }
        out.println();
        out.println("Blob Table");
        out.println("----------");
        for (i = 0; i < this.blobRecords.size(); ++i) {
            rec = (IVMReader.BlobRecord)this.blobRecords.elementAt(i);
            out.println(formatter.format((IVMReader.BlobRecord)rec));
        }
    }

    @Override
    public void dispose() {
        this.blobRecords.removeAllElements();
        this.codeRecords.removeAllElements();
        this.stringRecords.removeAllElements();
        this.blobRecords = null;
        this.codeRecords = null;
        this.stringRecords = null;
    }
}

