/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.client.IOptionsListener;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.CMMRUCache;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.ICMCache;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.event.IEvent;
import com.cognos.mobile.event.IEventListener;
import com.cognos.mobile.event.IEventManager;
import com.cognos.mobile.model.data.About;
import com.cognos.mobile.request.URI;
import com.cognos.mobile.vm.AuthenticationState;
import com.cognos.mobile.vm.ISerializer;
import com.cognos.mobile.vm.IVMSerializable;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XML;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class VMOptions
implements IVMSerializable,
IEventListener {
    public static final String CAM_NAMESPACE = "CAMNamespace";
    public static final String CAM_USERNAME = "CAMUsername";
    public static final String CAM_PASSWORD = "CAMPassword";
    public static final String CREDENTIAL_DOMAIN = "d";
    public static final String CREDENTIAL_USERNAME = "u";
    public static final String CREDENTIAL_PASSWORD = "p";
    public static final String SIGNATURE_HTTP_BASIC = "HTTP-BASIC";
    public static final String SIGNATURE_HTTP_NTLM = "HTTP-NTLM";
    public static final int KEEP_FOREVER = 0;
    public static final int AUTH_STATE_NOT_AUTHENTICATED = 0;
    public static final int AUTH_STATE_ANONYMOUS = 1;
    public static final int AUTH_STATE_AUTHENTICATED = 2;
    public static final int AUTH_STATE_DEMO = 3;
    public static final String REPORT_URL_PREFIX = "?b_action=xts.run&m=portal/launch.xts&ui.tool=CognosViewer&ui.action=run&ui.object=";
    public static String SERIALIZED_NAME = "IBM Cognos Mobile.opt";
    public static final int LOCATION_USE_NEVER = 0;
    public static final int LOCATION_ASK = 1;
    public static final int LOCATION_USE_ALWAYS = 2;
    public static final int GPS_ALWAYS_ON_NEVER = 0;
    public static final int GPS_ALWAYS_ON_ASK = 1;
    public static final int GPS_ALWAYS_ON_ALWAYS = 2;
    public static final int CACHE_ENCRYPTION_UNENCRYPTED = 0;
    public static final int CACHE_ENCRYPTION_ENCRYPTED = 1;
    private static Class CLASS = VMOptions.class;
    private static final int CURRENT_VERSION = 29;
    public static final int ZERO_INT = 0;
    public static final long ZERO_LONG = 0L;
    private final ISerializer serializer;
    private final IResourceManager resourceManager;
    private Hashtable cookies = new Hashtable();
    private ICMCache urlCache = new CMMRUCache(5);
    private long timeOffset = 0L;
    private int fontSize;
    private int pageInitialZoom;
    private int textInitialZoom;
    private int imageInitialZoom;
    private int keep;
    private String forceLocale;
    private int minSeverity = 3;
    private String serverUrl;
    private URI effectiveServerUrl = null;
    private String emailSubject;
    private String emailMessage;
    private String httpLogAddress;
    private XML.RenderComparator sortOrder = XML.RenderComparator.DATE_DESCENDING;
    private String preferredSyncMethod;
    private About about;
    private IOptionsListener optionsListener;
    private boolean demo = false;
    private String demoInboxName = null;
    private boolean enableHotGPS = false;
    private int useLocation = 1;
    private int gpsAlwaysOn = 1;
    private int blackBerryMaxMessageSizeBytes;
    private String platformID;
    private int cacheEncryption = 0;
    private final AuthenticationState authState;

    public VMOptions(IEventManager eventManager, IResourceManager resourceManager, ISerializer serializer, String defaultSyncMethod) {
        if (eventManager == null || serializer == null) {
            throw new IllegalArgumentException("eventManager, serializer, name can't be null");
        }
        this.serializer = serializer;
        this.resourceManager = resourceManager;
        this.authState = new AuthenticationState(this, eventManager);
        eventManager.addEventListener(this);
        this.setMinSeverity(3);
        this.setEmailSubject("");
        this.setEmailMessage("");
        this.setFontSize(-1);
        this.setPageInitialZoom(-1);
        this.setTextInitialZoom(100);
        this.setImageInitialZoom(100);
        this.setKeep(30);
        this.preferredSyncMethod = defaultSyncMethod;
    }

    public void setPlatform(String platform) {
        this.platformID = platform;
    }

    public String getPlatform() {
        return this.platformID;
    }

    public void setOptionsListener(IOptionsListener optionsListener) {
        this.optionsListener = optionsListener;
    }

    public void ensureValid() throws CMException {
        this.setFontSize(Math.max(1, this.getFontSize()));
        this.setPageInitialZoom(Math.min(300, this.getPageInitialZoom()));
        this.setTextInitialZoom(Math.min(300, this.getTextInitialZoom()));
        this.setImageInitialZoom(Math.min(300, this.getImageInitialZoom()));
    }

    public Hashtable getCredentials(String signature, boolean respectCacheDuration) {
        return this.authState.getCredentials(signature, respectCacheDuration);
    }

    public void setCredentials(String signature, Hashtable credentials) {
        this.authState.setCredentials(signature, credentials);
    }

    public String getCookiesHeader() {
        StringBuffer cookiesBuilder = new StringBuffer();
        Enumeration e = this.cookies.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.cookies.get(key);
            cookiesBuilder.append(key + "=");
            if (value == null) continue;
            cookiesBuilder.append(value + ";");
        }
        cookiesBuilder.append(this.authState.getCookiesHeader());
        if (cookiesBuilder.length() == 0) {
            return null;
        }
        return cookiesBuilder.toString();
    }

    public String getSessionCookieProperty(String property) {
        return this.authState.getSessionCookieProperty(property);
    }

    public void setSessionCookieProperty(String property, String value) {
        this.authState.setSessionCookieProperty(property, value);
    }

    public void setCookie(String name, String value) {
        if (name.equals("mob_session")) {
            this.authState.setSessionCookie(value);
        } else {
            if (name.equals("cam_passport")) {
                this.authState.setPassport(value);
            }
            if (value == null || value.length() == 0 || value.equals("\"\"")) {
                this.cookies.remove(name);
            } else {
                this.cookies.put(name, value);
            }
        }
    }

    public void clearServerState() {
        this.authState.clear();
        this.cookies.clear();
        this.effectiveServerUrl = null;
    }

    public int getAuthenticationState() {
        return this.authState.getAuthenticationState();
    }

    public String getUserName() {
        if (this.demo) {
            if (this.demoInboxName != null) {
                return this.demoInboxName;
            }
            return this.resourceManager == null ? "inbox-user-demo" : this.resourceManager.loadString(CMIDs.INBOX_USER_DEMO);
        }
        return this.authState.getUserName();
    }

    public String getUserID() {
        if (this.demo) {
            if (this.demoInboxName != null) {
                return this.demoInboxName;
            }
            return this.resourceManager == null ? "inbox-user-demo" : this.resourceManager.loadString(CMIDs.INBOX_USER_DEMO);
        }
        return this.authState.getUserID();
    }

    public String getDisplayName() {
        if (this.demo) {
            if (this.demoInboxName != null) {
                return this.demoInboxName;
            }
            return this.resourceManager == null ? "inbox-user-demo" : this.resourceManager.loadString(CMIDs.INBOX_USER_DEMO);
        }
        return this.authState.getDisplayName();
    }

    public String getPreferredSyncMethod() {
        return "2";
    }

    public void setMinSeverity(int minSeverity) {
        this.minSeverity = minSeverity;
    }

    public int getMinSeverity() {
        return this.minSeverity;
    }

    public void setDemoMode(boolean demoMode, String demoInboxName) {
        this.authState.setDemoMode(demoMode);
        this.demo = demoMode;
        this.demoInboxName = demoInboxName;
    }

    public void setServerUrl(String newServerUrl, boolean logoffIfChanged) throws CMException {
        if (CMStringHelper.compareStrings(this.serverUrl, newServerUrl) != 0) {
            URI incoming = VMOptions.buildServerUrl(newServerUrl);
            if (!VMOptions.serverUrlLooksOk(incoming)) {
                throw new CMException(2000, this.resourceManager.loadString(CMIDs.SERVER_ENTER_URL));
            }
            this.serverUrl = newServerUrl;
            this.effectiveServerUrl = incoming;
            if (this.serverUrl != null && this.serverUrl.length() != 0) {
                this.urlCache.put(this.serverUrl, this.serverUrl);
            }
            if (logoffIfChanged) {
                this.authState.clear();
                this.cookies.clear();
                if (this.optionsListener == null) {
                    throw new CMException(2000, "OptionsListener not set!");
                }
                this.optionsListener.serverChanged();
                VM.log(CLASS, 0, "server URL changed; cleared all state");
            } else {
                VM.log(CLASS, 0, "server URL changed; instructed not to clear state");
            }
        } else {
            VM.log(CLASS, 0, "server URL didn't change");
        }
    }

    public URI effectiveServerUrlFollowRedirect(String redirect) throws CMException {
        URI redirectUri = URI.parseURI(redirect, false);
        this.getEffectiveServerUri();
        this.effectiveServerUrl.followRedirect(redirectUri);
        redirectUri = this.effectiveServerUrl.copy();
        this.effectiveServerUrl.setQuery(null);
        return redirectUri;
    }

    public String getHelpUrl(String locale) throws CMException {
        String l;
        URI help;
        String prefix = "";
        if (this.effectiveServerUrl == null) {
            help = URI.parseURI(this.serverUrl, false);
            if (this.serverUrl.indexOf("cognos.cgi") > -1 || this.serverUrl.indexOf("cognosisapi.dll") > -1) {
                prefix = "../";
            }
        } else {
            help = this.effectiveServerUrl.copy();
            prefix = "../";
        }
        String string = l = locale == null ? "en" : locale;
        if (l.equals("pt")) {
            l = "pt-br";
        }
        help.followRedirect(URI.parseURI(prefix + "documentation/" + l + "/mobile_index.html", false));
        return help.toString();
    }

    private static URI buildServerUrl(String guess) throws CMException {
        if (guess == null || guess.length() == 0) {
            return null;
        }
        URI uri = URI.parseURI(guess, false);
        if (uri == null) {
            throw new CMException(1006, new String[]{guess});
        }
        String scheme = uri.getScheme();
        if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            throw new CMException(1011, scheme);
        }
        return uri;
    }

    public static final boolean serverUrlLooksOk(String u) {
        if (u == null || u.length() == 0) {
            return false;
        }
        try {
            return VMOptions.serverUrlLooksOk(URI.parseURI(u, false));
        }
        catch (CMException e) {
            return false;
        }
    }

    public static final boolean serverUrlLooksOk(URI uri) {
        if (uri == null) {
            return false;
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            return false;
        }
        if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            return false;
        }
        String path = uri.getPath();
        return path != null && path.length() > 1;
    }

    public boolean serverUrlLooksOK() {
        return VMOptions.serverUrlLooksOk(this.serverUrl);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public URI getEffectiveServerUri() throws CMException {
        if (this.effectiveServerUrl == null) {
            this.effectiveServerUrl = URI.parseURI(this.serverUrl, false);
        }
        return this.effectiveServerUrl;
    }

    public void clearEffectiveServerUrl() throws CMException {
        this.effectiveServerUrl = VMOptions.buildServerUrl(this.serverUrl);
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailMessage(String emailMessage) {
        this.emailMessage = emailMessage;
    }

    public String getEmailMessage() {
        return this.emailMessage;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setPageInitialZoom(int zoom) {
        this.pageInitialZoom = zoom;
    }

    public int getPageInitialZoom() {
        return this.pageInitialZoom;
    }

    public void setTextInitialZoom(int zoom) {
        this.textInitialZoom = zoom;
    }

    public int getTextInitialZoom() {
        return this.textInitialZoom;
    }

    public void setImageInitialZoom(int zoom) {
        this.imageInitialZoom = zoom;
    }

    public int getImageInitialZoom() {
        return this.imageInitialZoom;
    }

    public void setKeep(int keep) {
        this.keep = keep;
    }

    public int getKeep() {
        return this.keep;
    }

    public void setForceLocale(String forceLocale) {
        this.forceLocale = forceLocale;
    }

    public String getForceLocale() {
        return this.forceLocale;
    }

    public int getLeaseDurationSeconds() {
        return this.authState.getLeaseDuration();
    }

    public long getLeaseStartTimeMillis() {
        return this.authState.getLeaseStart();
    }

    public void setLeaseStartTimeMillis(long lstm) {
        this.authState.setLeaseStart(lstm);
    }

    public void setHttpLogAddress(String address) {
        this.httpLogAddress = address;
    }

    public String getHttpLogAddress() {
        return this.httpLogAddress;
    }

    public XML.RenderComparator getInboxSortOrder() {
        return this.sortOrder;
    }

    public void setInboxSortOrder(XML.RenderComparator sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getUseLocation() {
        return this.useLocation;
    }

    public void setUseLocation(int useLocation) {
        this.useLocation = useLocation;
    }

    public int getGPSAlwaysOn() {
        return this.gpsAlwaysOn;
    }

    public void setGPSAlwaysOn(int gpsAlwaysOn) {
        this.gpsAlwaysOn = gpsAlwaysOn;
    }

    public boolean isHotGPSEnabled() {
        return this.enableHotGPS;
    }

    public void setHotGPSEnable(boolean enableHotGPS) {
        this.enableHotGPS = enableHotGPS;
    }

    public void save() throws CMException {
        VM.log(CLASS, 1, "saving options...");
        try {
            this.serializer.save(this, SERIALIZED_NAME);
        }
        catch (Throwable ex) {
            String message = "failed to save options: " + ex.toString();
            VM.log(CLASS, 3, message);
            throw new CMException(1208, message);
        }
    }

    public void dump(StringBuffer sb) {
        this.authState.dump(sb);
        sb.append("FS " + this.fontSize + "; PIZ " + this.pageInitialZoom + "; TIZ " + this.textInitialZoom + "; IIZ " + this.imageInitialZoom + "\n");
        sb.append("FL " + this.forceLocale + "; MS " + this.minSeverity + "; PSM " + this.preferredSyncMethod + "\n");
        sb.append("UL " + this.useLocation + "; GPS " + this.gpsAlwaysOn + "; BBMMS " + this.blackBerryMaxMessageSizeBytes + "b; PID " + this.platformID + "; CE " + this.cacheEncryption + "\n");
        sb.append("SU '" + this.serverUrl + "'\n");
        if (this.effectiveServerUrl != null) {
            sb.append("ESU '" + this.effectiveServerUrl.toString() + "'\n");
        }
        if (this.about != null) {
            sb.append("Server is " + this.about.product + " " + this.about.versionMajor + "." + this.about.versionMinor + "." + this.about.versionBuild + "\n");
        }
    }

    @Override
    public void onEvent(IEvent event) {
        switch (event.getCode()) {
            case 8: {
                String strSrvTime;
                IConfiguration serverSettings = (IConfiguration)event.getArgument();
                if (serverSettings.getString("CredentialCache.DurationHours", null) != null) {
                    float credentialCacheDurationHours = serverSettings.getFloat("CredentialCache.DurationHours", 0.0f);
                    this.authState.setCredentialCacheDuration((int)(credentialCacheDurationHours * 60.0f * 60.0f));
                }
                if ((strSrvTime = serverSettings.getString("Server.Time", null)) != null) {
                    long serverTime = CMStringHelper.parseDateTime(strSrvTime).getTime();
                    this.timeOffset = System.currentTimeMillis() - serverTime;
                } else {
                    this.timeOffset = 0L;
                }
                String urlStr = serverSettings.getString("Server.URLs", null);
                if (urlStr != null && urlStr.length() > 0) {
                    String[] urls = CMStringHelper.split(urlStr, ';', true);
                    for (int i = 0; i < urls.length; ++i) {
                        try {
                            URI serverUrl = VMOptions.buildServerUrl(urls[i]);
                            if (serverUrl == null) continue;
                            String url = serverUrl.toString();
                            this.urlCache.put(url, url);
                            continue;
                        }
                        catch (CMException cMException) {
                            // empty catch block
                        }
                    }
                }
                float leaseDurationHours = serverSettings.getFloat("Lease.DurationHours", 0.0f);
                this.authState.setLeaseDuration((int)(leaseDurationHours * 60.0f * 60.0f));
                if (serverSettings.getString("Reports.BlackBerryMaxMessageSizeBytes", null) != null) {
                    this.blackBerryMaxMessageSizeBytes = serverSettings.getInt("Reports.BlackBerryMaxMessageSizeBytes", 128000);
                }
                if (serverSettings.getString("Location.EnableHotGPS", null) != null) {
                    this.enableHotGPS = serverSettings.getBoolean("Location.EnableHotGPS", false);
                }
                VM.log(CLASS, 0, "received server settings");
                try {
                    this.save();
                    break;
                }
                catch (CMException e) {
                    VM.log(CLASS, 3, e);
                }
            }
        }
    }

    @Override
    public void onSerializableSave(DataOutputStream out) throws IOException {
        String value;
        String key;
        out.writeByte(29);
        out.writeByte(this.getMinSeverity());
        out.writeUTF(this.getServerUrl() == null ? "" : this.getServerUrl());
        out.writeUTF(this.getEmailSubject() == null ? "" : this.getEmailSubject());
        out.writeUTF(this.getEmailMessage() == null ? "" : this.getEmailMessage());
        this.authState.saveCredentials(out);
        out.writeInt(this.getFontSize());
        out.writeInt(this.getPageInitialZoom());
        out.writeInt(this.getTextInitialZoom());
        out.writeInt(this.getKeep());
        out.writeInt(this.cookies.size() + 1);
        Enumeration e = this.cookies.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            value = (String)this.cookies.get(key);
            if (key != null && key.length() > 0 && value != null && value.length() > 0) {
                out.writeUTF(key == null ? "" : key);
                out.writeUTF(value == null ? "" : value);
                continue;
            }
            out.writeUTF("");
            out.writeUTF("");
        }
        this.authState.saveSessionCookie(out);
        out.writeUTF(this.getForceLocale() == null ? "" : this.getForceLocale());
        out.writeUTF(this.httpLogAddress == null ? "" : this.httpLogAddress);
        out.writeInt(this.sortOrder.getIdentifier());
        this.authState.saveLeaseDuration(out);
        out.writeUTF(this.preferredSyncMethod);
        out.writeInt(this.urlCache.size());
        e = this.urlCache.elements();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            value = (String)this.urlCache.get(key);
            out.writeUTF(key == null ? "" : key);
            out.writeUTF(value == null ? "" : value);
        }
        out.writeLong(this.timeOffset);
        if (this.about != null) {
            VM.log(CLASS, 0, "Saving server About");
            out.writeBoolean(true);
            out.writeUTF(this.about.product);
            out.writeUTF(this.about.vendor);
            out.writeUTF(this.about.versionBuild);
            out.writeUTF(this.about.versionMajor);
            out.writeUTF(this.about.versionMinor);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.imageInitialZoom);
        out.writeInt(0);
        out.writeLong(this.authState.getLeaseStart());
        out.writeInt(this.useLocation);
        out.writeInt(this.blackBerryMaxMessageSizeBytes);
        out.writeInt(this.cacheEncryption);
        if (this.about != null && this.about.versionMinor2 != null) {
            VM.log(CLASS, 0, "Saving server About minor2");
            out.writeBoolean(true);
            out.writeUTF(this.about.versionMinor2);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.gpsAlwaysOn);
        out.writeBoolean(this.enableHotGPS);
    }

    @Override
    public void onSerializableLoad(DataInputStream in) throws IOException {
        byte version = in.readByte();
        switch (version) {
            case 15: {
                this.readVersion15(version, in);
                break;
            }
            case 16: {
                this.readVersion16(version, in);
                break;
            }
            case 17: {
                this.readVersion17(version, in);
                break;
            }
            case 18: {
                this.readVersion18(version, in);
                break;
            }
            case 19: 
            case 20: {
                this.readVersion19(version, in);
                break;
            }
            case 21: {
                this.readVersion21(version, in);
                break;
            }
            case 22: {
                this.readVersion22(version, in);
                break;
            }
            case 23: {
                this.readVersion23(version, in);
                break;
            }
            case 24: {
                this.readVersion24(version, in);
                break;
            }
            case 25: {
                this.readVersion25(version, in);
                break;
            }
            case 26: {
                this.readVersion26(version, in);
                break;
            }
            case 27: {
                this.readVersion27(version, in);
                break;
            }
            case 28: {
                this.readVersion28(version, in);
                break;
            }
            case 29: {
                this.readVersion29(version, in);
                break;
            }
            default: {
                VM.log(CLASS, 3, "invalid or unsupported version: " + version);
                throw new IOException("invalid version");
            }
        }
    }

    private void readVersion15(int version, DataInputStream in) throws IOException {
        this.setMinSeverity(in.readByte());
        this.serverUrl = in.readUTF();
        this.setEmailSubject(in.readUTF());
        this.setEmailMessage(in.readUTF());
        int credentialCacheDurationSeconds = in.readInt();
        if (version < 20) {
            credentialCacheDurationSeconds *= 3600;
        }
        this.authState.setCredentialCacheDuration(credentialCacheDurationSeconds);
        this.authState.readCredentials(in);
        this.setFontSize(in.readInt());
        this.setPageInitialZoom(in.readInt());
        this.setTextInitialZoom(in.readInt());
        this.setKeep(in.readInt());
        int cookieSize = in.readInt();
        for (int i = 0; i < cookieSize; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            if (key == null || key.length() <= 0 || value == null || value.length() <= 0) continue;
            this.setCookie(key, value);
        }
        String locale = in.readUTF();
        if (locale != null && locale.length() == 0) {
            locale = null;
        }
        this.setForceLocale(locale);
        this.httpLogAddress = in.readUTF();
        this.sortOrder = XML.RenderComparator.fromIdentifier(in.readInt());
        int leaseDurationSeconds = in.readInt();
        if (version < 20) {
            leaseDurationSeconds *= 3600;
        }
        this.authState.setLeaseDuration(leaseDurationSeconds);
        this.preferredSyncMethod = in.readUTF();
        if (this.preferredSyncMethod.equals("V")) {
            this.preferredSyncMethod = "2";
        }
    }

    private void readVersion16(int version, DataInputStream in) throws IOException {
        this.readVersion15(version, in);
        int MRUSize = in.readInt();
        for (int i = 0; i < MRUSize; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            if (key == null || key.length() <= 0 || value == null || value.length() <= 0) continue;
            this.urlCache.put(key, value);
        }
        if (this.serverUrl != null && this.serverUrl.length() != 0) {
            this.urlCache.put(this.serverUrl, this.serverUrl);
        }
    }

    private void readVersion17(int version, DataInputStream in) throws IOException {
        this.readVersion16(version, in);
        this.timeOffset = in.readLong();
    }

    private void readVersion18(int version, DataInputStream in) throws IOException {
        this.readVersion17(version, in);
        if (in.readBoolean()) {
            this.about = new About();
            this.about.product = in.readUTF();
            this.about.vendor = in.readUTF();
            this.about.versionBuild = in.readUTF();
            this.about.versionMajor = in.readUTF();
            this.about.versionMinor = in.readUTF();
        }
    }

    private void readVersion19(int version, DataInputStream in) throws IOException {
        this.readVersion18(version, in);
        this.imageInitialZoom = in.readInt();
    }

    private void readVersion21(int version, DataInputStream in) throws IOException {
        this.readVersion19(version, in);
        in.readInt();
    }

    private void readVersion22(int version, DataInputStream in) throws IOException {
        this.readVersion21(version, in);
        in.readInt();
        this.authState.setLeaseStart(System.currentTimeMillis());
    }

    private void readVersion23(int version, DataInputStream in) throws IOException {
        this.readVersion21(version, in);
        this.authState.setLeaseStart(in.readLong());
    }

    private void readVersion24(int version, DataInputStream in) throws IOException {
        this.readVersion23(version, in);
        this.useLocation = 1;
    }

    private void readVersion25(int version, DataInputStream in) throws IOException {
        this.readVersion24(version, in);
        this.blackBerryMaxMessageSizeBytes = in.readInt();
    }

    private void readVersion26(int version, DataInputStream in) throws IOException {
        this.readVersion23(version, in);
        this.useLocation = in.readInt();
        this.blackBerryMaxMessageSizeBytes = in.readInt();
    }

    private void readVersion27(int version, DataInputStream in) throws IOException {
        this.readVersion26(version, in);
        this.cacheEncryption = in.readInt();
    }

    private void readVersion28(int version, DataInputStream in) throws IOException {
        this.readVersion27(version, in);
        if (in.readBoolean()) {
            this.about.versionMinor2 = in.readUTF();
        }
    }

    private void readVersion29(int version, DataInputStream in) throws IOException {
        this.readVersion28(version, in);
        this.gpsAlwaysOn = in.readInt();
        this.enableHotGPS = in.readBoolean();
    }

    public ICMCache getURLCache() {
        return this.urlCache;
    }

    public void setURLCache(ICMCache cache) {
        this.urlCache = cache;
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(long offset) {
        this.timeOffset = offset;
    }

    public About getAbout() {
        return this.about;
    }

    public void setAbout(About about) {
        this.about = about;
    }

    public int getBBMaxMessageSizeBytes() {
        return this.blackBerryMaxMessageSizeBytes;
    }

    public void setCacheEncryption(int encryption) {
        this.cacheEncryption = encryption;
    }

    public int getCacheEncryption() {
        return this.cacheEncryption;
    }

    public void clearCredentials() {
        this.authState.clearCredentials();
    }
}

