/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.vm.VMPoint;

public final class VMRect {
    public int x;
    public int y;
    public int cx;
    public int cy;

    public VMRect() {
        this.x = 0;
        this.y = 0;
        this.cx = 0;
        this.cy = 0;
    }

    public VMRect(VMRect other) {
        this.x = other.x;
        this.y = other.y;
        this.cx = other.cx;
        this.cy = other.cy;
    }

    public VMRect(int nx, int ny, int ncx, int ncy) {
        this.x = nx;
        this.y = ny;
        this.cx = ncx;
        this.cy = ncy;
    }

    public VMRect(VMPoint topLeft, VMPoint bottomRight) {
        this.x = topLeft.x;
        this.y = topLeft.y;
        this.cx = bottomRight.x - topLeft.x + 1;
        this.cy = bottomRight.y - topLeft.y + 1;
    }

    public void copy(VMRect other) {
        this.x = other.x;
        this.y = other.y;
        this.cx = other.cx;
        this.cy = other.cy;
    }

    public VMPoint getTopLeft() {
        return new VMPoint(this.x, this.y);
    }

    public int getRight() {
        return this.x + this.cx;
    }

    public int getBottom() {
        return this.y + this.cy;
    }

    public VMPoint getBottomRight() {
        return new VMPoint(this.x + this.cx, this.y + this.cy);
    }

    public void setRect(int x, int y, int cx, int cy) {
        this.x = x;
        this.y = y;
        this.cx = cx;
        this.cy = cy;
    }

    public void inflateRect(int dx, int dy) {
        this.x -= dx;
        this.y -= dy;
        this.cx += 2 * dx;
        this.cy += 2 * dy;
    }

    public boolean intersects(VMRect other) {
        if (other == this) {
            return true;
        }
        return this.x < other.getRight() && this.y < other.getBottom() && other.x < this.getRight() && other.y < this.getBottom();
    }

    public boolean intersectRect(VMRect other) {
        if (other == this) {
            return true;
        }
        if (!this.intersects(other)) {
            return false;
        }
        int right = Math.min(this.getRight(), other.getRight());
        this.x = Math.max(this.x, other.x);
        this.cx = right - this.x;
        if (this.cx <= 0) {
            return false;
        }
        int bottom = Math.min(this.getBottom(), other.getBottom());
        this.y = Math.max(this.y, other.y);
        this.cy = bottom - this.y;
        return this.cy > 0;
    }

    public boolean pointInRect(int hitx, int hity) {
        if (hitx < this.x) {
            return false;
        }
        if (hity < this.y) {
            return false;
        }
        if (hitx >= this.x + this.cx) {
            return false;
        }
        return hity < this.y + this.cy;
    }

    public boolean ensureMinimumSize(int cx, int cy) {
        boolean updated = false;
        if (cx > this.cx) {
            this.cx = cx;
            updated = true;
        }
        if (cy > this.cy) {
            this.cy = cy;
            updated = true;
        }
        return updated;
    }

    public static boolean intersects(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return x1 < x2 + w2 && x2 < x1 + w1 && y1 < y2 + h2 && y2 < y1 + h1;
    }

    public String toString() {
        return "x: " + this.x + " y: " + this.y + " cx: " + this.cx + " cy: " + this.cy;
    }
}

