/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.client.IClientApplication;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMList;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.model.data.Render;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.IVMCache;
import com.cognos.mobile.vm.IVMPainter;
import com.cognos.mobile.vm.IVMReader;
import com.cognos.mobile.vm.IVMSceneHost;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.NodeFinder;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMMemDatabase;
import com.cognos.mobile.vm.VMOpcodeHelper;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.render.SceneBuilder;
import java.util.Date;

public class VMRender {
    public static final char SCENEPATHCHAR_DELIMITER = '-';
    public static final char SCENEPATHCHAR_FOCUS_OBJECT = 'f';
    public static final char SCENEPATHCHAR_FOCUS_COLUMN = 'c';
    public static final char SCENEPATHCHAR_FOCUS_ROW = 'r';
    private static Class CLASS = VMRender.class;
    private final Render meta = new Render();
    private int m_startAddress;
    private String m_timestamp;
    private int m_version;
    private String m_gatewayUrl;
    private int m_sourceCode;
    private CMList m_pageList = new CMList(5);
    public IVMReader reader;

    public void openRender(int renderID, IVMReader aReader) throws CMException {
        this.reader = aReader;
        this.meta.renderID = renderID;
        this.m_startAddress = this.reader.onReaderOpen();
        this.loadMeta();
        int pages = this.getPageCount();
        if (pages == 0) {
            VMMemDatabase memDb = VMMemDatabase.fromReader(this.reader);
            this.reader = memDb;
            this.m_startAddress = this.reader.onReaderOpen();
            pages = this.getPageCount();
        }
        VM.log(CLASS, 1, "pages loaded: " + pages);
    }

    public Render getMeta() {
        return this.meta;
    }

    public int getRenderId() {
        if (this.meta == null) {
            return -1;
        }
        return this.meta.renderID;
    }

    public String getGatewayUrl() {
        return this.m_gatewayUrl;
    }

    public String getTimestamp() {
        return this.m_timestamp;
    }

    public int getVersion() {
        return this.m_version;
    }

    public int getPageCount() {
        return this.meta.pageCount;
    }

    public int getSourceCode() {
        return this.m_sourceCode;
    }

    public byte[] getSmallThumbnailImage() {
        return this.meta.smallThumbnailImage;
    }

    public byte[] getDashboardImage() {
        return this.meta.dashboardImage;
    }

    public String getDescription() {
        return this.meta.description;
    }

    public VMScene buildSceneFromScenePath(int pageIndex, String scenePath, int cxViewport, int cyViewport, IVMPainter painter, IVMSceneHost host, IClientApplication clientApplication, IVMCache cache, ITaskMonitor taskMonitor) throws CMException {
        VMScene scene = this.buildPageScene(pageIndex, cxViewport, cyViewport, painter, host, clientApplication, cache, taskMonitor);
        if (scenePath == null || scenePath.equals("")) {
            return scene;
        }
        VM.log(CLASS, 0, "cracking scene path: " + scenePath);
        for (int operation = 0; operation < 3; ++operation) {
            char operationChar = '\u0000';
            if (scenePath == null || scenePath.equals("")) break;
            switch (operation) {
                case 0: {
                    operationChar = 'f';
                    break;
                }
                case 1: {
                    operationChar = 'r';
                    break;
                }
                case 2: {
                    operationChar = 'c';
                }
            }
            while (scenePath != null && scenePath.charAt(0) == operationChar) {
                String nodePath;
                int index = scenePath.indexOf(45, 1);
                if (index == -1) {
                    nodePath = scenePath.substring(1);
                    scenePath = null;
                } else {
                    nodePath = scenePath.substring(1, index);
                    if ((scenePath = scenePath.substring(index + 1)).equals("")) {
                        scenePath = null;
                    }
                }
                Node node = NodeFinder.findNodeByNodePath(scene, nodePath);
                scene.getSelection().select(node);
                switch (operationChar) {
                    case 'f': {
                        scene = this.buildObjectScene(scene, node, cxViewport, cyViewport, painter, host, clientApplication, cache, taskMonitor);
                        break;
                    }
                    case 'r': {
                        scene = this.buildFocusScene(scene, 1, cxViewport, cyViewport, painter, host, taskMonitor);
                        break;
                    }
                    case 'c': {
                        scene = this.buildFocusScene(scene, 2, cxViewport, cyViewport, painter, host, taskMonitor);
                    }
                }
                VM.log(CLASS, 0, "- new scene: " + scene.getScenePath());
            }
        }
        return scene;
    }

    public VMScene buildPageScene(int pageIndex, int cxViewport, int cyViewport, IVMPainter painter, IVMSceneHost host, IClientApplication clientApplication, IVMCache cache, ITaskMonitor taskMonitor) throws CMException {
        Page p = this.findPage(0);
        if (p == null) {
            throw new CMException(1200, "invalid page number: " + pageIndex);
        }
        VMScene scene = new VMScene(this, pageIndex, "", 1, cxViewport, cyViewport, host, clientApplication, cache);
        SceneBuilder builder = new SceneBuilder(scene);
        builder.buildScene(p.startAddress, -1, 72, painter, taskMonitor);
        return scene;
    }

    public VMScene buildObjectScene(VMScene parentScene, Node focusNode, int cxViewport, int cyViewport, IVMPainter painter, IVMSceneHost host, IClientApplication clientApplication, IVMCache cache, ITaskMonitor taskMonitor) throws CMException {
        if (parentScene == null) {
            throw new CMException(1200, "null parent scene");
        }
        if (focusNode == null) {
            throw new CMException(1200, "null selected node");
        }
        int startAddress = focusNode.getStartAddress();
        int endAddress = focusNode.getEndAddress();
        String scenePath = 'f' + focusNode.getNodePath();
        VMScene objectScene = new VMScene(this, parentScene.getPageIndex(), scenePath, 2, cxViewport, cyViewport, host, clientApplication, cache);
        SceneBuilder builder = new SceneBuilder(objectScene);
        builder.buildScene(startAddress, endAddress, -1, painter, taskMonitor);
        return objectScene;
    }

    public VMScene buildFocusScene(VMScene parentScene, int focus, int cxViewport, int cyViewport, IVMPainter painter, IVMSceneHost host, ITaskMonitor taskMonitor) throws CMException {
        if (parentScene == null) {
            throw new CMException(1200, "null parent scene");
        }
        if (parentScene.getSelection().getSelectedNode() == null) {
            throw new CMException(1200, "nothing selected in parent");
        }
        String scenePath = parentScene.getScenePath();
        scenePath = scenePath + '-';
        switch (focus) {
            case 2: {
                scenePath = scenePath + 'c';
                break;
            }
            case 1: {
                scenePath = scenePath + 'r';
                break;
            }
            default: {
                String details = "invalid focus: " + focus;
                VM.log(CLASS, 3, details);
                throw new CMException(1200, details);
            }
        }
        scenePath = scenePath + parentScene.getSelection().getSelectedNode().getNodePath();
        SceneBuilder builder = new SceneBuilder(parentScene);
        VMScene focusScene = builder.buildFocusScene(scenePath, focus, cxViewport, cyViewport, painter, host, taskMonitor);
        return focusScene;
    }

    public int getPageStartAddress(int pageIndex) throws CMException {
        Page p = this.findPage(pageIndex);
        if (p == null) {
            throw new CMException(1200, "invalid page number: " + pageIndex);
        }
        return p.startAddress;
    }

    private void loadMeta() throws CMException {
        int instruction;
        int address = this.m_startAddress;
        IVMReader.CodeRecord code = new IVMReader.CodeRecord();
        while (this.reader.onReaderLoadCode(address, code) && (instruction = VMOpcodeHelper.decodeOpcodeToInstruction(code.opcode)) == 4) {
            switch (code.p1) {
                case 3: {
                    this.m_timestamp = this.reader.onReaderLoadString(code.p2);
                    if (this.m_timestamp == null) {
                        this.meta.renderTime = new Date();
                        break;
                    }
                    this.meta.renderTime = CMStringHelper.parseDateTime(this.m_timestamp);
                    break;
                }
                case 2: {
                    this.meta.label = CMUrlHelper.decodeSourcePathElement(this.reader.onReaderLoadString(code.p2));
                    break;
                }
                case 1: {
                    this.m_version = code.p2;
                    break;
                }
                case 5: {
                    this.meta.sourcePath = this.reader.onReaderLoadString(code.p2);
                    break;
                }
                case 6: {
                    this.m_gatewayUrl = this.reader.onReaderLoadString(code.p2);
                    break;
                }
                case 7: {
                    this.meta.cmPath = this.reader.onReaderLoadString(code.p2);
                    break;
                }
                case 17: {
                    this.meta.storeID = this.reader.onReaderLoadString(code.p2);
                    break;
                }
                case 4: {
                    this.meta.pageCount = code.p2;
                    break;
                }
                case 8: {
                    this.meta.status = code.p2;
                    break;
                }
                case 9: {
                    this.meta.drillParamsStr = this.reader.onReaderLoadString(code.p2);
                    break;
                }
                case 16: {
                    this.m_sourceCode = code.p2;
                    this.meta.sourceCode = code.p2;
                    break;
                }
                case 18: {
                    if (code.p2 == -1) break;
                    this.meta.smallThumbnailImage = this.reader.onReaderLoadBlob(code.p2);
                    break;
                }
                case 19: {
                    if (code.p2 == -1) break;
                    this.meta.dashboardImage = this.reader.onReaderLoadBlob(code.p2);
                    break;
                }
                case 20: {
                    this.meta.description = this.reader.onReaderLoadString(code.p2);
                    break;
                }
                case 21: {
                    this.meta.burstValue = this.reader.onReaderLoadString(code.p2);
                    if (this.meta.burstValue != null && !this.meta.burstValue.equals("")) {
                        this.meta.label = this.meta.label + " (" + this.meta.burstValue + ")";
                    }
                }
                default: {
                    VM.log(CLASS, 2, "ignoring unknown meta: " + code.p1);
                }
            }
            ++address;
        }
    }

    private Page findPage(int pageIndex) throws CMException {
        Page page;
        int address;
        if (pageIndex < 0) {
            return null;
        }
        if (pageIndex < this.m_pageList.size()) {
            Page page2 = (Page)this.m_pageList.elementAt(pageIndex);
            return page2;
        }
        if (this.m_pageList.size() == 0) {
            address = this.m_startAddress;
        } else {
            page = (Page)this.m_pageList.elementAt(this.m_pageList.size() - 1);
            address = page.endAddress;
        }
        IVMReader.CodeRecord buf = new IVMReader.CodeRecord();
        address = this.findInstruction(address, 71, 0);
        while (address >= 0) {
            this.reader.onReaderLoadCode(address, buf);
            page = new Page();
            page.pageNumber = buf.p1;
            page.startAddress = address;
            page.endAddress = this.findInstruction(address, 72, 0);
            this.m_pageList.pushLast(page);
            if (this.m_pageList.size() - 1 == pageIndex) {
                return page;
            }
            address = this.findInstruction(page.endAddress, 71, 0);
        }
        return null;
    }

    private int findInstruction(int startAddress, int instruction, int stopInstruction) throws CMException {
        IVMReader.CodeRecord buf = new IVMReader.CodeRecord();
        int address = startAddress;
        while (this.reader.onReaderLoadCode(address, buf)) {
            int currentInstruction = VMOpcodeHelper.decodeOpcodeToInstruction(buf.opcode);
            if (currentInstruction == instruction) {
                return address;
            }
            if (currentInstruction == stopInstruction || currentInstruction == 0) break;
            ++address;
        }
        return -1;
    }

    public void dispose() {
        this.reader.dispose();
    }

    private static class Page {
        int pageNumber;
        int startAddress;
        int endAddress;

        private Page() {
        }
    }
}

