/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.client.IClientApplication;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.CommandHelper;
import com.cognos.mobile.vm.IMouseHandler;
import com.cognos.mobile.vm.IVMCache;
import com.cognos.mobile.vm.IVMPainter;
import com.cognos.mobile.vm.IVMSceneHost;
import com.cognos.mobile.vm.ImageCache;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.Selection;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.VMRender;
import com.cognos.mobile.vm.VMViewport;
import com.cognos.mobile.vm.node.DefaultKeyHandler;
import com.cognos.mobile.vm.node.DefaultMouseHandler;
import com.cognos.mobile.vm.node.RootNode;
import com.cognos.mobile.vm.render.DrillContextState;
import com.cognos.mobile.vm.render.DrillTargetState;
import com.cognos.mobile.vm.render.DrillUpDownState;
import com.cognos.mobile.vm.render.Executive;
import com.cognos.mobile.vm.render.FindState;
import com.cognos.mobile.vm.render.MailtoContextState;
import com.cognos.mobile.vm.render.RenderState;
import com.cognos.mobile.vm.render.SceneBuilder;
import com.cognos.mobile.vm.render.SceneZoomer;
import com.cognos.mobile.vm.render.State;
import com.cognos.mobile.vm.render.TextState;
import java.util.Vector;

public class VMScene {
    public static final int TYPE_NULL = 0;
    public static final int TYPE_PAGE = 1;
    public static final int TYPE_OBJECT = 2;
    public static final int TYPE_FOCUS = 3;
    public static final int ZOOM_FIT_WIDTH = -1;
    public static final int ZOOM_FIT_PAGE = -2;
    public static final int ZOOM_ON_WIDTH = 1;
    public static final int ZOOM_ON_HEIGHT = -1;
    public static final int ZOOM_MAX = 300;
    public static final int ZOOM_MIN = 10;
    public static final int STYLE_ZOOMED = 1;
    public static final int STYLE_HIDE_IMAGES = 2;
    public static final int STYLE_FOCUS_ROW = 4;
    public static final int STYLE_FOCUS_COLUMN = 8;
    public static final int PERFORMRENDER_DOWNLOAD = 0;
    public static final int PERFORMRENDER_CLIENT = 1;
    public VMViewport viewport;
    private static Class CLASS = VMScene.class;
    private final VMRender render;
    private final int pageIndex;
    private int type;
    private IVMSceneHost host;
    private final String scenePath;
    private final IClientApplication clientApplication;
    private final IVMCache clientCache;
    private int style;
    private Node rootNode;
    private boolean isFocused;
    private Selection selection;
    private DefaultKeyHandler defaultKeyHandler;
    private DefaultMouseHandler defaultMouseHandler;
    private IMouseHandler mouseHandler;
    private SceneZoomer sceneZoomer;
    private ImageCache imageCache;
    private String tooltip;
    private Object lock = new Object();
    private int sampleUnzoomedTextSize;

    public VMScene(VMRender parentRender, int pageIndex, String scenePath, int type, int cxViewport, int cyViewport, IVMSceneHost host, IClientApplication clientApplication, IVMCache clientCache) {
        this.render = parentRender;
        this.pageIndex = pageIndex;
        this.type = type;
        this.host = host;
        this.clientApplication = clientApplication;
        this.clientCache = clientCache;
        this.scenePath = scenePath;
        this.viewport = new VMViewport(cxViewport, cyViewport, cxViewport, cyViewport);
        this.style = 0;
        this.selection = new Selection(this);
        this.defaultKeyHandler = new DefaultKeyHandler(this);
        this.defaultMouseHandler = new DefaultMouseHandler(this);
        this.mouseHandler = null;
        this.rootNode = new RootNode(this);
        this.sceneZoomer = null;
        this.imageCache = new ImageCache(this, clientCache);
        this.sampleUnzoomedTextSize = -1;
    }

    public void dispose() {
        this.imageCache.dispose();
    }

    public int getType() {
        return this.type;
    }

    public void setHost(IVMSceneHost host) {
        this.host = host;
    }

    public IVMSceneHost getHost() {
        return this.host;
    }

    public VMViewport getViewport() {
        return this.viewport;
    }

    public IClientApplication getClientApplication() {
        return this.clientApplication;
    }

    public IVMCache getClientCache() {
        return this.clientCache;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public ImageCache getImageCache() {
        return this.imageCache;
    }

    public long getEnabledCommands() {
        return CommandHelper.getEnabledCommands(this);
    }

    public VMRender getRender() {
        return this.render;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setSceneZoomer(SceneZoomer sceneZoomer) {
        this.sceneZoomer = sceneZoomer;
    }

    public SceneZoomer getSceneZoomer() {
        return this.sceneZoomer;
    }

    public final boolean checkStyle(int styleMask) {
        return (this.style & styleMask) == styleMask;
    }

    public final void setStyle(int styleFlags) {
        this.style |= styleFlags;
    }

    public final void clearStyle(int styleFlags) {
        this.style &= ~styleFlags;
    }

    public Object getLock() {
        return this.lock;
    }

    public void relayoutScene(IVMPainter painter, MobileServiceProxy mobileServiceProxy, int cxViewport, int cyViewport, int tileSize) throws CMException {
        this.getViewport().setViewportSize(cxViewport, cyViewport);
        SceneBuilder builder = new SceneBuilder(this);
        builder.layoutScene(painter, cxViewport, 100, 1.0, mobileServiceProxy, tileSize, ITaskMonitor.NULL, false);
        if (this.sceneZoomer != null) {
            int unzoomedWidth = this.getRootNode().getUnzoomedRect().cx;
            int unzoomedHeight = this.getRootNode().getUnzoomedRect().cy;
            this.sceneZoomer.rezoom(painter, mobileServiceProxy, unzoomedWidth, unzoomedHeight, tileSize);
        }
    }

    public int getZoomLevel() {
        if (this.sceneZoomer == null) {
            return 100;
        }
        return this.sceneZoomer.getZoomLevel();
    }

    public void zoomSceneByPageSize(IVMPainter painter, int pageSize, MobileServiceProxy mobileServiceProxy, int tileSize, int direction, ITaskMonitor taskMonitor) throws CMException {
        this.createSceneZoomer();
        if (direction == 1) {
            this.sceneZoomer.zoomSceneByPageWidth(painter, pageSize, mobileServiceProxy, tileSize, taskMonitor);
        } else {
            this.sceneZoomer.zoomSceneByPageHeight(painter, pageSize, mobileServiceProxy, tileSize, taskMonitor);
        }
    }

    public void zoomSceneByZoomLevel(IVMPainter painter, int zoomLevel, MobileServiceProxy mobileServiceProxy, int tileSize, ITaskMonitor taskMonitor) throws CMException {
        this.createSceneZoomer();
        this.sceneZoomer.zoomSceneByZoomLevel(painter, zoomLevel, mobileServiceProxy, tileSize, taskMonitor);
    }

    public int zoomSceneIn(boolean isZoomIn, IVMPainter painter, MobileServiceProxy mobileServiceProxy, int tileSize, ITaskMonitor taskMonitor) throws CMException {
        this.createSceneZoomer();
        return this.sceneZoomer.zoomSceneIn(isZoomIn, painter, mobileServiceProxy, tileSize, taskMonitor);
    }

    private void createSceneZoomer() {
        if (this.sceneZoomer == null) {
            int unzoomedWidth = this.rootNode.getUnzoomedRect().cx;
            int unzoomedHeight = this.rootNode.getUnzoomedRect().cy;
            this.sceneZoomer = new SceneZoomer(this, unzoomedWidth, unzoomedHeight);
        }
    }

    public void setTooltip(String message) {
        this.tooltip = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintScene(IVMPainter painter, VMRect clipRect) throws CMException {
        Object object = this.lock;
        synchronized (object) {
            RenderState state = null;
            try {
                if (VM.wouldLog(CLASS, 1)) {
                    VM.log(CLASS, 1, "paint begin");
                }
                long startTime = System.currentTimeMillis();
                state = this.sceneZoomer != null ? new RenderState(3, this.render.reader, painter, clipRect, this.sceneZoomer.getPaintPageWidth(), this.getViewport().getViewportWidth(), this.sceneZoomer.getPaintLevel(), this.sceneZoomer.getPaintScale(), null, 0, false, this.getUnzoomedSampleTextSize()) : new RenderState(3, this.render.reader, painter, clipRect, this.getViewport().getViewportWidth());
                this.rootNode.paint(state);
                if (this.tooltip != null) {
                    if (this.host != null) {
                        this.host.onSceneShowTooltip(this, this.tooltip);
                    }
                    this.tooltip = null;
                }
                long stopTime = System.currentTimeMillis();
                if (VM.wouldLog(CLASS, 1)) {
                    VM.log(CLASS, 1, "paint end in " + Long.toString(stopTime - startTime) + "ms");
                }
            }
            finally {
                if (state != null) {
                    state.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findString(String str) throws CMException {
        if (str == null || str.length() == 0) {
            return 0;
        }
        State state = null;
        try {
            long startTime = System.currentTimeMillis();
            state = new FindState(this.render.reader, str);
            this.rootNode.find((FindState)state);
            this.selection.tag(((FindState)state).getFoundNodes(), str, true);
            this.selection.selectFirstTagged(1, 1);
            long stopTime = System.currentTimeMillis();
            if (VM.wouldLog(CLASS, 1)) {
                VM.log(CLASS, 1, "find string end in " + Long.toString(stopTime - startTime) + "ms");
            }
        }
        finally {
            if (state != null) {
                state.dispose();
            }
        }
        return this.selection.getTaggedCount();
    }

    public int findNextString() throws CMException {
        if (!this.isFindNextActive()) {
            return 0;
        }
        this.selection.selectNextTagged(1, 1);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadText(Node startNode) throws CMException {
        State state = null;
        try {
            if (startNode == null) {
                startNode = this.rootNode;
            }
            if (VM.wouldLog(CLASS, 1)) {
                VM.log(CLASS, 1, "load text begin");
            }
            long startTime = System.currentTimeMillis();
            state = new TextState(this.render.reader);
            Executive.executeNode(startNode, state);
            long stopTime = System.currentTimeMillis();
            if (VM.wouldLog(CLASS, 1)) {
                VM.log(CLASS, 1, "load text end in " + Long.toString(stopTime - startTime) + "ms");
            }
            String string = ((TextState)state).getLoadedText();
            return string;
        }
        finally {
            if (state != null) {
                state.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector loadDrillTargetsInfo() throws CMException {
        State state = null;
        try {
            if (VM.wouldLog(CLASS, 1)) {
                VM.log(CLASS, 1, "load drillDrillTargetInfo begin");
            }
            long startTime = System.currentTimeMillis();
            state = new DrillTargetState(this.render.reader);
            int pageStartAddress = this.render.getPageStartAddress(0);
            Executive.executeProgram(state, pageStartAddress, -1, 72);
            long stopTime = System.currentTimeMillis();
            if (VM.wouldLog(CLASS, 1)) {
                VM.log(CLASS, 1, "load drillDrillTargetInfo in " + Long.toString(stopTime - startTime) + "ms");
            }
            Vector vector = ((DrillTargetState)state).getDrillTargets();
            return vector;
        }
        finally {
            if (state != null) {
                state.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector loadDrillContext(Node startNode) throws CMException {
        State state = null;
        try {
            if (VM.wouldLog(CLASS, 1)) {
                VM.log(CLASS, 1, "load drillContext begin");
            }
            long startTime = System.currentTimeMillis();
            state = new DrillContextState(this.render.reader);
            Executive.executeNode(startNode, state);
            long stopTime = System.currentTimeMillis();
            if (VM.wouldLog(CLASS, 1)) {
                VM.log(CLASS, 1, "load drillContext end in " + Long.toString(stopTime - startTime) + "ms");
            }
            Vector vector = ((DrillContextState)state).getDrillContexts();
            return vector;
        }
        finally {
            if (state != null) {
                state.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrillUpDownState loadDrillUpDownContext(Node startNode) throws CMException {
        State state = null;
        try {
            if (VM.wouldLog(CLASS, 1)) {
                VM.log(CLASS, 1, "load drillUpDownContext begin");
            }
            long startTime = System.currentTimeMillis();
            state = new DrillUpDownState(this.render.reader);
            Executive.executeNode(startNode, state);
            long stopTime = System.currentTimeMillis();
            if (VM.wouldLog(CLASS, 1)) {
                VM.log(CLASS, 1, "load drillUpDownContext end in " + Long.toString(stopTime - startTime) + "ms");
            }
            State state2 = state;
            return state2;
        }
        finally {
            if (state != null) {
                state.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector loadMailtoContext(Node startNode) throws CMException {
        State state = null;
        try {
            if (VM.wouldLog(CLASS, 1)) {
                VM.log(CLASS, 1, "load mailtoContext begin");
            }
            long startTime = System.currentTimeMillis();
            state = new MailtoContextState(this.render.reader);
            Executive.executeNode(startNode, state);
            long stopTime = System.currentTimeMillis();
            if (VM.wouldLog(CLASS, 1)) {
                VM.log(CLASS, 1, "load mailtoContext end in " + Long.toString(stopTime - startTime) + "ms");
            }
            Vector vector = ((MailtoContextState)state).getMailtoContexts();
            return vector;
        }
        finally {
            if (state != null) {
                state.dispose();
            }
        }
    }

    public String getScenePath() {
        return this.scenePath;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void setFocus(boolean isFocused, boolean invalidate) {
        if (this.isFocused != isFocused) {
            this.isFocused = isFocused;
            if (VM.wouldLog(CLASS, 1)) {
                VM.log(CLASS, 1, this.isFocused ? "scene got focus" : "scene lost focus");
            }
            if (invalidate && this.host != null && this.selection.getSelectedNode() != null) {
                VMRect rect = this.selection.getSelectedNode().getAbsoluteRect();
                this.host.onSceneInvalidateRect(this, rect);
            }
        }
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public boolean isKeySupported(int key) {
        return key >= 1 && key <= 9;
    }

    public void sendKey(int key, int amount, int flags) {
        if (this.host != null) {
            this.host.onSceneHideTooltip(this);
        }
        if (amount <= 0) {
            amount = 1;
        }
        for (int i = 0; i < amount; ++i) {
            Node node = this.getSelection().getSelectedNode();
            if (node != null && node.getKeyHandler() != null && node.getKeyHandler().sendKey(key, flags)) continue;
            this.defaultKeyHandler.sendKey(key, flags);
        }
    }

    public void sendMouse(int mouse, int x, int y) {
        if (this.mouseHandler == null) {
            Node node = this.getRootNode().findNodeFromPoint(x, y);
            if (node == null) {
                if (this.getType() == 2 || this.getType() == 3) {
                    this.mouseHandler = this.getRootNode().getType() == 0 && this.getRootNode().getChild(0) != null ? this.getRootNode().getChild(0).getMouseHandler() : this.getRootNode().getMouseHandler();
                }
            } else {
                while (node != null && this.mouseHandler == null) {
                    this.mouseHandler = node.getMouseHandler();
                    node = node.getParent();
                }
            }
            if (this.mouseHandler == null) {
                this.mouseHandler = this.defaultMouseHandler;
            }
        }
        this.mouseHandler.sendMouse(mouse, x, y);
        if (mouse == 3) {
            this.mouseHandler = null;
        }
    }

    public void logTree(RenderState state) {
        this.logTree(VM.LOGTREEFORMAT_REGULAR, false, state);
    }

    public void logTree(int format, boolean trimmed, RenderState state) {
        if (this.rootNode == null) {
            if (VM.wouldLog(CLASS, 0)) {
                VM.log(CLASS, 0, "no tree");
            }
        } else {
            this.rootNode.logTree("", format, null, trimmed, state);
        }
    }

    public boolean isFindNextActive() {
        return this.selection.getTaggedCount() > 1;
    }

    public void markSelectedNode(boolean mark) {
        Node node = this.selection.getSelectedNode();
        this.markCellNode(node, mark);
    }

    public void markNode(Node node, boolean mark) {
        if (node == null) {
            return;
        }
        Node findNode = this.getRootNode().findNodeFromAddress(node.startAddress);
        this.markCellNode(findNode, mark);
    }

    private void markCellNode(Node node, boolean mark) {
        if (node == null) {
            return;
        }
        if (!node.checkStyle(65536)) {
            return;
        }
        if (mark) {
            node.setStyle(131072, true);
        } else {
            node.clearStyle(131072, true);
        }
    }

    public double getLastZoomScale() {
        if (this.sceneZoomer != null) {
            return this.sceneZoomer.getScale();
        }
        return 1.0;
    }

    public int getLastZoomLevel() {
        if (this.sceneZoomer != null) {
            return this.sceneZoomer.getZoomLevel();
        }
        return 100;
    }

    public int getLastZoomPageWidth() {
        if (this.sceneZoomer != null) {
            if (this.sceneZoomer.getZoomLevel() == 100 && this.sceneZoomer.getPageWidth() == 0) {
                return this.viewport == null ? 0 : this.viewport.getViewportWidth();
            }
            return this.sceneZoomer.getPageWidth();
        }
        return 0;
    }

    public void setUnzoomedSampleTextSize(int sampleUnzoomedTextSize) {
        this.sampleUnzoomedTextSize = sampleUnzoomedTextSize;
    }

    public int getUnzoomedSampleTextSize() {
        return this.sampleUnzoomedTextSize;
    }

    public static class Hints {
        public Node selected;
    }
}

