/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;

public class VMViewport {
    public int x;
    public int y;
    private static final int SNAP_WIDTH = 5;
    private static final int SNAP_HEIGHT = 5;
    private int cxViewport;
    private int cyViewport;
    private int cxCanvas;
    private int cyCanvas;

    public VMViewport(int cxViewport, int cyViewport, int cxCanvas, int cyCanvas) {
        this.x = 0;
        this.y = 0;
        this.cxViewport = cxViewport;
        this.cyViewport = cyViewport;
        this.cxCanvas = cxCanvas;
        this.cyCanvas = cyCanvas;
    }

    public VMViewport(VMViewport other) {
        this.x = other.x;
        this.y = other.y;
        this.cxViewport = other.cxViewport;
        this.cyViewport = other.cyViewport;
        this.cxCanvas = other.cxCanvas;
        this.cyCanvas = other.cyCanvas;
    }

    public int getScrollX() {
        return this.x;
    }

    public int getScrollY() {
        return this.y;
    }

    public int getViewportWidth() {
        return this.cxViewport;
    }

    public int getViewportHeight() {
        return this.cyViewport;
    }

    public VMRect getViewportRect() {
        return new VMRect(-this.x, -this.y, this.cxViewport, this.cyViewport);
    }

    public void setViewportSize(int cxViewport, int cyViewport) {
        this.cxViewport = cxViewport;
        this.cyViewport = cyViewport;
    }

    public int getCanvasWidth() {
        return this.cxCanvas;
    }

    public int getCanvasHeight() {
        return this.cyCanvas;
    }

    public VMRect getCanvasRect() {
        return new VMRect(0, 0, this.cxCanvas, this.cyCanvas);
    }

    public void setCanvasSize(int cxCanvas, int cyCanvas) {
        this.cxCanvas = cxCanvas;
        this.cyCanvas = cyCanvas;
        this.scrollTo(this.x, this.y);
    }

    public boolean isScrollable() {
        return this.cxCanvas > this.cxViewport || this.cyCanvas > this.cyViewport;
    }

    public boolean isScrollableX() {
        return this.cxCanvas > this.cxViewport;
    }

    public boolean isScrollableY() {
        return this.cyCanvas > this.cyViewport;
    }

    public boolean scrollTo(int newX, int newY) {
        int min;
        if (this.cxCanvas > this.cxViewport) {
            min = this.cxViewport - this.cxCanvas;
            if (newX > 0) {
                newX = 0;
            } else if (newX < min) {
                newX = min;
            }
        } else {
            newX = 0;
        }
        if (this.cyCanvas > this.cyViewport) {
            min = this.cyViewport - this.cyCanvas;
            if (newY > 0) {
                newY = 0;
            } else if (newY < min) {
                newY = min;
            }
        } else {
            newY = 0;
        }
        boolean changed = false;
        if (this.x != newX) {
            changed = true;
            this.x = newX;
        }
        if (this.y != newY) {
            changed = true;
            this.y = newY;
        }
        return changed;
    }

    public boolean ensureRectVisible(VMRect rect, int dir, boolean allowSnap) {
        int i;
        int stop;
        int start;
        int oldXOrigin = this.x;
        int oldYOrigin = this.y;
        if (dir < 0) {
            dir = -1;
            start = 1;
            stop = -1;
        } else {
            dir = 1;
            start = 0;
            stop = 2;
        }
        if (this.cxCanvas > this.cxViewport) {
            int left;
            int right;
            boolean allowHorzSnap = false;
            block8: for (i = start; i != stop; i += dir) {
                switch (i) {
                    case 0: {
                        right = this.logicalToPhysicalX(rect.x + rect.cx);
                        if (right < this.cxViewport) continue block8;
                        this.x -= right - this.cxViewport;
                        allowHorzSnap = allowSnap;
                        continue block8;
                    }
                    case 1: {
                        left = this.logicalToPhysicalX(rect.x);
                        if (left >= 0) continue block8;
                        this.x -= left;
                        allowHorzSnap = allowSnap;
                    }
                }
            }
            if (allowHorzSnap) {
                right = rect.x + rect.cx - 1;
                if (right + 5 > this.cxCanvas) {
                    this.x = this.cxViewport - this.cxCanvas - 1;
                }
                if ((left = rect.x) < 5) {
                    this.x = 0;
                }
            }
        }
        if (this.cyCanvas > this.cyViewport) {
            int top;
            int bottom;
            boolean allowVertSnap = false;
            block9: for (i = start; i != stop; i += dir) {
                switch (i) {
                    case 0: {
                        bottom = this.logicalToPhysicalY(rect.y + rect.cy);
                        if (bottom < this.cyViewport) continue block9;
                        this.y -= bottom - this.cyViewport;
                        allowVertSnap = allowSnap;
                        continue block9;
                    }
                    case 1: {
                        top = this.logicalToPhysicalY(rect.y);
                        if (top >= 0) continue block9;
                        this.y -= top;
                        allowVertSnap = allowSnap;
                    }
                }
            }
            if (allowVertSnap) {
                bottom = rect.y + rect.cy - 1;
                if (bottom + 5 > this.cyCanvas) {
                    this.y = this.cyViewport - this.cyCanvas - 1;
                }
                if ((top = rect.y) < 5) {
                    this.y = 0;
                }
            }
        }
        if (this.x != oldXOrigin) {
            return true;
        }
        return this.y != oldYOrigin;
    }

    public int logicalToPhysicalX(int otherX) {
        return otherX + this.x;
    }

    public int physicalToLogicalX(int otherX) {
        return otherX - this.x;
    }

    public int logicalToPhysicalY(int otherY) {
        return otherY + this.y;
    }

    public int physicalToLogicalY(int otherY) {
        return otherY - this.y;
    }

    public VMPoint logicalToPhysical(VMPoint pt) {
        VMPoint newPoint = new VMPoint(pt.x + this.x, pt.y + this.y);
        return newPoint;
    }

    public VMRect logicalToPhysical(VMRect rect) {
        VMRect newRect = new VMRect(rect.x + this.x, rect.y + this.y, rect.cx, rect.cy);
        return newRect;
    }
}

