/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMImageHelper;
import com.cognos.mobile.common.CMMathHelper;
import com.cognos.mobile.vm.IVMImage;
import com.cognos.mobile.vm.IVMPainter;
import com.cognos.mobile.vm.IVMReader;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.render.RenderState;

public class ZoomImageBuilder {
    private static final Class CLASS = ZoomImageBuilder.class;

    public static IVMImage buildNodeZoomImage(Node node, IVMReader reader, IVMPainter painter, int imageWidth) throws CMException {
        RenderState state = new RenderState(11, reader, painter, null, imageWidth);
        int cx = imageWidth;
        int cy = CMMathHelper.multiplyIntByDouble(imageWidth, (double)node.getRect().cy / (double)node.getRect().cx);
        return ZoomImageBuilder.buildNodeZoomImage(node, state, cx, cy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IVMImage buildNodeZoomImage(Node node, RenderState state, int cx, int cy) throws CMException {
        if (cx <= 0 || cy <= 0) {
            VM.log(CLASS, 2, "empty image size");
            IVMImage emptyImage = state.getPainter().createImage(1, 1);
            return emptyImage;
        }
        VM.log(CLASS, 1, "buildNodeZoomImage begin");
        long startTime = System.currentTimeMillis();
        IVMPainter fullPainter = null;
        IVMImage zoomImage = null;
        try {
            int cxFull = Math.max(1, node.getUnzoomedRect().cx);
            int cyFull = Math.max(1, node.getUnzoomedRect().cy);
            fullPainter = state.getPainter().createImagePainter(cxFull, cyFull);
            fullPainter.addOffset(-node.getUnzoomedRect().x, -node.getUnzoomedRect().y);
            String statistics = "";
            RenderState fullState = new RenderState(11, state.reader, fullPainter, null, cxFull);
            try {
                fullState.setPaintSelection(false);
                node.paint(fullState);
            }
            finally {
                fullState.dispose();
            }
            int cxZoom = Math.max(1, cx);
            int cyZoom = Math.max(1, cy);
            IVMPainter zoomPainter = state.getPainter().createImagePainter(cxZoom, cyZoom);
            zoomImage = ZoomImageBuilder.buildZoomImage(fullPainter, zoomPainter, cxZoom, cyZoom, cxFull, cyFull, statistics);
            long stopTime = System.currentTimeMillis();
            VM.log(CLASS, 1, "buildNodeZoomImage end in " + Long.toString(stopTime - startTime) + "ms," + statistics);
        }
        finally {
            if (fullPainter != null) {
                fullPainter.dispose();
            }
        }
        return zoomImage;
    }

    public static IVMImage buildTextZoomImage(String text, IVMPainter painter, double zoomScaleX, double zoomScaleY, int textColor, int backColor) throws CMException {
        int cxZoom = Math.max(1, CMMathHelper.multiplyIntByDouble(Math.max(1, painter.measureString((String)text).x), zoomScaleX));
        int cyZoom = Math.max(1, CMMathHelper.multiplyIntByDouble(Math.max(1, painter.measureString((String)text).y), zoomScaleY));
        return ZoomImageBuilder.buildTextZoomImage(text, painter, cxZoom, cyZoom, textColor, backColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IVMImage buildTextZoomImage(String text, IVMPainter painter, int cxZoom, int cyZoom, int textColor, int backColor) throws CMException {
        VM.log(CLASS, 1, "buildTextZoomImage begin");
        long startTime = System.currentTimeMillis();
        IVMPainter fullPainter = null;
        IVMImage zoomImage = null;
        try {
            int cxFull = Math.max(1, painter.measureString((String)text).x);
            int cyFull = Math.max(1, painter.measureString((String)text).y);
            fullPainter = painter.createImagePainter(cxFull, cyFull);
            fullPainter.addOffset(0, 0);
            String statistics = new String();
            fullPainter.setBackgroundColor(backColor);
            fullPainter.setColor(backColor);
            fullPainter.fillRect(0, 0, cxFull, cyFull);
            fullPainter.setColor(textColor);
            fullPainter.drawString(0, 0, text);
            IVMPainter zoomPainter = painter.createImagePainter(cxZoom, cyZoom);
            zoomImage = ZoomImageBuilder.buildZoomImage(fullPainter, zoomPainter, cxZoom, cyZoom, cxFull, cyFull, statistics);
            long stopTime = System.currentTimeMillis();
            VM.log(CLASS, 1, "buildTextZoomImage end in " + Long.toString(stopTime - startTime) + "ms," + statistics);
        }
        finally {
            if (fullPainter != null) {
                fullPainter.dispose();
            }
        }
        return zoomImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IVMImage buildZoomImage(IVMPainter fullPainter, IVMPainter zoomPainter, int cxZoom, int cyZoom, int cxFull, int cyFull, String statistics) throws CMException {
        IVMImage zoomImage;
        block13: {
            IVMImage fullImage = null;
            zoomImage = null;
            try {
                fullImage = fullPainter.getImage();
                zoomImage = zoomPainter.getImage();
                if (cxZoom < cxFull) {
                    if (zoomPainter.drawStretchedImage(0, 0, cxZoom, cyZoom, fullImage)) {
                        statistics = " alg=painter_shrink(" + cxZoom + ")";
                    } else {
                        try {
                            CMImageHelper.shrinkImage(cxFull, cyFull, fullImage, cxZoom, cyZoom, zoomImage);
                        }
                        catch (OutOfMemoryError oome) {
                            VM.log(CMImageHelper.class, 3, "ran out of device memory resizing image, attempting low-memory process");
                            System.gc();
                            CMImageHelper.shrinkImageUsingLessMemory(cxFull, cyFull, fullImage, cxZoom, cyZoom, zoomImage);
                        }
                        statistics = " alg=shrink(" + cxZoom + ")";
                    }
                    zoomImage = zoomPainter.releaseImage();
                    break block13;
                }
                if (cxZoom == cxFull) {
                    zoomPainter.dispose();
                    zoomPainter = null;
                    zoomImage = fullPainter.releaseImage();
                    statistics = " alg=copy";
                } else {
                    if (zoomPainter.drawStretchedImage(0, 0, cxZoom, cyZoom, fullImage)) {
                        statistics = " alg=painter_enlarge(" + cxZoom + ")";
                    } else {
                        CMImageHelper.enlargeImage(cxFull, cyFull, fullImage, cxZoom, cyZoom, zoomImage);
                        statistics = " alg=enlarge(" + cxZoom + ")";
                    }
                    zoomImage = zoomPainter.releaseImage();
                }
            }
            finally {
                if (zoomPainter != null) {
                    zoomPainter.dispose();
                }
            }
        }
        return zoomImage;
    }
}

