/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.layout;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.FlowContainer;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.layout.ILayout;
import com.cognos.mobile.vm.render.RenderState;
import java.util.Vector;

public class FlowLayout
implements ILayout {
    private static FlowLayout singleton = null;

    public static FlowLayout instance() {
        if (singleton == null) {
            singleton = new FlowLayout();
        }
        return singleton;
    }

    @Override
    public void layout(Node node, RenderState state, int x, int y) throws CMException {
        int margin = node.getMargin();
        if (node.getChildCount() == 0) {
            VMPoint preferredSize = node.getPreferredSize(state);
            node.setLayout(margin + x, margin + y, preferredSize.x, preferredSize.y, state);
        } else {
            VMPoint alignSize = new VMPoint(node.getPreferredSize((RenderState)state).x, node.getPreferredSize((RenderState)state).y);
            Vector nodeRows = this.buildRows(node, state);
            VMPoint size = new VMPoint();
            this.flowRows(node, nodeRows, size, state);
            this.flowAbsolutePositionedNodes(node, state, x, y, (NodeRow)nodeRows.elementAt(0), size);
            if (state.isLayoutToViewport() || state.getWidth(node) > 0) {
                if (size.x > node.getPreferredSize((RenderState)state).x) {
                    alignSize.x = size.x;
                }
                if (size.y > node.getPreferredSize((RenderState)state).y) {
                    alignSize.y = size.y;
                }
            } else {
                alignSize.x = size.x;
                alignSize.y = size.y;
            }
            this.horizontallyAlignRows(node, nodeRows, alignSize.x, alignSize.y, state);
            node.setLayout(margin + x, margin + y, alignSize.x, size.y, state);
            node.setTempLayoutCx(alignSize.x);
        }
    }

    private Vector buildRows(Node node, RenderState renderState) throws CMException {
        Vector<NodeRow> nodeRows = new Vector<NodeRow>();
        nodeRows.addElement(new NodeRow());
        NodeRow currentRow = new NodeRow();
        boolean childPrevBlock = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChild(i);
            child.layout(renderState, 0, 0);
            if (child.checkStyle(0x100000)) {
                ((NodeRow)nodeRows.elementAt(0)).addNode(child);
                continue;
            }
            boolean isNewRow = false;
            if (currentRow.nodes != null) {
                if (childPrevBlock || child.checkStyle(524288)) {
                    isNewRow = true;
                }
                if (child.checkStyle(0x200000)) {
                    isNewRow = true;
                }
            }
            if (isNewRow) {
                nodeRows.addElement(currentRow);
                currentRow = new NodeRow(0);
            }
            currentRow.addNode(child);
            childPrevBlock = child.checkStyle(524288);
        }
        if (currentRow.size() > 0) {
            nodeRows.addElement(currentRow);
        }
        nodeRows.trimToSize();
        return nodeRows;
    }

    private void flowRows(Node node, Vector nodeRows, VMPoint size, RenderState state) {
        int parentCX;
        boolean allowGrowX;
        if (node.getMaxSize((RenderState)state).x == 0) {
            allowGrowX = true;
            parentCX = 0;
        } else {
            allowGrowX = false;
            parentCX = node.getMaxSize((RenderState)state).x;
        }
        FlowContainer flowContainer = new FlowContainer(0, allowGrowX, true, 0, 0, parentCX, 0);
        for (int i = 1; i < nodeRows.size(); ++i) {
            NodeRow curRow = (NodeRow)nodeRows.elementAt(i);
            for (int j = 0; j < curRow.size(); ++j) {
                Node child = curRow.getNode(j);
                if (child == null) continue;
                int childMargin = state.getWidth(node) > 0 ? 0 : child.getMargin() / 2;
                int objectCX = child.getLayoutRect().cx + 2 * childMargin;
                int objectCY = child.getLayoutRect().cy + 2 * childMargin;
                VMPoint topLeft = flowContainer.insertObject(objectCX, objectCY);
                child.setLayout(topLeft.x + childMargin, topLeft.y + childMargin, objectCX - 2 * childMargin, objectCY - 2 * childMargin, state);
            }
            flowContainer.insertNextLine();
        }
        VMPoint extent = flowContainer.getExtent();
        size.x = Math.max(size.x, extent.x);
        size.y = Math.max(size.y, extent.y);
    }

    private void flowAbsolutePositionedNodes(Node node, RenderState renderState, int x, int y, NodeRow row, VMPoint size) {
        FlowContainer flowContainer = new FlowContainer(0, true, true, 0, 0, size.x, size.y);
        for (int j = 0; j < row.size(); ++j) {
            Node child = row.getNode(j);
            if (child == null) continue;
            flowContainer.insertObjectAtPosition(child.getLayoutRect().x, child.getLayoutRect().y, child.getLayoutRect().cx, child.getLayoutRect().cy);
        }
        VMPoint extent = flowContainer.getExtent();
        size.x = Math.max(size.x, extent.x);
        size.y = Math.max(size.y, extent.y);
    }

    private void horizontallyAlignRows(Node node, Vector nodeRows, int parentCX, int parentCY, RenderState state) {
        for (int i = 1; i < nodeRows.size(); ++i) {
            NodeRow curRow = (NodeRow)nodeRows.elementAt(i);
            int rowStartChild = 0;
            this.horizontallyAlignRow(node, parentCX, curRow, rowStartChild, curRow.size(), state);
        }
    }

    private void horizontallyAlignRow(Node node, int parentCX, NodeRow children, int start, int limit, RenderState state) {
        int totalWidth = 0;
        int halign = node.getType() == 3 ? node.getHorizontalAlign() : 0;
        for (int i = start; i < limit; ++i) {
            totalWidth += children.getNode((int)i).getLayoutRect().cx + children.getNode(i).getMargin();
            if (children.getNode(i).getHorizontalAlign() == 0 || node.getType() == 3) continue;
            halign = children.getNode(i).getHorizontalAlign();
        }
        if (totalWidth <= 0) {
            return;
        }
        int offsetX = 0;
        switch (halign) {
            case 2: {
                offsetX = (parentCX - totalWidth) / 2;
                break;
            }
            case 1: {
                offsetX = parentCX - totalWidth;
            }
        }
        if (offsetX == 0) {
            return;
        }
        for (int i = start; i < limit; ++i) {
            int x;
            Node child = children.getNode(i);
            VMRect rect = child.getLayoutRect();
            if (child.isFullWidth()) {
                x = 0;
                rect.cx = Math.max(rect.cx, parentCX);
            } else {
                x = rect.x + offsetX;
                if (x < 0) break;
            }
            child.setLayout(x, rect.y, rect.cx, rect.cy, state);
        }
    }

    @Override
    public void layout2(Node node, RenderState state, int x, int y) throws CMException {
    }

    @Override
    public int layoutType() {
        return 0;
    }

    private class NodeRow {
        public Vector nodes;
        public VMPoint rowSize = new VMPoint(0, 0);

        public NodeRow() {
        }

        public NodeRow(int ny) {
        }

        public void addNode(Node node) {
            if (this.nodes == null) {
                this.nodes = new Vector();
            }
            this.nodes.addElement(node);
            VMRect nodeRect = node.getLayoutRect();
            this.rowSize.x += nodeRect.cx;
            this.rowSize.y = Math.max(this.rowSize.y, nodeRect.cy);
        }

        public Node getNode(int nodePos) {
            try {
                return (Node)this.nodes.elementAt(nodePos);
            }
            catch (Exception e) {
                return null;
            }
        }

        public int size() {
            if (this.nodes != null) {
                return this.nodes.size();
            }
            return 0;
        }
    }
}

