/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.layout;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.layout.ILayout;
import com.cognos.mobile.vm.render.RenderState;

public class StackLayout
implements ILayout {
    private static StackLayout horizontalInstance = null;
    private static StackLayout verticalInstance = null;
    private boolean isVertical;

    public static StackLayout horizontalInstance() {
        if (horizontalInstance == null) {
            horizontalInstance = new StackLayout(false);
        }
        return horizontalInstance;
    }

    public static StackLayout verticalInstance() {
        if (verticalInstance == null) {
            verticalInstance = new StackLayout(true);
        }
        return verticalInstance;
    }

    public StackLayout(boolean isVertical) {
        this.isVertical = isVertical;
    }

    @Override
    public void layout(Node node, RenderState state, int x, int y) throws CMException {
        int childCount = node.getChildCount();
        int margin = node.getMargin();
        if (childCount == 0) {
            int cx = node.getPreferredSize((RenderState)state).x;
            int cy = node.getPreferredSize((RenderState)state).y;
            node.setLayout(margin + x, margin + y, cx, cy, state);
        } else {
            Node child;
            int i;
            int cx = 0;
            int cy = 0;
            for (i = 0; i < childCount; ++i) {
                child = node.getChild(i);
                child.layout(state, 0, 0);
            }
            for (i = 0; i < childCount; ++i) {
                child = node.getChild(i);
                if (this.isVertical) {
                    cx = Math.max(cx, child.getLayoutRect().cx);
                    cy += child.getLayoutRect().cy;
                    if (i == 0) continue;
                    cy += child.getMargin();
                    continue;
                }
                cx += child.getLayoutRect().cx;
                cy = Math.max(cy, child.getLayoutRect().cy);
                if (i == 0) continue;
                cx += child.getMargin();
            }
            node.setLayout(margin + x, margin + y, cx + 2 * margin, cy + 2 * margin, state);
            x += margin;
            y += margin;
            for (i = 0; i < childCount; ++i) {
                child = node.getChild(i);
                if (i != 0) {
                    if (this.isVertical) {
                        y += child.getMargin();
                    } else {
                        x += child.getMargin();
                    }
                }
                int childX = 0;
                int childY = 0;
                int childCX = child.getLayoutRect().cx;
                int childCY = child.getLayoutRect().cy;
                if (this.isVertical) {
                    switch (child.getHorizontalAlign()) {
                        case 0: {
                            childX = 0;
                            break;
                        }
                        case 2: {
                            childX = (cx - childCX) / 2;
                            break;
                        }
                        case 1: {
                            childX = cx - childCX;
                        }
                    }
                } else {
                    switch (child.getVerticalAlign()) {
                        case 0: {
                            childY = 0;
                            break;
                        }
                        case 1: {
                            childY = (cy - childCY) / 2;
                            break;
                        }
                        case 2: {
                            childY = cy - childCY;
                        }
                    }
                }
                child.setLayout(x + childX, y + childY, childCX, childCY, state);
                if (this.isVertical) {
                    y += childCY;
                    continue;
                }
                x += childCX;
            }
        }
    }

    @Override
    public void layout2(Node node, RenderState state, int x, int y) throws CMException {
    }

    @Override
    public int layoutType() {
        return 1;
    }
}

