/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.layout;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.layout.ILayout;
import com.cognos.mobile.vm.node.CellNode;
import com.cognos.mobile.vm.node.TableNode;
import com.cognos.mobile.vm.node.TablePartNode;
import com.cognos.mobile.vm.render.RenderState;

public class TableLayout
implements ILayout {
    private static final Class CLASS = TableLayout.class;
    private static final double MAX_CELL_WIDTH = 560.0;
    private static TableLayout singleton = null;

    public static TableLayout instance() {
        if (singleton == null) {
            singleton = new TableLayout();
        }
        return singleton;
    }

    @Override
    public void layout(Node node, RenderState state, int x, int y) throws CMException {
        TableNode table = (TableNode)node;
        TablePartNode topLeftPart = table.getTopLeftPart();
        TablePartNode topPart = table.getTopPart();
        TablePartNode leftPart = table.getLeftPart();
        TablePartNode mainPart = table.getMainPart();
        if (mainPart == null) {
            throw new CMException(1202, "table has no main part");
        }
        if (topLeftPart != null) {
            topLeftPart.layout(state, 0, 0);
        }
        if (topPart != null) {
            topPart.layout(state, 0, 0);
        }
        if (leftPart != null) {
            leftPart.layout(state, 0, 0);
        }
        mainPart.layout(state, 0, 0);
        if (topLeftPart != null) {
            this.updateHeightsAndWidths(table, topLeftPart, state);
        }
        if (topPart != null) {
            this.updateHeightsAndWidths(table, topPart, state);
        }
        if (leftPart != null) {
            this.updateHeightsAndWidths(table, leftPart, state);
        }
        this.updateHeightsAndWidths(table, mainPart, state);
        if (VM.wouldLog(CLASS, 0)) {
            int i;
            VM.log(CLASS, 0, "table geometries:");
            for (i = 0; i < table.getRowCount(); ++i) {
                VM.log(CLASS, 0, "- row [" + i + "].height=" + table.getRowHeight(i));
            }
            for (i = 0; i < table.getColumnCount(); ++i) {
                VM.log(CLASS, 0, "- column [" + i + "].width=" + table.getColumnWidth(i));
            }
        }
        if (topLeftPart != null) {
            this.positionCells(table, topLeftPart, state, 0, 0, false);
        }
        if (topPart != null) {
            this.positionCells(table, topPart, state, 0, 0, false);
        }
        if (leftPart != null) {
            this.positionCells(table, leftPart, state, 0, 0, false);
        }
        this.positionCells(table, mainPart, state, 0, 0, false);
        int margin = table.getMargin();
        table.setLayout(x + margin, y + margin, mainPart.getLayoutRect().getRight(), mainPart.getLayoutRect().getBottom(), state);
    }

    private void updateHeightsAndWidths(TableNode table, TablePartNode part, RenderState state) {
        for (int i = 0; i < part.getChildCount(); ++i) {
            CellNode cell = (CellNode)part.getChild(i);
            this.updateHeights(table, cell);
            this.updateWidths(table, cell, state);
        }
    }

    private void updateHeights(TableNode table, TablePartNode part) {
        for (int i = 0; i < part.getChildCount(); ++i) {
            CellNode cell = (CellNode)part.getChild(i);
            this.updateHeights(table, cell);
        }
    }

    private void updateHeights(TableNode table, CellNode cell) {
        int cy;
        int rowspan = Math.max(cell.getRowspan(), 1);
        int n = cy = cell.getChildCount() > 0 ? cell.getLayoutRect().cy / rowspan : 0;
        if (rowspan == 1) {
            table.updateRowHeight(cell.getRow(), cy);
        }
    }

    private void updateWidths(TableNode table, CellNode cell, RenderState state) {
        int colspan = Math.max(cell.getColspan(), 1);
        int defaultCX = cell.getLayoutRect().cx / colspan;
        int cx = cell.hasTextNodeChild() ? (state.getWidth(cell) > 0 || table.checkStyle(4096) ? defaultCX : Math.min((int)(560.0 * state.getZoomScale()), defaultCX)) : defaultCX;
        if (colspan == 1) {
            table.updateColumnWidth(cell.getColumn(), cx);
        }
    }

    private void positionCells(TableNode table, TablePartNode part, RenderState state, int x, int y, boolean layoutEnd) {
        int i;
        for (i = 0; i < part.getStartRow(); ++i) {
            y += table.getRowHeight(i);
        }
        for (i = 0; i < part.getStartColumn(); ++i) {
            x += table.getColumnWidth(i);
        }
        if (VM.wouldLog(CLASS, 0)) {
            VM.log(CLASS, 0, "part starts at " + CMStringHelper.formatPoint(x, y));
        }
        VMRect partRect = new VMRect(x, y, 1, 1);
        for (int i2 = 0; i2 < part.getChildCount(); ++i2) {
            CellNode cell = (CellNode)part.getChild(i2);
            VMRect cellExtent = new VMRect();
            cellExtent.x = x;
            cellExtent.y = y;
            for (int colIndex = part.getStartColumn(); colIndex < cell.getColumn(); ++colIndex) {
                cellExtent.x += table.getColumnWidth(colIndex);
            }
            for (int rowIndex = part.getStartRow(); rowIndex < cell.getRow(); ++rowIndex) {
                cellExtent.y += table.getRowHeight(rowIndex);
            }
            int colspan = Math.min(cell.getColspan(), table.getColumnCount() - cell.getColumn());
            for (int span = 0; span < colspan; ++span) {
                cellExtent.cx += table.getColumnWidth(cell.getColumn() + span);
            }
            int rowspan = Math.min(cell.getRowspan(), table.getRowCount() - cell.getRow());
            for (int span = 0; span < rowspan; ++span) {
                cellExtent.cy += table.getRowHeight(cell.getRow() + span);
            }
            cell.setLayout(cellExtent.x - partRect.x, cellExtent.y - partRect.y, cellExtent.cx, cellExtent.cy, state);
            if (layoutEnd) {
                cell.transferToRenderRect(state.isZoomed());
            }
            int cx = cellExtent.getRight() - partRect.x;
            int cy = cellExtent.getBottom() - partRect.y;
            partRect.cx = Math.max(partRect.cx, cx);
            partRect.cy = Math.max(partRect.cy, cy);
        }
        part.setLayout(partRect.x, partRect.y, partRect.cx, partRect.cy, state);
        if (layoutEnd) {
            part.transferToRenderRect(state.isZoomed());
        }
    }

    @Override
    public void layout2(Node node, RenderState state, int x, int y) throws CMException {
        TableNode table = (TableNode)node;
        TablePartNode topLeftPart = table.getTopLeftPart();
        TablePartNode topPart = table.getTopPart();
        TablePartNode leftPart = table.getLeftPart();
        TablePartNode mainPart = table.getMainPart();
        if (topLeftPart != null) {
            this.updateHeights(table, topLeftPart);
        }
        if (topPart != null) {
            this.updateHeights(table, topPart);
        }
        if (leftPart != null) {
            this.updateHeights(table, leftPart);
        }
        this.updateHeights(table, mainPart);
        if (topLeftPart != null) {
            this.positionCells(table, topLeftPart, state, 0, 0, true);
        }
        if (topPart != null) {
            this.positionCells(table, topPart, state, 0, 0, true);
        }
        if (leftPart != null) {
            this.positionCells(table, leftPart, state, 0, 0, true);
        }
        this.positionCells(table, mainPart, state, 0, 0, true);
        table.setLayout(x, y, mainPart.getLayoutRect().getRight(), mainPart.getLayoutRect().getBottom(), state);
    }

    @Override
    public int layoutType() {
        return 2;
    }
}

