/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.vm.IKeyHandler;
import com.cognos.mobile.vm.INodeVisibility;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMColor;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.node.RowColumnFocusBuilder;
import com.cognos.mobile.vm.node.TableNode;
import com.cognos.mobile.vm.node.TablePartNode;
import com.cognos.mobile.vm.node.TextNode;
import com.cognos.mobile.vm.render.RenderState;

public class CellNode
extends Node {
    private static final Class CLASS = CellNode.class;
    public static final int MAX_DATATABLE_CELL_WIDTH = 560;
    private static final int CX_MARK = 8;
    private int column;
    private int row;
    private int colspan;
    private int rowspan;

    public CellNode(int colspan, int rowspan) {
        super(3, 16);
        this.column = -1;
        this.row = -1;
        this.colspan = colspan;
        this.rowspan = rowspan;
    }

    public CellNode(CellNode other) {
        super(other);
        this.column = other.column;
        this.row = other.row;
        this.colspan = other.colspan;
        this.rowspan = other.rowspan;
        this.clearStyle(4032, false);
    }

    public TableNode getTable() {
        if (this.getParent() == null || this.getParent().getType() != 7) {
            return null;
        }
        TablePartNode tablePartNode = (TablePartNode)this.getParent();
        if (tablePartNode.getParent() == null || tablePartNode.getParent().getType() != 2) {
            return null;
        }
        TableNode tableNode = (TableNode)tablePartNode.getParent();
        return tableNode;
    }

    public TablePartNode getTablePart() {
        if (this.getParent() == null || this.getParent().getType() != 7) {
            return null;
        }
        TablePartNode tablePartNode = (TablePartNode)this.getParent();
        return tablePartNode;
    }

    public void setSpans(int colspan, int rowspan) {
        this.colspan = colspan;
        this.rowspan = rowspan;
    }

    public void setColumnAndRow(int column, int row) {
        this.column = column;
        this.row = row;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public int getColspan() {
        return this.colspan;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public void reduceRowSpan() {
        if (this.rowspan > 1) {
            --this.rowspan;
        }
    }

    public void reduceColumnSpan() {
        if (this.colspan > 1) {
            --this.colspan;
        }
    }

    public boolean hasTextNodeChild() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!(this.getChild(i) instanceof TextNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean checkStyle(int styleMask) {
        if (styleMask == 4096 && this.getTable() != null) {
            return this.getTable().checkStyle(styleMask);
        }
        return super.checkStyle(styleMask);
    }

    @Override
    public VMPoint getMaxSize(RenderState state) {
        boolean layout;
        TableNode table = this.getTable();
        boolean bl = layout = table != null && table.checkStyle(4096);
        int cx = state.getWidth(this) > 0 ? state.getWidth(this) : (layout ? 0 : (int)(560.0 * state.getZoomScale()));
        VMPoint maxSize = new VMPoint(cx, 0);
        if (!layout) {
            maxSize.x = Math.max(10, maxSize.x);
        }
        return maxSize;
    }

    @Override
    public void setPreferredSize(int cx, int cy, RenderState state) {
        if (state.getWidth(this) > 0) {
            cx = state.getWidth(this);
        }
        this.getLayoutRect().ensureMinimumSize(cx, cy);
    }

    @Override
    public int getMargin() {
        return 0;
    }

    @Override
    public void onPaintEnd(RenderState state) {
        VMRect rect = this.getRenderRect(state);
        int cellX = 0;
        int cellY = 0;
        int cellCx = rect.cx;
        int cellCy = rect.cy;
        TableNode thisTable = this.getTable();
        if (!thisTable.checkStyle(4096)) {
            if (!this.isLastColumn()) {
                ++cellCx;
            }
            if (!this.isLastRow()) {
                ++cellCy;
            }
        }
        int[] borderColor = state.getBorderColors();
        state.painter.drawRect(state.getBorderDisplay(), borderColor, cellX, cellY, cellCx, cellCy);
        if (this.checkStyle(131072)) {
            state.painter.setColor(VMColor.MARK_COLOR);
            int right = rect.cx;
            for (int y = 1; y < 8; ++y) {
                int x = right - (8 - y);
                state.painter.drawLine(x, y, right, y);
            }
        }
    }

    @Override
    public Node createFocusTree(Node parent, int focus, VMScene.Hints hints) throws CMException {
        TableNode focusTable = null;
        switch (focus) {
            case 1: {
                focusTable = RowColumnFocusBuilder.buildRowFocusTable(parent, hints, this);
                break;
            }
            case 2: {
                focusTable = RowColumnFocusBuilder.buildColumnFocusTable(parent, hints, this);
                break;
            }
            default: {
                VM.log(CLASS, 3, "unsupported table cell focus");
            }
        }
        return focusTable;
    }

    @Override
    public Node cloneNode() {
        return new CellNode(this);
    }

    @Override
    public boolean isSelectable() {
        TableNode table = this.getTable();
        if (table == null) {
            return false;
        }
        return !table.checkStyle(4096);
    }

    @Override
    public INodeVisibility getVisibility() {
        TableNode table = this.getTable();
        if (table == null) {
            return super.getVisibility();
        }
        return table.getTableVisibility();
    }

    @Override
    public IKeyHandler getKeyHandler() {
        TableNode table = this.getTable();
        if (table == null) {
            return super.getKeyHandler();
        }
        return table.getTableKeyHandler();
    }

    @Override
    public String getLogLine(int format, VMRect clipRect, boolean trimmed, RenderState state) {
        StringBuffer sb = new StringBuffer();
        if (format == VM.LOGTREEFORMAT_CSV) {
            sb.append("cell\"");
        } else {
            sb.append("cell " + this.column + "," + this.row + " ");
            if (this.colspan != 1 || this.rowspan != 1) {
                sb.append("span=" + CMStringHelper.formatPoint(this.colspan, this.rowspan) + " ");
            }
        }
        sb.append(super.getLogLine(format, clipRect, trimmed, state));
        return sb.toString();
    }

    @Override
    public void paint(RenderState state) throws CMException {
        TableNode table = this.getTable();
        if (table != null && !table.isScrolling() && state.getExec() != 11) {
            if (this.isVisible(state)) {
                super.paint(state);
            }
        } else {
            super.paint(state);
        }
    }

    private boolean isLastColumn() {
        TableNode table = this.getTable();
        return this.getColumn() == table.getColumnCount() - 1;
    }

    private boolean isLastRow() {
        TableNode table = this.getTable();
        return this.getRow() == table.getRowCount() - 1;
    }
}

