/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.vm.IKeyHandler;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.node.TableNode;

public class DefaultKeyHandler
implements IKeyHandler {
    private static final Class CLASS = DefaultKeyHandler.class;
    protected VMScene scene;

    public DefaultKeyHandler(VMScene scene) {
        this.scene = scene;
    }

    @Override
    public boolean sendKey(int key, int flags) {
        Node oldSelectedNode = this.scene.getSelection().getSelectedNode();
        if (oldSelectedNode != null && oldSelectedNode.getType() == 5) {
            switch (key) {
                case 7: {
                    key = 4;
                    break;
                }
                case 8: {
                    key = 3;
                }
            }
        }
        int optionalFlags = 0;
        switch (key) {
            case 1: {
                flags |= 0x20;
                optionalFlags = 8;
                break;
            }
            case 4: 
            case 7: {
                flags |= 8;
                optionalFlags = 32;
                break;
            }
            case 2: {
                flags |= 0x40;
                optionalFlags = 16;
                break;
            }
            case 3: 
            case 8: {
                flags |= 0x10;
                optionalFlags = 64;
            }
        }
        if (oldSelectedNode != null && (flags & 4) != 0) {
            int visibleSides = oldSelectedNode.getVisibility().getVisibleSides(oldSelectedNode);
            boolean shouldScrollPage = false;
            switch (flags & 0x78) {
                case 32: {
                    if ((visibleSides & 1) != 0) break;
                    shouldScrollPage = true;
                    break;
                }
                case 8: {
                    if ((visibleSides & 2) != 0) break;
                    shouldScrollPage = true;
                    break;
                }
                case 64: {
                    if ((visibleSides & 4) != 0) break;
                    shouldScrollPage = true;
                    break;
                }
                case 16: {
                    if ((visibleSides & 8) != 0) break;
                    shouldScrollPage = true;
                }
            }
            if (shouldScrollPage) {
                this.scrollPage(flags, 0);
                return true;
            }
        }
        int oldViewportX = this.scene.viewport.x;
        int oldViewportY = this.scene.viewport.y;
        Node newSelectedNode = null;
        if ((newSelectedNode = this.selectNextNode(key, flags, newSelectedNode)) instanceof TableNode && ((TableNode)newSelectedNode).allNodesHasEmptyText()) {
            newSelectedNode = this.selectNextNode(key, flags, newSelectedNode);
        }
        if (newSelectedNode != null) {
            VM.log(CLASS, 1, "new selection: " + newSelectedNode.toString());
        } else {
            VM.log(CLASS, 1, "new selection: NULL");
        }
        if (oldSelectedNode == newSelectedNode && oldViewportX == this.scene.viewport.x && oldViewportY == this.scene.viewport.y) {
            this.scrollPage(flags, optionalFlags);
        } else if (newSelectedNode != null) {
            this.scene.setTooltip(newSelectedNode.getLabel());
            int estimatedToolMaxTipHeight = 20;
            int screenBottom = this.scene.viewport.getViewportHeight() - this.scene.viewport.getScrollY();
            if (newSelectedNode.getLabel() != null && newSelectedNode.getLabel().length() > 0 && newSelectedNode.getRect().y + newSelectedNode.getRect().cy + estimatedToolMaxTipHeight > screenBottom) {
                this.scrollPage(16, 0);
            }
        }
        return true;
    }

    private Node selectNextNode(int key, int flags, Node newSelectedNode) {
        switch (key) {
            case 5: {
                newSelectedNode = this.scene.getSelection().selectFirst(1, flags);
                break;
            }
            case 6: {
                newSelectedNode = this.scene.getSelection().selectFirst(-1, flags);
                break;
            }
            case 4: {
                newSelectedNode = this.scene.getSelection().selectNext(-1, flags, false);
                break;
            }
            case 1: {
                newSelectedNode = this.scene.getSelection().selectRight(-1, flags);
                break;
            }
            case 7: {
                newSelectedNode = this.scene.getSelection().selectDown(-1, flags);
                if (newSelectedNode != null) break;
                newSelectedNode = this.scene.getSelection().selectNext(-1, flags, false);
                break;
            }
            case 3: {
                newSelectedNode = this.scene.getSelection().selectNext(1, flags, false);
                break;
            }
            case 2: {
                newSelectedNode = this.scene.getSelection().selectRight(1, flags);
                break;
            }
            case 8: {
                newSelectedNode = this.scene.getSelection().selectDown(1, flags);
                if (newSelectedNode != null) break;
                newSelectedNode = this.scene.getSelection().selectNext(1, flags, false);
            }
        }
        return newSelectedNode;
    }

    public boolean scrollPage(int preferredFlags, int optionalFlags) {
        for (int i = 0; i < 2; ++i) {
            int flags = 0;
            switch (i) {
                case 0: {
                    flags = preferredFlags;
                    break;
                }
                case 1: {
                    flags = optionalFlags;
                }
            }
            if (flags == 0) continue;
            int dx = 0;
            int dy = 0;
            switch (flags & 0x78) {
                case 32: {
                    dx = this.scene.viewport.getViewportWidth() / 4;
                    break;
                }
                case 8: {
                    dy = this.scene.viewport.getViewportHeight() / 4;
                    break;
                }
                case 64: {
                    dx = -this.scene.viewport.getViewportWidth() / 4;
                    break;
                }
                case 16: {
                    dy = -this.scene.viewport.getViewportHeight() / 4;
                }
            }
            int newX = this.scene.viewport.x + dx;
            int newY = this.scene.viewport.y + dy;
            boolean scrolled = this.scene.viewport.scrollTo(newX, newY);
            if (!scrolled) continue;
            if (this.scene.getHost() != null) {
                this.scene.getHost().onSceneInvalidateRect(this.scene, null);
            }
            return true;
        }
        return false;
    }
}

