/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.vm.IMouseHandler;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMScene;

public class DefaultMouseHandler
implements IMouseHandler {
    private static final Class CLASS = DefaultMouseHandler.class;
    protected static final int CLICK_HYSTERESIS = 3;
    protected VMScene scene;
    protected boolean isMouseDown;
    protected int mouseDownX;
    protected int mouseDownY;
    protected int viewportDownX;
    protected int viewportDownY;

    public DefaultMouseHandler(VMScene scene) {
        this.scene = scene;
        this.isMouseDown = false;
    }

    @Override
    public void sendMouse(int mouse, int x, int y) {
        switch (mouse) {
            case 1: {
                this.sendMouseDown(x, y);
                break;
            }
            case 2: {
                this.sendMouseMove(x, y);
                break;
            }
            case 3: {
                this.sendMouseUp(x, y);
                break;
            }
            default: {
                VM.log(CLASS, 3, "invalid mouse constant: " + mouse);
            }
        }
    }

    private void sendMouseDown(int x, int y) {
        this.isMouseDown = true;
        this.mouseDownX = x;
        this.mouseDownY = y;
        this.viewportDownX = this.scene.getViewport().x;
        this.viewportDownY = this.scene.getViewport().y;
    }

    private void sendMouseMove(int x, int y) {
        if (!this.isMouseDown) {
            return;
        }
        if (!this.scene.getViewport().isScrollable()) {
            return;
        }
        int dx = x - this.mouseDownX;
        int dy = y - this.mouseDownY;
        int newX = this.viewportDownX + dx;
        int newY = this.viewportDownY + dy;
        if (this.scene.getViewport().scrollTo(newX, newY) && this.scene.getHost() != null) {
            this.scene.getHost().onSceneInvalidateRect(this.scene, null);
        }
    }

    private void sendMouseUp(int x, int y) {
        boolean isClick;
        this.isMouseDown = false;
        int dx = Math.abs(this.mouseDownX - x);
        int dy = Math.abs(this.mouseDownY - y);
        boolean bl = isClick = dx <= 3 && dy <= 3;
        if (isClick) {
            x = this.scene.getViewport().physicalToLogicalX(x);
            y = this.scene.getViewport().physicalToLogicalY(y);
            this.scene.getSelection().selectByPoint(x, y, 1);
        }
    }
}

