/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.vm.INodeVisibility;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.render.RenderState;

public class DefaultNodeVisibility
implements INodeVisibility {
    private static INodeVisibility instance = null;

    public static INodeVisibility instance() {
        if (instance == null) {
            instance = new DefaultNodeVisibility();
        }
        return instance;
    }

    @Override
    public int getVisibleSides(Node node) {
        VMRect viewRect = node.getScene().getViewport().getViewportRect();
        VMRect nodeRect = node.getAbsoluteRect();
        int flags = 0;
        if (viewRect.pointInRect(nodeRect.x, viewRect.y)) {
            flags |= 1;
        }
        if (viewRect.pointInRect(viewRect.x, nodeRect.y)) {
            flags |= 2;
        }
        if (viewRect.pointInRect(nodeRect.x + nodeRect.cx - 1, viewRect.y)) {
            flags |= 4;
        }
        if (viewRect.pointInRect(viewRect.x, nodeRect.y + nodeRect.cy - 1)) {
            flags |= 8;
        }
        return flags;
    }

    @Override
    public boolean ensureNodeVisible(Node node, boolean fullyVisible, int dir, boolean allowSnap) {
        boolean needUpdate;
        boolean changed = false;
        int visibleSides = this.getVisibleSides(node);
        switch (visibleSides) {
            case 0: {
                needUpdate = true;
                break;
            }
            default: {
                needUpdate = fullyVisible;
                break;
            }
            case 15: {
                needUpdate = false;
            }
        }
        if (needUpdate) {
            if (node.getParent() != null && this.ensureNodeVisible(node.getParent(), false, dir, allowSnap)) {
                changed = true;
            }
            VMRect rect = node.getAbsoluteRect();
            if (node.getScene().getViewport().ensureRectVisible(rect, dir, allowSnap)) {
                changed = true;
            }
        }
        return changed;
    }

    @Override
    public boolean isVisible(Node node, RenderState state) {
        VMRect viewRect = node.getScene().getViewport().getViewportRect();
        VMRect nodeRect = node.getAbsoluteRect(state);
        if (nodeRect.x > viewRect.x + viewRect.cx) {
            return false;
        }
        if (nodeRect.y > viewRect.y + viewRect.cy) {
            return false;
        }
        if (nodeRect.x + nodeRect.cx < viewRect.x) {
            return false;
        }
        return nodeRect.y + nodeRect.cy >= viewRect.y;
    }
}

