/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.vm.node;

import com.cognos.mobile.vm.IKeyHandler;
import com.cognos.mobile.vm.IMouseHandler;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;
import com.cognos.mobile.vm.node.DefaultMouseHandler;
import com.cognos.mobile.vm.node.SpotKeyHandler;
import com.cognos.mobile.vm.node.SpotMouseHandler;
import com.cognos.mobile.vm.render.RenderState;

public class GroupNode
extends Node {
    public static final int GROUPTYPE_NULL = 0;
    public static final int GROUPTYPE_EXPLICIT = 1;
    public static final int GROUPTYPE_HEADER = 2;
    public static final int GROUPTYPE_FOOTER = 3;
    public static final int GROUPTYPE_IMAGE = 4;
    public static final int GROUPTYPE_CHART = 5;
    private final int groupType;
    private SpotKeyHandler keyHandler;
    private DefaultMouseHandler mouseHandler;

    public GroupNode(int groupType) {
        super(4, 524328);
        this.groupType = groupType;
    }

    public GroupNode(GroupNode other) {
        super(other);
        this.groupType = other.groupType;
    }

    public int getGroupType() {
        return this.groupType;
    }

    public IKeyHandler getSpotKeyHandler() {
        if (this.keyHandler == null && this.groupType == 5) {
            this.keyHandler = new SpotKeyHandler(this.getScene());
        }
        return this.keyHandler;
    }

    @Override
    public IMouseHandler getMouseHandler() {
        if (this.mouseHandler == null && this.groupType == 5) {
            this.mouseHandler = new SpotMouseHandler(this.getScene());
        }
        return this.mouseHandler;
    }

    @Override
    public Node cloneNode() {
        return new GroupNode(this);
    }

    @Override
    public String getLogLine(int format, VMRect clipRect, boolean trimmed, RenderState state) {
        StringBuffer sb = new StringBuffer();
        switch (this.groupType) {
            case 2: {
                sb.append("header");
                break;
            }
            case 3: {
                sb.append("footer");
                break;
            }
            case 4: {
                sb.append("image");
                break;
            }
            case 5: {
                sb.append("chart");
                break;
            }
            default: {
                sb.append("group");
            }
        }
        if (format == VM.LOGTREEFORMAT_CSV) {
            sb.append("\"");
        } else {
            sb.append(" ");
        }
        sb.append(super.getLogLine(format, clipRect, trimmed, state));
        return sb.toString();
    }

    @Override
    public boolean isSelectable() {
        return this.checkStyle(16384) || this.checkStyle(32768);
    }

    @Override
    public VMPoint getPreferredSize(RenderState state) {
        int cx = this.groupType == 2 || this.groupType == 3 ? (state.isLayoutToViewport() ? this.getScene().getViewport().getViewportWidth() : Math.max(this.getScene().getRootNode().getPreferredSizeX(), this.getPreferredSizeX())) : this.getPreferredSizeX();
        int cy = this.getPreferredSizeY();
        return new VMPoint(cx, cy);
    }

    @Override
    public void setLayout(int x, int y, int cx, int cy, RenderState state) {
        if ((this.groupType == 2 || this.groupType == 3) && state != null && state.isLayoutToViewport()) {
            cx = Math.max(this.getScene().getViewport().getViewportWidth() - x, cx);
        }
        super.setLayout(x, y, cx, cy, state);
    }

    @Override
    public boolean isFullWidth() {
        return this.groupType == 2 || this.groupType == 3;
    }

    @Override
    public boolean alwaysCheckCache() {
        return this.isSelectable();
    }
}

